# bard/plugs/uptime.py
#
#

""" uptime of services. """

## IMPORTS

from bard.utils import elapsed_days, str_day, error
from bard.runtime import kernel, fleet

import threading
import time

## UNTIL

def until(obj): 
    try: return elapsed_days(int(obj.sleep) - int(time.time() - obj._last))
    except: return ""

def upt(obj):
    try: return elapsed_days(int(time.time()) - int(obj._start))
    except: return ""

def waiting(obj):
    if sleeptime(obj): return "%s/%s" % (until(obj), sleeptime(obj))
    else: return ""

def idle(obj):
    try: return elapsed_days(int(obj._last - obj._start))
    except: return ""

def status(obj):
    try: return obj._status
    except: return ""

def name(obj):
    try: return obj._name
    except: return ""

def running(obj):
    try: return obj._running
    except: return ""

def sleeptime(obj):
    try: return elapsed_days(obj.sleep)
    except: return ""

def plugname(obj):
    try: return obj.plugname
    except: return ""

funcs = [status, upt, waiting]

## CMNDS

def uptime(event):
    global kernel
    for bot in fleet: event.reply("%s: %s %s" % (bot.type, status(bot), upt(bot)))
    for obj in threading.enumerate():
        if not running(obj): continue
        res = "%s: " % running(obj)
        for func in funcs:
            try: res += "%s " % func(obj)
            except: pass
        event.reply(res)
 
kernel.cmnds.register("uptime", uptime)
