from __future__ import absolute_import

from Crypto.Cipher import AES
from Crypto import Random
from Crypto.Protocol import KDF

try:
    from .__version__ import __version__
except ImportError:
    raise
    # Version file has not been autogenerated from build process:
    __version__ = None
    
def generate_salt():
    return Random.new().read(8)
    
def derive_key(password, salt):
     return KDF.PBKDF2(password, salt)
     
def encrypt(plaintext, key):
    iv = Random.new().read(AES.block_size)
    cipher = AES.new(key, AES.MODE_CFB, iv)
    ciphertext = iv + cipher.encrypt(plaintext)
    return ciphertext
    
def decrypt(ciphertext, key):
    iv = ciphertext[:AES.block_size]
    cipher = AES.new(key, AES.MODE_CFB, iv)
    plaintext = cipher.decrypt(ciphertext[AES.block_size:])
    return plaintext
    

