#!/usr/bin/env python

import os
import sys
from fabric.api import local, hide, settings
from fabric.colors import magenta, green
import beanstalk

command_name = os.path.split(os.path.splitext(__file__)[0])[-1]


def main():
    # get fab file
    beanstalk_install_path = os.path.split(sys.path[0])[0]
    beanstalk_package_path = os.path.join(beanstalk_install_path, 'beanstalk')
    fab_file_path = os.path.join(beanstalk_package_path, 'tasks/__init__.py')

    # Show usage
    if len(sys.argv) < 2:
        print magenta('Beanstalk-Stack man: %s' % command_name, bold=True)
        print 'Beanstalk-Stack version: %s' % beanstalk.__version__
        print ''
        print 'Usage: '
        print ''
        print '    %s command1:argument1-1,argument1-2 [command2:argument2-1,argument2-2 ...]' % command_name
        print '    %s --list' % command_name
        print ''
        with hide('running'):
            local('fab -f %s --list' % fab_file_path)
        print ''
        print 'Beanstalk-Stack is built with ' + green('Python-Fabric') + '.'
        print 'So you can pass all arguments for fabric to %s.' % command_name
        print ''
        sys.exit(1)

    # Go!
    tasks = sys.argv[1:]
    with settings(hide('running', 'warnings'), warn_only=True):
        local('fab -f %s -u sodas %s' % (fab_file_path, ' '.join(tasks)))


if __name__ == '__main__':
    main()
