package com.behaving.test.app.android_test_app;

import android.app.Activity;
import android.app.ActionBar;
import android.app.Fragment;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ScrollView;
import android.widget.TextView;
import android.os.Build;



public class MainActivity extends Activity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        if (savedInstanceState == null) {
            getFragmentManager().beginTransaction()
                    .add(R.id.container, new PlaceholderFragment())
                    .commit();
        }
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_settings) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    /**
     * A placeholder fragment containing a simple view.
     */
    public static class PlaceholderFragment extends Fragment {

        public PlaceholderFragment() {

        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container,
                Bundle savedInstanceState) {
            View rootView = inflater.inflate(R.layout.fragment_main, container, false);
            
            final TextView result = (TextView) rootView.findViewById(R.id.resultLabel);
            final EditText textInput = (EditText) rootView.findViewById(R.id.textInput);
            final ScrollView scrollView = (ScrollView) rootView.findViewById(R.id.scrollView1);
            final TextView scrollPosition = (TextView) rootView.findViewById(R.id.textView1);

        	Button calculateButton = (Button) rootView.findViewById(R.id.calculateButton);
        	calculateButton.setOnClickListener(new View.OnClickListener() {
				@Override
				public void onClick(View v) {
					
					Float input = new Float(textInput.getText().toString()) * 2;
					result.setText(input.toString());
				}
			});

            scrollView.setOnTouchListener(new View.OnTouchListener() {
                @Override
                public boolean onTouch(View view, MotionEvent motionEvent) {
                        scrollPosition.setText("" + scrollView.getScrollY());
                    return false;
                }
            });

            return rootView;
        }
    }
}
