Bélier
======

Introduction
------------
Bélier permet l'ouverture automatisée d'un terminal ou l'exécution de commandes sur un ordinateur distant via une connexion ssh. L'intérêt principal de Bélier réside dans sa capacité à traverser plusieurs machines intermédiaires avant d'accomplir la tâche assignée.

- Bélier rend transparent pour l'utilisateur la traversée par la connexion ssh d'éventuels ordinateurs intermédiaires sur le chemin de l'ordinateur distant. 
- Vous pouvez définir des commandes qui seront exécutées sur l'ordinateur distant.
- Les éventuels changements de compte sur les ordinateurs intermédiaires ou sur la machine finale peuvent être définis.
- Bélier génère 1 script par chemin nécessaire pour atteindre une machine finale.

Licence
-------
Bélier est distribué sous la licence GNU GPL troisième version.

Prérequis d'installation
-----------------------
- Python 2.4 ou une version supérieure.
- Expect 5.42.1 ou une version supérieure.

Debian :  installer les prérequis :
------------------------------
aptitude install python expect
------------------------------

Installation
------------
-----------------------
tar zxvf 
cd belier-1.0
su
python setup.py install
-----------------------

Easy_install
~~~~~~~~~~~~
Ce type d'installation requière d'avoir installé les Setuptools sur votre machine.
-------------------
easy_install belier
-------------------
TIP: Si vous avez déjà installé une version de bélier avec easy_install, il est nécessaire d'utiliser l'option --upgrade pour installer la version la plus récente.

Accès au code source
--------------------

Le code source de l'application est disponible via un dépôt git accessible par la ligne de commande suivante:

------------------------------------
git clone git://git.ohmytux.com/belier
------------------------------------

Exemples d'utilisation
---------------------

Ouvrir un terminal sur une machine distante en root de façon indirecte (PermitRootLogin No dans sshd_config)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Le fichier où nous entrons les informations nécessaires pour établir la connexion à distance : 
----------------------------
user@localhost:~$ cat ordres
admin@machine-finale Ic4r3 root jkw!po12;
-----------------------------------

La génération du script de connexion automatique grâce à bélier :
----------------------------------------
user@localhost:~$ bel --entree=ordres
user@localhost:~$ ls
user@localhost:~$ machine-finale.sh
-----------------------------------------------------

L'exécution du script généré (ici seule la première ligne est saisie par l'utilisateur, toutes les étapes suivantes sont automatiques) : 
-------------------------------------
user@localhost:~$ ./machine-finale.sh
spawn ssh machine-finale.sh
admin@machine-finale's password:
admin@machine-finale:~$ su - root
Password:
root@machine-finale:~#
---------------------- 

Dans notre exemple nous suivons plusieurs étapes :

. Nous créons un fichier nommé "ordres" contenant des lignes d'ordre.
.. La ligne du fichier "ordres" contient en premier champ le nom de l'utilisateur autorisé à se connecter en ssh ainsi que le nom d'hôte ou l'adresse ip de la machine sur laquelle on veut se connecter (les deux valeurs sont séparées par un '@'. Il est possible de n'indiquer que le nom d'hôte, auquel cas ssh essaiera de se connecter avec le nom de l'utilisateur sous lequel vous êtes connecté à votre ordinateur source).
.. Le second champ est le mot de passe pour se connecter à la machine cible. Optionnel si vous avez échangé vos clés ssh avec la machine destination.
.. Le troisième champ est le nom d'utilisateur sous lequel vous voulez passer sur le système distant (ici root).
.. Finalement le mot de passe pour le compte root.
. À ce stade, le script vous rend la main. Vous êtes connecté en tant que root à la machine finale.

Ouvrir un terminal sur une machine distante via plusieurs machines intermédiaires
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Le fichier où nous entrons les informations nécessaires pour établir la connexion à distance : 
----------------------------
user@localhost:~$ cat ordres
intermediaire1 admin azer0;lp!Z
admin@intermediaire2 
admin@machine-finale root jkw!po12;
-----------------------------------
TIP: vous pouvez définir plusieurs chemins vers différentes machines finales dans le même fichier. Il vous suffit de sauter une ligne entre deux suites d'ordres.
Bélier vous génèrera autant de scripts que de chemins ainsi définis.

La génération du script de connexion automatique grâce à bélier :
----------------------------------------
user@localhost:~$ bel --entree=ordres
user@localhost:~$ ls
user@localhost:~$ machine-finale.sh
-----------------------------------------------------

L'exécution du script généré (ici seule la première ligne est saisie par l'utilisateur, toutes les étapes suivantes sont automatiques) : 
-------------------------------------
user@localhost:~$ ./machine-finale.sh
spawn ssh intermediaire1
user@intermediaire1's password:
user@intermediaire1:~$ su - admin
Password: 
admin@intermediaire1:~$ ssh admin@intermediaire2
admin@intermediaire2:~$ ssh admin@machine-finale
admin@machine-finale's password:
admin@machine-finale:~$ su - root
Password:
root@machine-finale:~#
---------------------- 

Dans notre exemple nous suivons plusieurs étapes :

. Nous créons un fichier nommé "ordres" contenant des lignes d'ordre.
. Le premier ordre indique de se connecter d'abord au premier serveur intermédiaire et de changer d'utilisateur pour utiliser le compte admin.
. Le second ordre indique de se connecter avec l'identifiant admin au second serveur intérmédiaire.
. Le troisième ordre permet de se connecter avec l'identifiant admin à la machine finale puis fait passer l'utilisateur en root.
. À ce stade, le script vous rend la main. Vous êtes connecté en tant que root à la machine finale.

TIP: Afin de fermer le terminal distant pour revenir directement à votre terminal inital, il vous suffit de presser trois fois la touche "+".

Exécuter une commande sur une machine distante en tant que root
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Le fichier où nous entrons les informations nécessaires pour établir la connexion à distance : 
----------------------------
user@localhost:~$ cat ordres
intermediaire admin azer0;lp!Z
admin@machine-finale root !ZuP3r; -c
df -h
-----
TIP: vous pouvez définir plusieurs chemins vers différentes machines finales dans le même fichier. Il vous suffit de sauter une ligne entre deux suites d'ordres.

La génération du script de connexion automatique grâce à bélier :
----------------------------------------
user@localhost:~$ bel --entree=ordres
user@localhost:~$ ls
user@localhost:~$ machine-finale.sh
-----------------------------------

L'exécution du script généré (ici seule la première ligne est saisie par l'utilisateur, toutes les étapes suivantes sont automatiques) : 
-------------------------------------
user@localhost:~$ ./machine-finale.sh
spawn ssh intermediaire
user@intermediaire's password:
user@intermediaire:~$ su - admin
Password: 
admin@intermediaire:~$ ssh admin@machine-finale
admin@machine-finale's password:
admin@machine-finale:~$ su - root
Password:
root@machine-finale:~# df -h
Sys. de fich.            Tail. Occ. Disp. %Occ. Monté sur
/dev/sda2             453G   61G  393G  14% /
varrun                2,0G  112K  2,0G   1% /var/run
varlock               2,0G     0  2,0G   0% /var/lock
udev                  2,0G   48K  2,0G   1% /dev
devshm                2,0G   24K  2,0G   1% /dev/shm
lrm                   2,0G   36M  1,9G   2% /lib/modules/2.6.24-21-generic/volatile
root@machine-finale:~#
----------------------------------------------------------------------------------- 
WARNING: une commande lancée par l'utilisateur root est potentiellement destructrice. Tester la commande et avoir des sauvegardes est un prérequis indispensable.

Dans notre exemple nous suivons plusieurs étapes :

. Nous créons un fichier nommé "ordres" contenant les informations de connexion aux différentes machines et les commandes à passer sur la machine finale.
. Le premier ordre indique de se connecter d'abord au serveur intermédiaire et de changer d'utilisateur pour utiliser le compte admin.
. Le second ordre indique de se connecter avec l'identifiant admin à la machine finale puis fait passer l'utilisateur en root. Notons la présence du mot-clé -c qui signale que les prochaines lignes seront des commandes à exécuter sur la machine finale
. À ce stade, la commande voulue (df -h) s'exécute sur la machine finale et le script se termine.

À savoir sur les mots de passe
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Si l'un des mots de passe entré dans le fichier d'ordres contient un caractère d'espacement, il est nécessaire d'entourer votre mot de passe avec des guillemets français (caractère " ) : 
----------------------------
admin@serveur "M0t D2 Pass3"
----------------------------
Si vous avez entouré votre mot de passe avec des guillemets français et que vous avez également des guillemets dans votre mot de passe, il est nécessaire de les faire précéder par une barre oblique inversée (caractère \ ): 
------------------------------
admin@serveur "M0t \"D2 Pass3"
------------------------------

Recherche de qualité
--------------------
Depuis la version 0.4, Bélier est testé systématiquement (tests fonctionnels et link:http://fr.wikipedia.org/wiki/Test_de_non-régression[tests de non-régression]). Le code est relu par link:http://www.logilab.org/857[Pylint]. Le comportement de Bélier est également audité par l'excellent link:http://fusil.hachoir.org[Fusil] de Victor Stinner (suivre ce lien pour savoir ce qu'est un link:http://en.wikipedia.org/wiki/Fuzz_testing[fuzzer]), ce qui permet d'anticiper sur la découverte d'anomalie. Si malgré cela vous constatez un bug, j'accueille chaleureusement les temoignages et, soyons fous, les patches.

La dernière version stable est régulièrement testée avec succès sur les distributions suivantes : 

mailto:merci-d-utiliser-chaica@ohmytux.com['Carl Chenet']
