from zope.interface import implements #, directlyProvides

from Products.CMFCore.utils import getToolByName
from Products.CMFCore.permissions import View, ModifyPortalContent

from Products.Archetypes import atapi
from Products.ATContentTypes.content import folder
from Products.ATContentTypes.content import schemata
#from Products.ATContentTypes.configuration import zconf

from AccessControl import ClassSecurityInfo

#from Products.validation.config import validation
#from Products.validation.validators.SupplValidators import MaxSizeValidator
#from Products.validation import V_REQUIRED

from archetypes.memberdatastorage.memberpropertyfield import MemberPropertyField

from betahaus.memberprofile import MemberProfileMessageFactory as _
from betahaus.memberprofile.content.interfaces import IMemberProfile
from betahaus.memberprofile.config import PROJECTNAME
from betahaus.memberprofile.content import mixin
from betahaus.memberprofile.interfaces import IMemberProfileSettingsAdapter  



Schema = folder.ATFolderSchema.copy() + mixin.BaseProfile.schema.copy() + mixin.ImageMixin.schema.copy() + atapi.Schema((
    atapi.TextField(
        name='text',
        required=False,
        searchable=True,
        primary=True,
        storage = atapi.AnnotationStorage(migrate=True),
        validators = ('isTidyHtmlWithCleanup',),
        default_output_type = 'text/x-html-safe',
        widget = atapi.RichWidget(
                  label = _(u'Presentation of you'),
                  description = _(u''),
                  rows = 10
        ),
    ),
))

# Set storage on fields copied from ATContentTypeSchema, making sure
# they work well with the python bridge properties.

#Don't show content type in navigation portlets etc.
Schema['excludeFromNav'].default = True

# Title uses the fullname field instead so we preserve compatibility with Plones fullname property.
Schema['title'].storage = atapi.AnnotationStorage()
Schema['title'].searchable = True
#Schema['title'].widget.label = _(u'label_memberprofile_title', default=u'Your full name or display name')
Schema['title'].widget.visible = {'view':'invisible','edit':'invisible'}

# Description is used as biography in some views, 
# for instance personalize_form
Schema['description'].storage = atapi.AnnotationStorage() 
Schema['description'].searchable = False
Schema['description'].widget.label= _(u'label_memberprofile_description', default=u'Short biography or description')
Schema['description'].widget.description = _(u'Shown in listings and as description in searches.')

Schema.moveField('lastname', pos='top')
Schema.moveField('firstname', pos='top')

schemata.finalizeATCTSchema(Schema, moveDiscussion=False)

class MemberProfile(folder.ATFolder, mixin.BaseProfile, mixin.ImageMixin):
    """Member profile content type"""
    implements(IMemberProfile)
    security = ClassSecurityInfo()

    portal_type = meta_type = "MemberProfile"
    archetype_name = _(u'Member profile')
    schema = Schema


    security.declareProtected(View, 'getTitle')
    def getTitle(self):
        """Override accessor for title"""
        return self.Title()
    
    security.declareProtected(View, 'Title')
    def Title(self):
        """ Override accessor for title.
            This gets called lots of times on edit, even before schema init, hence the try-except.
            Watch out...
        """
        portal = getToolByName(self, 'portal_url', None)
        if portal is None:
            return ''
        portal = portal.getPortalObject()
        title_as = IMemberProfileSettingsAdapter(portal).get('title_as')
        if title_as == 'firstname_lastname':
            try:
                return "%s %s" % (self.getFirstname(),self.getLastname())
            except AttributeError:
                return ''
        #Use userid as title
        else:
            #FIXME: Is this a safe assumption?
            return self.Creator()
    
    security.declareProtected(ModifyPortalContent, 'setTitle')
    def setTitle(self, value, **kwargs):
        """Override mutator for title"""
        #FIXME: Catch this some way and use the tool?
        #Userid is immutable, firstname/lastname is already setable.
        pass

atapi.registerType(MemberProfile, PROJECTNAME)
