import codecs

from os import path
from setuptools import find_packages, setup


def read(*parts):
    filename = path.join(path.dirname(__file__), *parts)
    with codecs.open(filename, encoding="utf-8") as fp:
        return fp.read()


PACKAGE = "biblion"
NAME = "biblion"
DESCRIPTION = "a Django blog app"
AUTHOR = "Pinax Team"
AUTHOR_EMAIL = "team@pinaxproject.com"
URL = "https://github.com/pinax/biblion"


setup(
    name=NAME,
    version="2.6.0",
    description=DESCRIPTION,
    long_description=read("README.rst"),
    url=URL,
    license="MIT",
    packages=find_packages(),
    package_data={
        "biblion": [
            "templates/biblion/*.xml",
        ]
    },
    install_requires=[
        "django-appconf>=0.5",
        "Pillow>=2.0",
        "creole>=1.2",
        "Markdown>=2.4",
        "Pygments>=1.6"
    ],
    test_suite="runtests.runtests",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Web Environment",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python",
        "Framework :: Django",
        "Programming Language :: Python",
        "Programming Language :: Python :: 2",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ],
    zip_safe=False
)
