import os
from setuptools import setup
from setuptools import find_packages


# Utility function to read the README file.
# Used for the long_description.  It's nice, because now 1) we have a top level
# README file and 2) it's easier to type in the README file than to put a raw
# string in below ...
def read(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()

setup(
    name = "binomia_translatable_multilevel_menu",
    version = "0.0.3",
    author = read('AUTHORS'),
    author_email = "samuel.barrado@binomia.es",
    description = ("Simple translatable multilevel menu system."),
    license = "BSD",
    keywords = "translatable multilevel menu",
    url = "http://packages.python.org/binomia_translatable_multilevel_menu",
    packages=['menu', ],
    long_description=read('README'),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Topic :: Utilities",
        "License :: OSI Approved :: BSD License",
    ],
      
    zip_safe=False,
    #packages=find_packages(),
    include_package_data=True,
)