from django import template
from django.core.urlresolvers import reverse
import json


register = template.Library()


@register.simple_tag
def assets_redactor_image_upload(user):
    if user.has_perm('assets.change_image'):
        return json.dumps(reverse('blanc_basic_assets_redactor:upload-image'))
    else:
        return json.dumps(False)


@register.simple_tag
def assets_redactor_file_upload(user):
    if user.has_perm('assets.change_file'):
        return json.dumps(reverse('blanc_basic_assets_redactor:upload-file'))
    else:
        return json.dumps(False)
