import pygtk
pygtk.require("2.0")
import gtk
import gobject

import Boarded.configreader as configreader


RESIZE_AREA_SIZE = (25, 25)
MOVE_TRESHOLD = 20


class MiniIcon(gtk.Window):
  def __init__(self, config, *args, **kwargs):
    super(MiniIcon, self).__init__(*args, **kwargs)

    self.config = config

    self._button1_pressed = False
    self._button1_press_pos = (0, 0)
    self._button1_press_is_in_resize_area = False

    self.set_accept_focus(False)
    self.set_skip_taskbar_hint(True)
    self.set_keep_above(True)
    self.set_decorated(False)
    self.set_resizable(True)
    self.set_geometry_hints(self,
        50, 50,                     # min width, min height
        -1, -1,                     # max width, max height
        config["miniicon_size"][0],
        config["miniicon_size"][1], # base width, base height
         1,  1,                     # width, height - resize increment
        -1, -1,                     # min, max aspect ratio
       )
    self.set_border_width(0)
    self.set_app_paintable(True)

    self.move(*config["miniicon_pos"])
    self.resize(*config["miniicon_size"])

    self.add_events(gtk.gdk.BUTTON_PRESS_MASK|
                    gtk.gdk.BUTTON_RELEASE_MASK|
                    gtk.gdk.BUTTON1_MOTION_MASK)
    self.connect("expose_event", self._on_expose)
    self.connect("button_press_event", self._on_button_press)
    self.connect("button_release_event", self._on_button_release)
    self.connect("motion_notify_event", self._on_button1_motion)
    self.connect("configure_event", self._on_configure)

    self.fixbox = gtk.Fixed()
    self.add(self.fixbox)

    self.image_pb = None
    icon_theme = gtk.icon_theme_get_default()
    if icon_theme.has_icon("boarded"):
      try:
        self.image_pb = icon_theme.load_icon("boarded", 192, 0)
      except Exception:
        pass
    if not self.image_pb:
      self.image_pb = self.render_icon(gtk.STOCK_MISSING_IMAGE,
                                       gtk.ICON_SIZE_DIALOG)
    self.image = gtk.Image()
    self.fixbox.put(self.image, 0, 0)


  def _is_in_resize_area(self, pos):
    size = self.get_size()
    return size[0] - RESIZE_AREA_SIZE[0] < pos[0] and pos[0] < size[0] and \
           size[1] - RESIZE_AREA_SIZE[1] < pos[1] and pos[1] < size[1]


  def _on_configure(self, widget, event):
    size = self.get_size()
    scaled_pb = self.image_pb.scale_simple(size[0], size[1],
                                           gtk.gdk.INTERP_BILINEAR)
    self.image.set_from_pixbuf(scaled_pb)

  def _on_expose(self, widget, event):
    size = self.get_size()
    self.get_style().paint_resize_grip(self.window, gtk.STATE_NORMAL,
                                       None, self, None,
                                       gtk.gdk.WINDOW_EDGE_SOUTH_EAST,
                                       size[0] - RESIZE_AREA_SIZE[0],
                                       size[1] - RESIZE_AREA_SIZE[1],
                                       *RESIZE_AREA_SIZE)

  def _on_button_press(self, widget, event):
    self._button1_pressed = True
    self._button1_press_pos = (int(event.x_root), int(event.y_root))
    self._button1_press_is_in_resize_area = self._is_in_resize_area((int(event.x), int(event.y)))

  def _on_button1_motion(self, widget, event):
    if abs(event.x_root - self._button1_press_pos[0]) < MOVE_TRESHOLD and \
       abs(event.y_root - self._button1_press_pos[1]) < MOVE_TRESHOLD:
      return False

    if self._button1_press_is_in_resize_area:
      self.begin_resize_drag(gtk.gdk.WINDOW_EDGE_SOUTH_EAST, 1,
                             int(event.x_root), int(event.y_root), event.time)
    else:
      self.begin_move_drag(1, int(event.x_root), int(event.y_root), event.time)

  def _on_button_release(self, widget, event):
    if self.get_size() != self.config["miniicon_size"]:
      self.config["miniicon_size"] = self.get_size()
      configreader.save_properties(self.config)
    if self.get_position() != self.config["miniicon_pos"]:
      self.config["miniicon_pos"] = self.get_position()
      configreader.save_properties(self.config)

    if abs(event.x_root - self._button1_press_pos[0]) < MOVE_TRESHOLD and \
       abs(event.y_root - self._button1_press_pos[1]) < MOVE_TRESHOLD:
      self.do_hide()
      self.emit("activated")

    self._button1_pressed = False
    self._button1_press_is_in_resize_area = False
    self._button1_press_pos = (0, 0)


  def do_show(self):
    self.resize(*self.config["miniicon_size"])
    self.move(*self.config["miniicon_pos"])
    self.show_all()

  def do_hide(self):
    self.hide_all()


gobject.signal_new("activated", MiniIcon, gobject.SIGNAL_RUN_LAST,
                   gobject.TYPE_BOOLEAN, ())
