"""Provides i18n support for Boarded using the gettext module.  Tells
gettext where to find localized strings and creates an alias, _, that
maps to the gettext.gettext function.  This function will accept a
string and return a localized string for that string.
"""


import sys
import os
import glob
import gettext

from constants import LOCALE_DOMAIN


LOCALEDIRS = [os.path.join("..", "share", "locale"),
              os.path.join("..", "usr", "share", "locale"),
              os.path.join("/usr", "local", "share", "locale"),
              os.path.join("/usr", "share", "locale")]
LOCALEDIR = LOCALEDIRS[0]
for localedir in LOCALEDIRS:
  localedir = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])),
                           localedir)
  if glob.glob(os.path.join(localedir, "*", "LC_MESSAGES",
                            LOCALE_DOMAIN+".mo")):
    LOCALEDIR = localedir
    break
else:
  sys.stderr.write("Warning: no locales found!")
  localedir = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])),
                           LOCALEDIRS[0])
LOCALEDIR = os.path.normpath(LOCALEDIR)


_ = gettext.gettext

gettext.bindtextdomain(LOCALE_DOMAIN, LOCALEDIR)
gettext.textdomain(LOCALE_DOMAIN)
