import virtkey

from keyactions import ACTIONS, MODIFIERS


class KeyEmulator(object):
  def __init__(self):
    self.vk = virtkey.virtkey()
    self.mods = []

  def get_mods(self):
    return self.mods

  def get_key_event(self, key):
    actions = key.actions
    if "mod" in actions and actions["mod"] in MODIFIERS.keys():
      return "mod", actions["mod"]
    elif "action" in actions and actions["action"] in ACTIONS:
      return ACTIONS[actions["action"]]
    elif "keysym" in actions:
      return "keysym", actions["keysym"]
    elif "ordinal" in actions:
      return "ordinal", actions["ordinal"]
    elif "keycode" in actions:
      return "keycode", actions["keycode"]
    return None

  def key_action(self, action, t, k):
    #print "KEY ACTION:", action, t, k
    if t == "keysym":
      if action == "press":
        self.vk.press_keysym(k)
      elif action == "release":
        self.vk.release_keysym(k)
    elif t == "ordinal":
      if action == "press":
        self.vk.press_unicode(k)
      elif action == "release":
        self.vk.release_unicode(k)
    elif t == "mod":
      if action == "press" and k not in self.mods:
        self.vk.lock_mod(MODIFIERS[k])
        self.mods.append(k)
        #print "mods", self.mods
      elif action == "release" and k in self.mods:
        self.vk.unlock_mod(MODIFIERS[k])
        while k in self.mods:
          self.mods.remove(k)
        #print "mods", self.mods

  def key_down(self, key):
    evt = self.get_key_event(key)
    if evt is None:
      return
    self.key_action("press", *evt)

  def key_up(self, key):
    evt = self.get_key_event(key)
    if evt is None:
      return
    self.key_action("release", *evt)

  def shutdown(self):
    while self.mods:
      self.vk.unlock_mod(MODIFIERS[self.mods.pop()])
