# boek/definitie.py
#
#

""" definitie. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

import string
import socket
import os.path
import os
import re

## RUNTIME

homedir = os.path.expanduser("~") 
curdir = os.getcwd()
try: hostname = socket.getfqdn()
except: hostname = "localhost" 
port = 10102

## CONSTANTS

leapfactor = float(6*60*60)/float(365*24*60*60)

daylist = ["Date", "path"]

# Sat, 13 Oct 2012 11:18:45 -0700 (PDT)

dayformats = ["%Y-%m-%d %H:%M:%S", "%a, %d %m %Y %H:%M:%S", "%a, %d %m %Y %H:%M:%S %s (%s)", "%Y-%m-%d %H:%M:%S", "%Y-%m-%d", "%d-%m-%Y"]
dayshorts =  ["%H:%M:%S", "%H:%M"]
short_day = "(%s %s %s %s:%s:%s)"

basic_types= [ str, int, float, bool, None]

attributes = {}
subelements = {}

attributes['message'] = ['type', 'from', 'to', 'id']
subelements['message'] = ['subject', 'body', 'error', 'thread', 'x']

attributes['presence'] = ['type', 'from', 'to', 'id']
subelements['presence'] = ['show', 'status', 'priority', 'x']


attributes['iq'] = ['type', 'from', 'to', 'id']
subelements['iq'] = ['query', 'error']

## DEFINITIONS

timere = re.compile('(\S+)\s+(\S+)\s+(\d+)\s+(\d+):(\d+):(\d+)\s+(\d+)')
bdmonths = ['Bo', 'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']
monthint = {
            'Jan': 1,
            'Feb': 2,
            'Mar': 3,
            'Apr': 4,
            'May': 5,
            'Jun': 6,
            'Jul': 7,
            'Aug': 8,
            'Sep': 9,
            'Oct': 10,
            'Nov': 11,
            'Dec': 12
           }

dirmask = 0o700
filemask = 0o600
allowedchars = string.ascii_letters + string.digits + "_,-. \n" + string.punctuation
allowednamechars = string.ascii_letters + string.digits + '!.@'

## OPTIONS

opts_defs = [
              ('', '--debug', 'store_true', False, 'debug',  "enable debug mode"),
              ('-b', '--background', 'store_true', False, 'background',  "switch to background mode"),
              ('-o', '--openfire', 'store_true', False, 'openfire', 'use openfire to connect to XMPP.'),
              ('-s', '--shell', 'store_true', False, 'shell',  "shell mode."),
              ('-i', '--init', 'string', "", 'init',  "whether to initialize plugins."),
              ('-d', '--workdir', 'string',  os.path.expanduser(homedir + os.sep + "boek.data"), 'workdir',  "directory to work with."),
              ('-p', '--port', 'string', "10102", 'port',  "port to run API server on"),
              ('-l', '--meldinglevel', 'string', "error", 'meldinglevel',  "meldinglevel")
          ]

opts_defs_sed = [
              ('-d', '--dir', 'string', "", 'dir_sed',  "directory to work with."),
              ('-l', '--meldinglevel', 'string', "", 'meldinglevel',  "meldinglevel"),
          ]

opts_defs_udp = [
              ('-p', '--port', 'string', "10102", 'port',  "port to run API server on"),
              ('-l', '--meldinglevel', 'string', "", 'meldinglevel',  "meldinglevel"),
          ]

## COLORS

ERASE_LINE = '\033[2K'
BOLD='\033[1m'
RED = '\033[91m'
YELLOW = '\033[93m'
GREEN = '\033[92m'
BLUE = '\033[94m'
BLA = '\033[95m'
ENDC = '\033[0m'

## URLS

re_url_match  = re.compile('((?:http|https)://\S+)')

## POSTFIXCOUNT - how many arguments used in a IRC message

pfc = {}
pfc['NICK'] = 0
pfc['QUIT'] = 0
pfc['SQUIT'] = 1
pfc['JOIN'] = 0
pfc['PART'] = 1
pfc['TOPIC'] = 1
pfc['KICK'] = 2
pfc['PRIVMSG'] = 1
pfc['NOTICE'] = 1
pfc['SQUERY'] = 1
pfc['PING'] = 0
pfc['ERROR'] = 0
pfc['AWAY'] = 0
pfc['WALLOPS'] = 0
pfc['INVITE'] = 1
pfc['001'] = 1
pfc['002'] = 1
pfc['003'] = 1
pfc['004'] = 4
pfc['005'] = 15
pfc['302'] = 1
pfc['303'] = 1
pfc['301'] = 2
pfc['305'] = 1
pfc['306'] = 1
pfc['311'] = 5
pfc['312'] = 3
pfc['313'] = 2
pfc['317'] = 3
pfc['318'] = 2
pfc['319'] = 2
pfc['314'] = 5
pfc['369'] = 2
pfc['322'] = 3
pfc['323'] = 1
pfc['325'] = 3
pfc['324'] = 4
pfc['331'] = 2
pfc['332'] = 2
pfc['341'] = 3
pfc['342'] = 2
pfc['346'] = 3
pfc['347'] = 2
pfc['348'] = 3
pfc['349'] = 2
pfc['351'] = 3
pfc['352'] = 7
pfc['315'] = 2
pfc['353'] = 3
pfc['366'] = 2
pfc['364'] = 3
pfc['365'] = 2
pfc['367'] = 2
pfc['368'] = 2
pfc['371'] = 1
pfc['374'] = 1
pfc['375'] = 1
pfc['372'] = 1
pfc['376'] = 1
pfc['378'] = 2
pfc['381'] = 1
pfc['382'] = 2
pfc['383'] = 5
pfc['391'] = 2
pfc['392'] = 1
pfc['393'] = 1
pfc['394'] = 1
pfc['395'] = 1
pfc['262'] = 3
pfc['242'] = 1
pfc['235'] = 3
pfc['250'] = 1
pfc['251'] = 1
pfc['252'] = 2
pfc['253'] = 2
pfc['254'] = 2
pfc['255'] = 1
pfc['256'] = 2
pfc['257'] = 1
pfc['258'] = 1
pfc['259'] = 1
pfc['263'] = 2
pfc['265'] = 1
pfc['266'] = 1
pfc['401'] = 2
pfc['402'] = 2
pfc['403'] = 2
pfc['404'] = 2
pfc['405'] = 2
pfc['406'] = 2
pfc['407'] = 2
pfc['408'] = 2
pfc['409'] = 1
pfc['411'] = 1
pfc['412'] = 1
pfc['413'] = 2
pfc['414'] = 2
pfc['415'] = 2
pfc['421'] = 2
pfc['422'] = 1
pfc['423'] = 2
pfc['424'] = 1
pfc['431'] = 1
pfc['432'] = 2
pfc['433'] = 2
pfc['436'] = 2
pfc['437'] = 2
pfc['441'] = 3
pfc['442'] = 2
pfc['443'] = 3
pfc['444'] = 2
pfc['445'] = 1
pfc['446'] = 1
pfc['451'] = 1
pfc['461'] = 2
pfc['462'] = 1
pfc['463'] = 1
pfc['464'] = 1
pfc['465'] = 1
pfc['467'] = 2
pfc['471'] = 2
pfc['472'] = 2
pfc['473'] = 2
pfc['474'] = 2
pfc['475'] = 2
pfc['476'] = 2
pfc['477'] = 2
pfc['478'] = 3
pfc['481'] = 1
pfc['482'] = 2
pfc['483'] = 1
pfc['484'] = 1
pfc['485'] = 1
pfc['491'] = 1
pfc['501'] = 1
pfc['502'] = 1
pfc['700'] = 2
