# boek/plugs/campagne.py
#
#

""" the thing to resolve. """

## IMPORTS

from boek.helpers import a_time, nr_days, elapsed_days
from boek.klok import Herhaler
from boek.hemel import hemel
from boek.ding import Ding

## basic imports

import datetime
import random
import time

## SuicideWarnLoop

pogingenjaar = 94000
pogingendag = pogingenjaar / 365.0
pogingenuur = pogingendag / 24.0
pogingenmin = pogingenuur / 60.0
geslaagdjaar = 1854
geslaagddag = geslaagdjaar / 365.0
geslaagduur = geslaagddag /  24.0
geslaagdmin = geslaagduur / 60.0
counter = 0
startdate = "2012-09-13 00:00:00"
starttime = a_time(startdate)

bron = "https://www.113online.nl/informatie/113online%2B/cijfers-over-zelfmoord"
url = "http://pypi.python.org/pypi/boek"
tags = ["#cda", "#pvda", "#d66", "#vvd", "#groenlinks", "#pvdd", "#ggznederland", "#igz", "#vws", "#gemeente", "#wmoloket", "#politie", "#ambulance", "#crisisdienst", "#telefoon", "#huisarts"]

prevpogingen = 0
prevgeslaagd = 0
lastpoging = 0
lastsuicide = 0

def ltag(*args, **kwargs):
    l = []
    while 1:
        c = random.choice(tags)
        if c not in l: l.append(c)
        if len(l) == args[0]: break
    return " ".join(l)

def campagne(*args, **kwargs):
    global counter, prevpogingen, prevgeslaagd, lastpoging, lastsuicide
    counter += 1
    o = Ding()
    o.bron = bron
    time_diff = time.time() - starttime
    aantalmin = time_diff / 60.0
    pogingen = int(aantalmin * pogingenmin)
    geslaagd = int(aantalmin * geslaagdmin)
    time_diff = float(time.time() - starttime)
    o.elapsed = elapsed_days(time_diff)
    if pogingen > lastpoging:
        o.txt = "POGING %s %s - %s ? !! %s (%s/dag)" % (pogingen, url, ltag(4), o.elapsed, int(pogingendag))
        lastpoging = pogingen
        o.prefix = "poging"
        hemel.melden(o.txt)
    if geslaagd > lastsuicide:
        o.txt = "SUICIDE nummer %s %s - %s ? !! %s (%s/dag)" % (geslaagd, url, ltag(4), o.elapsed, int(geslaagddag))
        o.prefix = "suicide"
        lastsuicide = geslaagd
        hemel.melden(o.txt)
    o.save()

hemel.registreer("campagne.tikker", campagne)

## campagne init

def init(*args, **kwargs):
    herhaler = Herhaler(campagne, 3600)
    hemel.put(herhaler.start)
