# boek/service/rss.py
#
#

""" rss module. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from boek.helpers import parse_urls, short_date, haal_url, error, strip_html
from boek.klok import Herhaler
from boek.ding import Ding
from boek.hemel import hemel

import threading
import socket
import time

## DEFINES

key_list = ["title", "link", "published"]

seen = Ding()
seen.list = []
seen.result = "rss"
seen.prefix = "result"

## display function

def display(*args, **kwargs):
    entry = args[0]
    result = ""
    for key in key_list:
        if entry.get(key, None): result += "%s - " % entry[key]
    return result[:-3]

## rss_get function

def rss_get(url):
    import boek.extra.feedparser as fp
    result = []
    try:
        data = haal_url("GET", url).read()
        data = fp.parse(data)
    except Exception as ex: error() ; return
    for entry in data["entries"]:
        o = Ding(entry)
        s = o.slice(key_list)
        if "summary" in o: o["summary"] = strip_html(o["summary"]).rstrip()
        o.prefix = "rss"
        o.short = short_date(time.ctime())
        yield o

## look function

def rss_haal(*args, **kwargs):
    global seen
    for obj in hemel.dingen():
        if "rss" not in obj or not obj.rss: continue
        for o in rss_get(obj.rss):
            if o.link in seen.list: continue
            seen.list.append(o.link)
            o.sync()
            hemel.melden(display(o))
    seen.sync()

hemel.registreer("rss.haal", rss_haal)

## RSS 

class RSS(Herhaler): pass

## INIT

def init(*args, **kwargs):
    global seen
    seen = hemel.last("result", "rss")
    rss = RSS(rss_haal, 600)
    hemel.put(rss.start)
