# boek/dienst/udp.py
#
#

""" relay txt through a udp port listener. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from boek.helpers import error, get_name
from boek.regels import regels_udp
from boek.extra import rijndael
from boek.fouten import StopIter
from boek.ding import Ding
from boek.hemel import hemel

import logging
import socket
import queue
import boek
import time
import re

crypt = rijndael.rijndael(regels_udp.seed)

## UDP class

class UDP(Ding):

    def __init__(zelf, *args, **kwargs):
        Ding.__init__(zelf, *args, **kwargs)
        zelf._status = "idle"
        zelf._start = time.time()
        zelf._sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        zelf._sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        try: zelf._sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEPORT, 1)
        except: pass
        zelf._sock.setblocking(1)

    def start(zelf):
        zelf._sock.bind((regels_udp.host, regels_udp.port))
        logging.warn("# begin %s/%s" % (regels_udp.host, regels_udp.port)) 
        zelf.ready()
        while zelf._status:
            input, addr = zelf._sock.recvfrom(64000)
            if not zelf._status: break
            input = str(input.rstrip(), "utf-8")
            data = ""
            for i in range(int(len(input)/16)):
                txt = input[i*16:i*16+16]
                try: data += crypt.decrypt(txt)
                except Exception as ex: error() ;  break
            if not data: break
            zelf.output(data, addr)
        
    def exit(zelf, *args, **kwargs):
        logging.warn("# eindig %s" % get_name(zelf))
        zelf._status = ""
        zelf._sock.settimeout(1.0)
        zelf._sock.sendto(bytes("bla", "utf-8"), (regels_udp.host, regels_udp.port))
        #zelf._sock.shutdown(socket.SHUT_WR)

    def output(zelf, input, addr):
        passwd, text = input.split(" ", 1)
        text = text.replace("\00", "")
        if passwd == regels_udp.password: hemel.melden(text)

def init(*args, **kwargs):
    server = UDP()
    hemel.put(server.start)
