# boek/fouten.py
#
#

""" exceptions package. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## ERRORS

class Fout(BaseException):
    """ basic Exception used in the program. """
    pass

class WrongSignature(Fout):
    """ test exception. """
    pass

class TestFout(Fout):
    """ test exception. """
    pass

class StopIter(Fout):
    """ stop the iteration. """
    pass

class NotImplemented(Fout):
    """ method is not implemented. """
    pass

class NoFunction(Fout):
    """ No function could be found. """
    pass

class NoEvent(Fout):
    """ No event is returned. """
    pass

class NoWorkdirSet(BaseException):
    """ a working directory is needed. """
    pass

class Overload(Fout):
    """ method is trying to be overloaded. """
    pass

class AttributeSet(Fout):
    """ attribute is already set. """
    pass

class DataNotSet(Fout):
    """ missing argument attribute. """
    pass

class NoTarget(Fout):
    """ missing argument attribute. """
    pass

class NoJSON(Fout):
    """ no JSON could be decoded/encoded. """
    pass

class RemoteDisconnect(Fout):
    """ Exception thrown when the connection is disconnected. """
    pass

class NotSet(Fout):
    """ attribute is not set. """
    pass

class FileNotFoundError(Fout):
    """ file is not found. """
    pass
