# boek/fuzzy.py
#
#

__copyright__ = "Copyright 2015, B.H.J Thate"

""" generate fuzzy dings used for testing. """

## IMPORTS

from boek.ding import Ding
from boek.helpers import error

import random
import string

## DEFINES

kinds = Ding()
kinds.registreer("int", int)
kinds.registreer("float", float)
kinds.registreer("complex", complex)
kinds.registreer("list", list)
kinds.registreer("tuple", tuple)
kinds.registreer("range", range)
kinds.registreer("str", str)
kinds.registreer("bytes", bytes)
kinds.registreer("bytearray", bytearray)
kinds.registreer("memoryview", memoryview)
kinds.registreer("set", set)
kinds.registreer("frozenset", frozenset)
kinds.registreer("dict", dict)

def printables(*args, **kwargs): return [a for a in string.printable]

def random_int(*args, **kwargs):
    if args: return random.randint(0, int(random.random()*args[0]))
    else: return random.randint(0, int(random.random() * 1000))

def random_float(*args, **kwargs): return random.random() * 1000

def random_complex(*args, **kwargs): return complex(random_int(1), random_int(1))

def random_list(*args, **kwargs): return [a for a in random.sample(printables(), random_int(len(string.printable)-1))]

def random_tuple(*args, **kwargs): return tuple([a for a in random.sample(printables(), random_int(len(string.printable)-1))])

def random_range(*args, **kwargs): return range(random_int(1), random_int(random.random()*1000))

def random_str(*args, **kwargs): return "".join(random.sample(printables(), random_int(len(string.printable)-1)))

def random_bytes(*args, **kwargs): return bytes(random_str(), "utf-8")

def random_bytearray(*args, **kwargs): return bytearray(random_str(), "utf-8")

def random_memoryview(*args, **kwargs): return memoryview(bytes(random_str(), "utf-8"))

def random_set(*args, **kwargs): return set(random_str())

def random_frozenset(*args, **kwargs): return frozenset(random_str())

def random_dict(*args, **kwargs): return {}

rand = Ding()
rand.define("int", random_int)
rand.define("float", random_float)
rand.define("complex", random_complex)
rand.define("list", random_list)
rand.define("tuple", random_tuple)
rand.define("range", random_range)
rand.define("str", random_str)
rand.define("bytes", random_bytes)
rand.define("bytearray", random_bytearray)
rand.define("memoryview", random_memoryview)
rand.define("set", random_set)
rand.define("frozenset", random_frozenset)
rand.define("dict", random_dict)

kind_list =["int", "float", "complex", "list", "tuple", "range", "str", "bytes",
            "bytearray", "memoryview", "set", "frozenset", "dict"]

types_list = [int, float, complex, list, tuple, range, str, bytes,
         bytearray, memoryview, set, frozenset, dict]

dings_list = [Ding, ]

## FUNCTIONS

def fuzzy(kind, *args, **kwargs):
    try: return rand[kind]()
    except: error()

def random_fuzz(*args, **kwargs):
    kind = random.choice(kind_list)
    return fuzzy(kind)
