# boek/klok.py
#
#

""" op de klok geschakeld. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from boek.helpers import error, get_named
from boek.hemel import hemel, vloot
from boek.ding import Ding

import threading
import logging
import time

# TIMER

class Tijd(Ding):

    def __init__(zelf, time_alarm, event, *args, **kwargs):
        Ding.__init__(zelf, *args, **kwargs)
        zelf.sleep = time_alarm - time.time()
        zelf._start = time.time()
        zelf._status = "begin"
        zelf._last = time.time()
        zelf._running = "timer"
        zelf._event = event

    def start(zelf, *args, **kwargs):
        zelf._status = "draaiend"
        if zelf.sleep > 0: time.sleep(zelf.sleep)        
        zelf.echo()

    def echo(zelf, *args, **kwargs):
        for omroeper in vloot: omroeper.verklaring(zelf._event.rest())
        
## LOOPS

class Herhaler(Ding):

    """ a LOOPER calls a function every x seconds. """ 

    def __init__(zelf, func, sleeptime, *args, **kwargs):
        """ args = function, sleeptime. """
        Ding.__init__(zelf, *args, **kwargs)
        zelf.func = func
        zelf._start = time.time()
        zelf._last = time.time()
        zelf._status = "begin"
        zelf._running = get_named(zelf.func)
        zelf.sleep = sleeptime

    def start(zelf, *args, **kwargs):
        """ initialize a LOOPER. """
        zelf._status = "draaiend"
        while zelf._status:
            zelf._last = time.time()
            try: zelf.func()
            except: error()
            if zelf.sleep > 0: time.sleep(zelf.sleep)

    def exit(zelf, *args, **kwargs): zelf._status = ""
