# boek/omroepers/een.py
#
#

""" console programma voor de enkele gebruiker. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from boek.definitie import BLA, GREEN, ENDC, pfc
from boek.fouten import RemoteDisconnect
from boek.hemel import vloot, regels
from boek.helpers import short_date
from boek.ding import Ding
from boek.omroepers import Omroeper

import logging
import time
import sys


## CLI

class Een(Omroeper):

    """ bot running on the console. """

    cc = ""

    def _raw(zelf, *args, **kwargs): sys.stdout.write(args[0] + "\n") ; sys.stdout.flush()

    def say(zelf, *args, **kwargs): zelf._raw(args[1])

    def prompt(zelf, *args, **kwargs):
        zelf.wait()
        return "%s %s<%s " % (short_date(time.ctime(time.time())).split()[1], GREEN, ENDC)

    def event(zelf, *args, **kwargs):
        event = Ding()
        event._target = zelf
        event.origin = "root@shell"
        event.cc = zelf.cc
        zelf.ready()
        event.txt = input(zelf.prompt())
        return event

    def start(zelf, *args, **kwargs):
        vloot.append(zelf)
        if not regels.shell:
            thrs = zelf.single(" ".join(regels.runargs))
            if thrs: zelf.collect(thrs)
            zelf.ready()
            return
        Omroeper.start(zelf)
