# boek/omroepers/xmpp.py
#
#

""" basic package for the program. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from boek.definitie import BLA, GREEN, ENDC, pfc
from boek.hemel import hemel, vloot, regels
from boek.regels import regels_xmpp
from boek.helpers import stripped
from boek.omroepers import Omroeper
from boek.ding import Ding

import threading
import logging
import getpass
import queue
import time
import html

## XMPP

class XMPP(Omroeper):

    """ XMPP bot. """

    cc = ""

    def __init__(zelf, *args, **kwargs):
        import sleekxmpp
        from sleekxmpp import clientxmpp
        Omroeper.__init__(zelf, *args, **kwargs)
        if "port" not in zelf: zelf.port = 5222
        zelf._queue = queue.Queue()
        zelf.xmpp = clientxmpp.ClientXMPP(zelf.user, getpass.getpass())
        zelf.xmpp.add_event_handler("session_start", zelf.session_start)
        zelf.xmpp.add_event_handler("message", zelf.handle_message)
        zelf.xmpp.add_event_handler('disconnected', zelf.handle_disconnected)
        zelf.xmpp.add_event_handler('connected', zelf.handle_connected)
        zelf.xmpp.add_event_handler('presence_available', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_dnd', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_xa', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_chat', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_away', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_unavailable', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_subscribe', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_subscribed', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_unsubscribe', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_unsubscribed', zelf.handle_presence)
        zelf.xmpp.add_event_handler('groupchat_message', zelf.handle_message)
        zelf.xmpp.add_event_handler('groupchat_presence', zelf.handle_presence)
        zelf.xmpp.add_event_handler('groupchat_subject', zelf.handle_presence)
        zelf.xmpp.add_event_handler('failed_auth', zelf.handle_failedauth)
        zelf.xmpp.exception = zelf.exception
        zelf.xmpp.use_signals()
        zelf.openfire = regels.openfire
        if zelf.openfire:
            logging.warn("! XMPP/openfire")
            import ssl
            zelf.xmpp.ssl_version = ssl.PROTOCOL_SSLv3
        zelf._connected = threading.Event()
        zelf.channels = []

    def _raw(zelf, *args, **kwargs):
        logging.debug("> XMPP/schrijf %s" % args[0])
        zelf.xmpp.send_raw(args[0])

    def start(zelf, *args, **kwargs):
        zelf.connect()
        Omroeper.start(zelf, *args, **kwargs)

    def connect(zelf):
        logging.error("! XMPP/verbind met %s" % zelf.server)
        try: zelf.xmpp.connect((zelf.server, zelf.port), use_ssl=zelf.openfire)
        except: zelf.xmpp.connect((zelf.server, zelf.port))

    def session_start(zelf, event):
        zelf.xmpp.send_presence()
        zelf.ready()
        logging.error("! XMPP/sessie %s" % zelf.user)
         
    def exception(zelf, ex):
        zelf._status = ex
        logging.error("! XMPP/fout %s"% str(ex))

    def melden(zelf, *args, **kwargs):
        for channel in zelf.channels: zelf.say(channel, args[0])

    def handle_failedauth(zelf, error, *args, **kwargs): zelf._error = error ; logging.error("! XMPP/authoriseer %s" % str(error))

    def handle_failure(zelf, error, *args, **kwargs): zelf._error = error ; logging.error("! XMPP/fout %s" % str(error))

    def handle_disconnected(zelf, *args, **kwargs):
        zelf._connected.clear()
        zelf._status = "opgehangen"
        logging.error("! XMPP/opgehangen %s" % zelf.user)

    def handle_connected(zelf, *args, **kwargs): 
        zelf._status = "verbonden"
        zelf._connected.set()
        logging.error("! XMPP/verbonden %s" % zelf.user)

    def loop(zelf, *args, **kwargs): zelf.xmpp.process(block=True)

    def say(zelf, *args, **kwargs):
        to = args[0]
        txt = args[1]
        zelf.xmpp.send_message(to, txt)
        logging.info("> XMPP/bericht %s" % to)

    def event(zelf, *args, **kwargs):
        event = zelf._queue.get()
        event.cc = zelf.cc
        return event

    def handle_message(zelf, data, *args, **kwargs):
        logging.debug("< XMPP/schrijf %s" % data)
        m = Ding(**data)
        if m.type == "error": logging.error(m.error) ; return
        m["from"] = str(m["from"])
        m.origin = m["from"]
        m.channel = m.origin
        m.to = m.origin
        m.element = "message"
        m.txt = m["body"]
        m._target = zelf
        if '<delay xmlns="urn:xmpp:delay"' in str(data):
            logging.warn("! XMPP/negeer %s %s" % (m.type, m.origin))
            return
        logging.warn("! XMPP/%s %s" % (m.type, m.origin))
        zelf._queue.put_nowait(m)

    def handle_presence(zelf, data, *args, **kwargs):
        logging.debug("< XMPP/schrijf %s" % data)
        o = Ding(data)
        o["from"] = str(o["from"])
        o.origin = o["from"]
        o.element = "presence"
        if o.type == 'subscribe':
            pres = Ding({'to': o["from"], 'type': 'subscribed'})
            o.xmpp.send_presence(pres)
            pres = Ding({'to': o["from"], 'type': 'subscribe'})
            o.xmpp.send_presence(pres)
        elif o.type == "unavailable":
            if o.origin in zelf.channels: zelf.channels.remove(o.origin)
        else:
            if o.origin != zelf.user and o.origin not in zelf.channels: zelf.channels.append(o.origin)
        o.no_dispatch = True
        o._target = zelf
        logging.warn("! XMPP/%s %s" % (o.type, o.origin))
        zelf._queue.put_nowait(o)

    def exit(zelf, *args, **kwargs):
        zelf.xmpp.disconnect()
        Omroeper.exit(zelf)
        zelf._queue.put(None)
        
def init(*args, **kwargs):
    regels = Ding().last("regels", "xmpp")
    if not regels: regels = regels_xmpp ; regels.save()
    omroeper = XMPP(**regels) 
    vloot.append(omroeper)
    hemel.put(omroeper.loop)   
    hemel.put(omroeper.start)
