# boek/werken.py
#
#

""" de werken van de hemel. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from boek.schuiver import Schuiver
from boek.helpers import error
from boek.ding import Ding

import importlib
import logging
import pkgutil

## PLUGINS

class Werken(Schuiver):

    """ ding to registreer plugins with. """

    def load(zelf, modname):
        """ load plugins from the plugin directory. """
        logging.warn("# laad %s" % ".".join(modname.split(".")[1:]))
        mod = zelf.load_mod(modname)
        for pkg in pkgutil.walk_packages(mod.__path__, mod.__name__+'.'):
            name = pkg[1]
            zelf[name] = zelf.load_mod(name)

    def init(zelf, werken):
        if not werken: return
        modnames = werken.split(",") 
        for modname in sorted(modnames, reverse=True):
            if not modname: continue
            logging.warn("# initialiseer %s" % modname.upper())
            objs = zelf.find(modname)
            for obj in objs:
                if modname == "xmpp": obj.init() ; continue
                try: zelf.put(obj.init)
                except AttributeError: continue
                except: error()

    def stop(zelf, werken):
        modnames = werken.split(",") 
        for name in sorted(modnames)[::-1]:
            modname = zelf.get_name(name)
            obj = zelf.get(modname)
            if not obj: continue
            try: obj.stop()
            except: pass

    def load_mod(zelf, name, force=True):
        """ load module. """
        logging.info("! laad %s" % ".".join(name.split(".")[1:]))
        if name in zelf and not force: mod = zelf.reload(name)
        else: mod = importlib.import_module(name)
        return mod

    def reload(zelf, *args, **kwargs):
        name = args[0]
        logging.warn("# herlaad %s" % name)
        zelf[name] = importlib.reload(zelf[name])
        return zelf[name]

    def get_name(zelf, *args, **kwargs):
        n = args[0]
        for name in zelf.names():
            if n in name: yield name

    def reload_name(zelf, *args, **kwargs):
        names = zelf.get_name(args[0])
        for name in names: zelf.reload(name)
