# boek/werken/bord.py
#
#

""" show version. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from boek.helpers import to_str, elapsed_days, error
from boek.hemel import hemel, werken, regels
from boek import __version__

import threading
import time
import os

def bord_versie(event): event.reply("BOEK #%s" % __version__)

hemel.registreer("bord.versie", bord_versie)

def bord_mogge(event): event.reply("goeie morgen !!")

hemel.registreer("bord.mogge", bord_mogge)

def bord_draaiend(event): event.reply(", ".join([str(x) for x in threading.enumerate()]))

hemel.registreer("bord.draaiend", bord_draaiend)

def bord_gebruik(event):
    data = os.popen("ps -p %s -o pid,tid,class,rtprio,ni,pri,psr,rss,pcpu,stat,wchan:14,comm" % os.getpid()).read().strip()
    event.reply(str(data))

hemel.registreer("bord.gebruik", bord_gebruik)

def bord_sleutels(event):
    result = []
    for obj in hemel.dingen():
        for key in obj.obj():
            if key not in result: result.append(key)
    for arg in event.args:
        result = filter(lambda x: arg not in x, result)
    if result: event.reply(" ".join(result))

hemel.registreer("bord.sleutels", bord_sleutels)

def bord_lijst(event):
    rest = event.rest()
    if not rest:
       result = set([x.split(".")[-1] for x in hemel.names()])
       event.reply(", ".join(sorted(result)))
       return
    name = ""
    keys = hemel.search(rest)
    if keys: event.reply(", ".join(keys))
 
hemel.registreer("bord.lijst", bord_lijst)

def bord_werken(event):
    rest = event.rest()
    if not rest:
       result = set(werken.names())
       event.reply(", ".join(sorted([".".join(x.split(".")[1:]) for x in result])))
       return
    name = ""
    keys = werken.search(rest)
    event.reply(", ".join([".".join(x.split(".")[1:]) for x in keys]))
 
hemel.registreer("bord.werken", bord_werken)

def bord_regels(event):
    obj = regels
    if event.args:
        ctype = event.args[0]
        obj = hemel.last("regels", ctype)
        if not obj:
            try: obj = getattr(regels, "regels_%s" % ctype)
            except AttributeError: pass
    try: 
        key = event.args[1]
        value = event.args[2]
        if key in obj: obj[key] = value ; obj.prefix = "regels" ; obj.sync()
    except IndexError: pass
    if obj: event.reply("\n".join(obj.show()))

hemel.registreer("bord.regels", bord_regels)

def info_hemel(event): event.reply(hemel.pretty())

hemel.registreer("bord.hemel", info_hemel)

def info_waar(event):
    name = event.rest()
    cmnds = hemel.search(name)
    result = []
    for name in cmnds: result.extend([x.plugname for x in hemel.get(name)])
    if result: event.reply(", ".join(set(result)))

hemel.registreer("bord.waar", info_waar)

## HELPERS

def until(obj): 
    try: return elapsed_days(int(obj.sleep) - int(time.time() - obj._last))
    except: error() ; return ""

def upt(obj):
    try: return elapsed_days(int(time.time()) - int(obj._start))
    except: return ""

def waiting(obj):
    if sleeptime(obj): return "%s/%s" % (until(obj), sleeptime(obj))
    else: return ""

def idle(obj):
    try: return elapsed_days(int(obj._last - obj._start))
    except: return ""

def since(obj):
    try: return elapsed_days(int(time.time()) - int(obj._last))
    except: return ""

def status(obj):
    try: return obj._status 
    except: return ""

def name(obj):
    try: return obj._name
    except: return ""

def running(obj):
    try: return obj._running
    except: return ""

def sleeptime(obj):
    try: return elapsed_days(obj.sleep)
    except: return ""

def plugname(obj):
    try: return obj.plugname
    except: return ""

funcs = [status, upt, waiting]

def bord_wakker(event):
    threads = [x for x in threading.enumerate() if status(x)]
    for obj in sorted(threads, key=name):
        try: o = obj.func.__self__
        except: o = obj
        res = "%s: " % name(obj)
        for func in funcs:
            a = func(o)
            if not a: continue
            try: res += "%s " % a
            except: error()
        event.reply(res)
 
hemel.registreer("bord.wakker", bord_wakker)

def bord_namen(event):
    import boek
    rest = event.rest()
    for naam in dir(boek):
       if "_" in naam: continue
       if rest not in naam: continue
       mod = getattr(boek, naam, None)
       event.reply("%s: %s" % (naam, ", ".join([x for x in dir(mod) if not x.startswith("_")])))

hemel.registreer("bord.namen", bord_namen)