# boek/werken/werken.py
#
#

""" regen, regen. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from boek.hemel import hemel, werken
from boek import regels

## COMMANDS

def werken_stop(event):
    if not event.args: return
    werken.stop(event.rest())
    event.ok()

hemel.registreer("werken.stop", werken_stop)

def werken_start(event):
    if not event.args: return
    regels = get_regels(event.args[0])
    if regels: regels.save() 
    werken.init(event.args[0])
    event.ok()

hemel.registreer("werken.start", werken_start)

def werken_laad(event): 
    if not event.args: return
    result = werken.reload_name(event.rest())
    if result: event.ok(get_named(result))

hemel.registreer("werken.laad", werken_laad)

## HELPERS

def get_regels(*args, **kwargs):
    try: return getattr(regels, "regels_%s" % args[0])
    except AttributeError: pass
