# boek/plugs/api.py
#
#

""" Ding Copy API. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from boek.helpers import run_thr, error, get_exception, list_files, j, get_source
from boek.regels import regels_api
from boek.hemel import hemel, regels
from boek import __version__
from boek.ding import Ding

import urllib.parse
import urllib
import logging
import select
import socket
import time
import http
import cgi
import sys
import os

from http.server import HTTPServer, BaseHTTPRequestHandler

## DEFINES

port = 10102
server = None

## HANDLERS

handlers = Ding()

## APIServer class

class API(HTTPServer, Ding):

    """ API server """

    allow_reuse_address = True
    daemon_thread = True

    def __init__(zelf, *args, **kwargs):
        """ start the API server. """
        HTTPServer.__init__(zelf, *args, **kwargs)
        Ding.__init__(zelf)
        zelf.host = args[0]
        zelf._status = "init"
        zelf._last = time.time()
        zelf._start = time.time()

    def exit(zelf):
        """ shutdown API. """
        logging.warn("# eindig API.")
        zelf._status = ""
        time.sleep(0.2)
        zelf.shutdown()

    def start(zelf, *args, **kwargs): 
        """ serving requests. """
        logging.warn("# begin API at http://%s:%s" % zelf.host)
        zelf._status = "running"
        zelf.ready()
        zelf.serve_forever()

    def handle_request(zelf):
        zelf._last = time.time()

    def handle_error(zelf, request, addr):
        """ melding the error """
        ex = get_exception()
        logging.warn('%s - %s' % (addr, ex))

## RestReqeustHandler class

class APIHandler(BaseHTTPRequestHandler):

    """ timeserver request handler class """

    def setup(zelf):
        """ called on each incoming request. """
        BaseHTTPRequestHandler.setup(zelf)
        zelf._ip = zelf.client_address[0]
        zelf._size = 0

    def write_header(zelf, type='text/plain'):
        """ write headers to the client. """
        zelf.send_response(200)
        zelf.send_header('Content-type', '%s; charset=%s ' % (type, "utf-8"))
        zelf.send_header('Server', __version__)
        zelf.end_headers()

    def handle_request(zelf):
        """ handle a REST request. """
        zelf.parsed = urllib.parse.urlparse(zelf.path)
        path = "/" + zelf.parsed[2].split("/")[1]
        try:
            for functor in handlers[path]:
                result = functor.func(zelf, zelf.request)
        except KeyError as ex: logging.info("# ontbrekend %s" % str(ex))
        except: error()

    do_DELETE = do_PUT = do_GET = do_POST = handle_request

    def melding_request(zelf, code):
        """ melding the request """
        try: ua = zelf.headers['user-agent']
        except: ua = "-"
        try: rf = zelf.headers['referer']
        except: rf = "-"
        logging.warn('# %s %s %s' % (zelf.address_string(), code, zelf.path))

def api_home(handler, request):
    server, port = handler.server.host
    handler.write_header()
    handler.wfile.write(bytes("BOEK INTERFACE\n\n", "utf-8"))
    for func in handlers.keys():
        handler.wfile.write(bytes("http://%s:%s%s\n" % (server, port, func), "utf-8"))
    handler.wfile.flush()

def api_all(handler, request):
    o = Ding()
    nr = 0
    server, port = handler.server.host
    root = hemel.get_root()
    for fn in list_files(root):
        o[nr] = "http://%s:%s/get%s" % (server, port, fn.split(root)[-1])
        nr += 1
    handler.write_header()
    handler.wfile.write(bytes(o.json(indent=2), "utf-8"))
    handler.wfile.flush()

def api_get(handler, request):
    fn = os.sep.join(handler.path.split("/")[2:])
    root = hemel.get_root()
    path = os.path.normpath(os.path.expanduser(j(root, fn)))
    o = Ding()
    o.load(path)
    txt = o.json(indent=2, ensure_ascii=False, sort_keys=True)
    handler.write_header()
    handler.wfile.write(bytes(txt, "utf-8"))
    handler.wfile.flush()

def api_show(handler, request):
    fn = os.path.join(handler.path.split("/")[2:])
    root = hemel.get_root()
    path = os.path.normpath(j(root, *fn))
    o = Ding()
    o.load(path)
    txt = o.pretty(indent=2, sort_keys=True)
    txt = txt.replace("\\n", "\n")
    txt = txt.replace("\\t", "\t")
    handler.write_header()
    handler.wfile.write(bytes(txt, "utf-8"))
    handler.wfile.flush()

def init(*args, **kwargs):
    from boek.hemel import hemel
    api = API((regels_api.hostname, int(regels.port or regels_api.port)), APIHandler)
    handlers.registreer("/", api_home)
    handlers.registreer("/all", api_all)
    handlers.registreer("/get", api_get)
    handlers.registreer("/show", api_show)
    hemel.put(api.start)
