# boek/hemel.py
#
#

""" De Alles Omvattende. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from boek.helpers import make_opts, hello, error
from boek.regels import regels_hemel
from boek.definitie import opts_defs
from boek.schuiver import Schuiver
from boek.melding import init
from boek.werken import Werken
from boek.ding import Ding

import logging
import sys
import os

def boekpath():
    for path in sys.path:
        if "boek" in path and "egg" in path: yield path  

## Hemel

class Hemel(Werken):

    def koffie(zelf, *args, **kwargs):
        opts, arglist = make_opts(opts_defs)
        regels.update(regels_hemel)
        regels.update(vars(opts))
        regels.runargs = arglist
        regels.shell = True
        if arglist: regels.shell = False
        if regels.shell and args: hello(args[0])
        init(regels.meldinglevel)
        if regels.meldinglevel != "error":
            print("\n".join(sorted(regels.show())))
            print("path=%s" % ", ".join(list(boekpath()))) 
            print("")
        for package in regels.packages:
            try: werken.load(package)
            except: error(package)
        werken.init(regels.init)
        zelf.ready()
        return zelf

    def afsluiten(zelf, *args, **kwargs): logging.warn("afsluitend")

## DEFINITIES

hemel = Hemel()
werken = Werken()
regels = Ding()
vloot = []
