# boek/melding.py
#
#

""" provide logging infrastructure. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from boek.definitie import BOLD, BLA, BLUE, RED, GREEN, YELLOW, ENDC
from boek.helpers import error, j, cdir, short_date

import logging.handlers
import logging
import time
import sys
import os
import re

## DEFINES

homedir = os.path.expanduser("~")
meldingdir = j(homedir, "boek.meldings", "")
enabled = False
datefmt = '%H:%M:%S'
format = "%(asctime)-8s %(message)s %(module)s.%(lineno)s"
format_small = "%(asctime)-8s %(message)s"

LEVELS = {'debug': logging.DEBUG,
          'info': logging.INFO,
          'warning': logging.WARNING,
          'warn': logging.WARNING,
          'error': logging.ERROR,
          'critical': logging.CRITICAL
        }

## CLASSES

class Formatter(logging.Formatter):

    """ hooks into the logging system. """

    def format(zelf, record):
        target = str(record.msg)
        if not target: target = " "
        if target[0] in [">", ]: target = "%s%s%s%s" % (BLUE, target[0], ENDC, target[1:])
        elif target[0] in ["<", ]: target = "%s%s%s%s" % (GREEN, target[0], ENDC, target[1:])
        elif target[0] in ["!", ]: target = "%s%s%s%s" % (YELLOW, target[0], ENDC, target[1:])
        elif target[0] in ["#", ]: target = "%s%s%s%s" % (BLA, target[0], ENDC, target[1:])
        elif target[0] in ["^", ]: target = "%s%s%s%s" % (RED, target[0], ENDC, target[1:])
        record.msg = target
        return logging.Formatter.format(zelf, record)

## melding function

def melding(level, error):
    l = LEVELS.get(str(level).lower(), logging.NOTSET)
    logging.log(l, error)

## INIT

def init(meldinglevel):
    """ return a properly configured melding. """
    melding = logging.getLogger("")
    formatter = Formatter(format, datefmt=datefmt)
    formatter_short = Formatter(format_small, datefmt=datefmt)
    level = LEVELS.get(str(meldinglevel).lower(), logging.NOTSET)
    filehandler = None
    melding.setLevel(level)
    if melding.handlers:
        for handler in melding.handlers: melding.removeHandler(handler)
    if not os.path.exists(meldingdir): cdir(meldingdir)
    try: filehandler = logging.handlers.TimedRotatingFileHandler(j(meldingdir, "melding"), 'midnight')
    except: error()
    ch = logging.StreamHandler()
    ch.setLevel(level)
    ch.setFormatter(formatter_short)
    melding.addHandler(ch)
    if filehandler:
        filehandler.setFormatter(formatter_short)
        filehandler.setLevel(level)
        melding.addHandler(filehandler)
    global enabled
    enabled = True
    return melding
