# boek/omroepers/__init__.py
#
#

""" omroepers eenheid. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from boek.helpers import get_name, short_date, get_type
from boek.fouten import RemoteDisconnect
from boek.definitie import BLA, ENDC
from boek.schuiver import Schuiver
from boek.hemel import hemel, vloot
from boek.ding import Ding

import logging
import socket
import time

## BOTS

class Omroeper(Schuiver):

    """ Basis Omroeper. """

    def __init__(zelf, *args, **kwargs):
        Schuiver.__init__(zelf, *args, **kwargs)
        zelf._start = time.time()
        zelf.channels = ["#boek", ]

    def say(zelf, *args, **kwargs): print(args[1])
        
    ## CHANNELS

    def melden(zelf, *args, **kwargs):
        """ verklaar op kanaal. """
        logging.info("# melding %s" % " ".join(zelf.channels))
        for channel in zelf.channels: zelf.say(channel, args[0])

    def join(zelf, *args, **kwargs): pass
        
    def join_channels(zelf, *args, **kwargs):
        """ join channels.  """ 
        for channel in zelf.channels: zelf.join(channel)
            
## TESTBOT

class Test(Omroeper):

    """ USE WITH Bot.put() and Bot.read(). """

    testing = True

    def say(zelf, *args, **kwargs): logging.warn(args[1])

    def event(zelf, *args, **kwargs):
        o = Ding()
        o.origin = "test@boek"
        o._target = zelf
        o.meldinglevel = "warning"
        return o

## CMNDS

def omroeper_voegen(event):
    if not event.args: return
    channel = event.args[0]
    for bot in vloot:
        if "join" not in bot: continue
        bot.join(channel)
        event.reply("voeg %s (%s)" % (channel, bot.server))

hemel.registreer("omroeper.voegen", omroeper_voegen)

def omroeper_verlaat(event):
    if not event.args: return
    for bot in vloot:
        if "part" not in bot: continue
        bot.part(event.args[0])
        event.reply("verlaat %s (%s)" % (channel, bot.server))

hemel.registreer("omroeper.verlaat", omroeper_verlaat)

def omroeper_naam(event):
    if not event.args: return
    for bot in vloot:
        if "nick" not in bot: continue
        bot.nick(event.args[0])
        event.reply("naam %s" % bot.server)

hemel.registreer("omroeper.naam", omroeper_naam)

def omroeper_verdwijn(event):
    if not event.args: return
    for bot in vloot:
        if "quit" not in bot: continue
        bot.quit(event.rest())
        event.reply("verdwijn %s" % bot.server)
    
hemel.registreer("omroeper.verdwijn", omroeper_verdwijn)
