# boek/baas.py
#
#

""" basic package for the program. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from boek.helpers import get_plugname, get_named, get_strace, error
from boek.fouten import NoFunction, NoEvent, RemoteDisconnect
from boek.ding import Ding

import collections
import threading
import logging
import random
import queue
import time

## DEFINES

threads = []

## RUNNER

class Taak(threading.Thread):

    """ the working unit of BOEK.  """

    def __init__(zelf, *args, **kwargs):
        threading.Thread.__init__(zelf, *args, **kwargs)
        zelf._queue = queue.Queue()
        
    def __iter__(zelf):
        for x in dir(zelf): yield x

    def run(zelf, *args, **kwargs):
        """ loop that executes the (function, ding) pairs. """
        zelf.type = "Taak"
        zelf._start = time.time()
        zelf._last = time.time()
        zelf._status = "wacht"
        while zelf._status:
            arglist, kwargdict = zelf._queue.get()
            if not arglist or not arglist[0]: break
            zelf.func, *arguments = arglist
            name = get_named(zelf.func)
            zelf.setName(name)
            logging.info("# uitvoering %s" % name)
            try: zelf.func(*arguments, **kwargdict)
            except: error("", name) ; break
            if zelf._queue.empty(): break

    def stop(zelf, *args, **kwargs): zelf.put((None, {}))
        
    def put(zelf, *args, **kwargs):
        """ put arguments/kwargs to the Runner. """
        zelf._last = time.time()
        zelf._queue.put((args, kwargs))
        return zelf

## DISPATCH

class Schuiver(Ding):

    """ the dispatcher delegates the workload to the Runners. Runner gets instantiated when needed. """

    cc = "!"

    def __init__(zelf, *args, **kwargs):
        Ding.__init__(zelf, *args, **kwargs)
        zelf._input = queue.Queue()
        zelf._output = queue.Queue()
        zelf._ready = threading.Event()

    ## VIRTUAL

    def event(zelf, *args, **kwargs): pass
        
    ## PROCES

    def start(zelf, *args, **kwargs):
        logging.warn("# start %s" % zelf.type)
        status = "haal"
        while status:
            try:
                event = zelf.event()
                if not event: break
                zelf.handle_event(event)
            except RemoteDisconnect: time.sleep(5.0) ; continue
            except (EOFError, KeyboardInterrupt): raise
            except: error()
        
    def stop(zelf, *args, **kwargs):
        name = args[0]
        for thr in threading.enumerate():
            if name in str(thr): thr.exit()

    def exit(zelf, *args, **kwargs):
        zelf._status = ""
        zelf.put(None)

    ## INPUT/OUTPUT

    def put(zelf, *args, **kwargs):
        taak = Taak()
        taak.start()
        return taak.put(*args, **kwargs)

    ## RESULTS

    def collect(zelf, *args, **kwargs):
        result = args[0]
        for thr in result:
            if thr: thr.join()

    ## DISPATCHING

    def single(zelf, *args, **kwargs):
        if not args[0]: return
        event = Ding()
        event._target = zelf
        event.origin = "boek@shell"
        event.txt = args[0]
        event.cc = zelf.cc
        return zelf.handle_cmnd(event)
                
    def handle_event(zelf, *args, **kwargs):
        event = args[0]
        if "txt" not in event or not event.txt: return []
        thrs = zelf.handle_cmnd(event)
        if thrs: zelf.collect(thrs)
        
    def handle_cmnd(zelf, *args, **kwargs):
        from boek.hemel import hemel
        event = args[0]
        event.update(event.parsed)
        if "cc" in event and not event.txt.startswith(event.cc): return
        cmnds = []
        result = []
        cmnds = hemel.find(event.cmnd)
        if not cmnds:
            try: cmnds = hemel[event.cmnd]
            except KeyError: cmnds = []
        for cmnd in cmnds:
            try: o = zelf.put(cmnd.func, event) ; result.append(o)
            except AttributeError: continue
            except: error()
        return result
