# boek/werken/lees.py
#
#

""" commenting. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from boek.helpers import j, error, parse_email, short_date, ftime, haal_url
from boek.ding import Ding
from boek.hemel import hemel

import email.message
import datetime
import mailbox
import socket
import email
import time
import os

## CMNDS

def lees_post(event):
    try: fn = os.path.abspath(os.path.expanduser(event.args[0]))
    except: return
    nr = 0
    if not os.path.isfile(fn): event.reply("a mbox file is needed.") ; return
    for m in mailbox.mbox(fn, create=False):
        o = Ding()
        o.update(m.items())
        try: sdate = os.sep.join(short_date(o.Date).split())
        except AttributeError: sdate = None
        o.text = ""
        for load in m.walk():
            if load.get_content_type() == 'text/plain': o.text += load.get_payload()
        o.text = o.text.replace("\\n", "\n")
        o.prefix = "email"
        if sdate: o.save(sdate)
        else: o.save()
        nr += 1
    if nr: event.ok(nr)

hemel.registreer("lees.post", lees_post)

def lees_kopie(event):
    rest = event.rest()
    if not rest: return
    try: result = haal_url("GET", rest + "/all").read()
    except socket.gaierror as ex: event.reply(str(ex)) ; return
    obj_list = json.loads(str(result, "utf-8"))
    for nr, url in obj_list.items():
        res = haal_url("GET", url).read()
        obj = json.loads(str(res, "utf-8"))
        o = Ding()
        o.update(obj)
        o.save()

hemel.registreer("lees.kopie", lees_kopie)
