# boek/werken/lees.py
#
#

""" commenting. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from boek.helpers import j, error, parse_email, short_date, ftime, haal_url
from boek.ding import Ding
from boek.hemel import hemel

import email.message
import datetime
import mailbox
import socket
import email
import time
import os

## CMNDS

def schrijf_noteer(event):
    rest = event.rest()
    try: key, value = rest.split(" ", 1)
    except ValueError: return
    o = Ding()
    if key in dir(o): event.reply("%s already defined in default Ding" % key) ; return
    o.prefix = "noteer"   
    o[key] = value
    path = o.save()
    event.ok()

hemel.registreer("schrijf.noteer", schrijf_noteer)

def schrijf_opmerking(event):
    objs = event.selected()
    if not objs: return
    obj = objs[0]
    if "comment" not in obj: obj.comment = []
    obj.comment.append(" ".join(event.args[2:]))
    obj.sync()
    event.ok()

hemel.registreer("schrijf.opmerking", schrijf_opmerking)

def schrijf_melding(event):
    o = Ding()
    o.prefix = "melding"
    o.ctype = "melding"
    o.melding = event.rest()
    o.save()
    event.ok()

hemel.registreer("schrijf.melding", schrijf_melding)

def schrijf_toestand(event):
    o = Ding()
    o.prefix = "toestand"
    o.status = event.rest()
    o.save()
    event.ok()

hemel.registreer("schrijf.toestand", schrijf_toestand)

