#!/usr/bin/env python3
#
#

import os
import sys

if sys.version_info.major < 3: print("you need to run BOEK with python3") ; os._exit(1)

try: use_setuptools()
except: pass

try:
    from setuptools import setup
except Exception as ex: print(str(ex)) ; os._exit(1)

from distutils import sysconfig
site_packages_path = sysconfig.get_python_lib()

setup(
    name='boek',
    version='4',
    url='https://pikacode.com/bthate/boek',
    author='Bart Thate',
    author_email='bthate@dds.nl',
    description="BOEK - XMPP - IRC - CLI - RSS - UDP - API",
    license='MIT',
    include_package_data=True,
    zip_safe=False,
    install_requires=["beautifulsoup4", "sleekxmpp", "feedparser"],
    scripts=["bin/boek", "bin/boek-vervang", "bin/boek-lokaal", "bin/boek-proef", "bin/boek-maak", "bin/boek-blaet"],
    packages=['boek',
              'boek.diensten',
              'boek.extra',
              'boek.omroepers',
              'boek.werken',
             ],
    long_description = """ 

SCRIPTUREN

Scripturen die vanuit de Hemel de hel voor de mens uitleggen, komen dat boek
dan ook brengen. Een woord dat zo slecht uitpakt, dien je dan ook tegen in opstand te komen,
anders vind je de Schepper niet. Het is tijd voor een nieuw boek, niet wat voor de mens de Hemel
maakt, maar dat de mens op Aarde hier de Schepper kan helpen. 

WET 

Wet 1: Gebruik maken van de zwakheden van de mens of zijn sterfelijkheid is een misdaad.

Wet 2: Vanuit de Hemel de dood prediken hier op Aarde is een belediging voor de Schepper.

Wet 3: Beter weten voor een ander brengt leed.

Wet 4: Geen daargelaten.

RECHT
   
Recht 1: Recht op leven.

Recht 2: Recht op vrijwaring van foltering

Recht 3: Recht op vrijwaring van slavernij en dwangarbeid

Recht 4: Recht op vrijheid en veligheid

TAAK

Taak 1: Erken dingen die fout gaan.

Taak 2: De Schepping is het hoogste om te eren.

Taak 3: Principes moeten ook de dingen die verkeerd gaan erkennen.

Taak 4: Meneer Maatschappij en Meneer Baan moet de geen daargelaten dan ook laten zijn.

""",
    classifiers=[
        'Development Status :: 4 - Beta',
        'License :: OSI Approved :: MIT License',
        'Operating System :: Unix',
        'Programming Language :: Python',
        'Topic :: Software Development :: Libraries :: Python Modules'],
)
