// Generated by CoffeeScript 1.6.3
var $, cols, quit, resize, rows, term, ws, ws_url;

term = ws = null;

cols = rows = null;

quit = false;

$ = document.querySelectorAll.bind(document);

ws_url = 'ws://' + document.location.host + '/ws' + location.pathname;

ws = new WebSocket(ws_url);

ws.onopen = function() {
  console.log("WebSocket open", arguments);
  term = new Terminal({
    visualBell: 100,
    screenKeys: true,
    scrollback: -1
  });
  term.on("data", function(data) {
    return ws.send('SH|' + data);
  });
  term.on("title", function(title) {
    return document.title = title;
  });
  term.open($('main')[0]);
  $('.terminal')[0].style = '';
  return resize();
};

ws.onclose = function() {
  if (term) {
    term.destroy();
  }
  console.log("WebSocket closed", arguments);
  quit = true;
  return open('', '_self').close();
};

ws.onerror = function() {
  return console.log("WebSocket error", arguments);
};

ws.onmessage = function(event) {
  return term.write(event.data);
};

addEventListener('beforeunload', function() {
  if (!quit) {
    return 'This will exit the terminal session';
  }
});

addEventListener('resize', resize = function() {
  var eh, ew, fake_term, fake_term_div, fake_term_line, main, main_bb;
  main = $('main')[0];
  fake_term = document.createElement('div');
  fake_term.className = 'terminal test';
  fake_term_div = document.createElement('div');
  fake_term_line = document.createElement('span');
  fake_term_line.textContent = '0123456789';
  fake_term_div.appendChild(fake_term_line);
  fake_term.appendChild(fake_term_div);
  main.appendChild(fake_term);
  ew = fake_term_line.getBoundingClientRect().width;
  eh = fake_term_div.getBoundingClientRect().height;
  main.removeChild(fake_term);
  main_bb = main.getBoundingClientRect();
  cols = Math.floor(10 * main_bb.width / ew) - 1;
  rows = Math.floor(main_bb.height / eh);
  console.log("Computed " + cols + " cols and " + rows + " rows from ", main_bb, ew, eh);
  term.resize(cols, rows);
  return ws.send("RS|" + cols + "," + rows);
});
