C                                                                                      
C  L-BFGS-B IS RELEASED UNDER THE “NEW BSD LICENSE” (AKA “MODIFIED BSD LICENSE”        
C  OR “3-CLAUSE LICENSE”)                                                              
C  PLEASE READ ATTACHED FILE LICENSE.TXT                                               
C                                        
C===========   L-BFGS-B (VERSION 3.0.  APRIL 25, 2011  ===================
C
C     THIS IS A MODIFIED VERSION OF L-BFGS-B. MINOR CHANGES IN THE UPDATED 
C     CODE APPEAR PRECEDED BY A LINE COMMENT AS FOLLOWS 
C  
C     C-JLM-JN 
C
C     MAJOR CHANGES ARE DESCRIBED IN THE ACCOMPANYING PAPER:
C
C         JORGE NOCEDAL AND JOSE LUIS MORALES, REMARK ON "ALGORITHM 778: 
C         L-BFGS-B: FORTRAN SUBROUTINES FOR LARGE-SCALE BOUND CONSTRAINED 
C         OPTIMIZATION"  (2011). TO APPEAR IN  ACM TRANSACTIONS ON 
C         MATHEMATICAL SOFTWARE,
C
C     THE PAPER DESCRIBES AN IMPROVEMENT AND A CORRECTION TO ALGORITHM 778. 
C     IT IS SHOWN THAT THE PERFORMANCE OF THE ALGORITHM CAN BE IMPROVED 
C     SIGNIFICANTLY BY MAKING A RELATIVELY SIMPLE MODICATION TO THE SUBSPACE 
C     MINIMIZATION PHASE. THE CORRECTION CONCERNS AN ERROR CAUSED BY THE USE 
C     OF ROUTINE DPMEPS TO ESTIMATE MACHINE PRECISION. 
C
C     THE TOTAL WORK SPACE **WA** REQUIRED BY THE NEW VERSION IS 
C 
C                  2*M*N + 11M*M + 5*N + 8*M 
C
C     THE OLD VERSION REQUIRED 
C
C                  2*M*N + 12M*M + 4*N + 12*M 
C
C
C            J. NOCEDAL  DEPARTMENT OF ELECTRICAL ENGINEERING AND
C                        COMPUTER SCIENCE.
C                        NORTHWESTERN UNIVERSITY. EVANSTON, IL. USA
C
C
C           J.L MORALES  DEPARTAMENTO DE MATEMATICAS, 
C                        INSTITUTO TECNOLOGICO AUTONOMO DE MEXICO
C                        MEXICO D.F. MEXICO.
C
C                        MARCH  2011    
C                                                 
C============================================================================= 
      SUBROUTINE SETULB(N, M, X, L, U, NBD, F, G, FACTR, PGTOL, WA, IWA,
     +                 TASK, IPRINT, CSAVE, LSAVE, ISAVE, DSAVE)
 
      CHARACTER*60     TASK, CSAVE
      LOGICAL          LSAVE(4)
      INTEGER          N, M, IPRINT, 
     +                 NBD(N), IWA(3*N), ISAVE(44)
      DOUBLE PRECISION F, FACTR, PGTOL, X(N), L(N), U(N), G(N),
C
C-JLM-JN
     +                 WA(2*M*N + 5*N + 11*M*M + 8*M), DSAVE(29)
 
C     ************
C
C     SUBROUTINE SETULB
C
C     THIS SUBROUTINE PARTITIONS THE WORKING ARRAYS WA AND IWA, AND 
C       THEN USES THE LIMITED MEMORY BFGS METHOD TO SOLVE THE BOUND
C       CONSTRAINED OPTIMIZATION PROBLEM BY CALLING MAINLB.
C       (THE DIRECT METHOD WILL BE USED IN THE SUBSPACE MINIMIZATION.)
C
C     N IS AN INTEGER VARIABLE.
C       ON ENTRY N IS THE DIMENSION OF THE PROBLEM.
C       ON EXIT N IS UNCHANGED.
C
C     M IS AN INTEGER VARIABLE.
C       ON ENTRY M IS THE MAXIMUM NUMBER OF VARIABLE METRIC CORRECTIONS
C         USED TO DEFINE THE LIMITED MEMORY MATRIX.
C       ON EXIT M IS UNCHANGED.
C
C     X IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON ENTRY X IS AN APPROXIMATION TO THE SOLUTION.
C       ON EXIT X IS THE CURRENT APPROXIMATION.
C
C     L IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON ENTRY L IS THE LOWER BOUND ON X.
C       ON EXIT L IS UNCHANGED.
C
C     U IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON ENTRY U IS THE UPPER BOUND ON X.
C       ON EXIT U IS UNCHANGED.
C
C     NBD IS AN INTEGER ARRAY OF DIMENSION N.
C       ON ENTRY NBD REPRESENTS THE TYPE OF BOUNDS IMPOSED ON THE
C         VARIABLES, AND MUST BE SPECIFIED AS FOLLOWS:
C         NBD(I)=0 IF X(I) IS UNBOUNDED,
C                1 IF X(I) HAS ONLY A LOWER BOUND,
C                2 IF X(I) HAS BOTH LOWER AND UPPER BOUNDS, AND
C                3 IF X(I) HAS ONLY AN UPPER BOUND.
C       ON EXIT NBD IS UNCHANGED.
C
C     F IS A DOUBLE PRECISION VARIABLE.
C       ON FIRST ENTRY F IS UNSPECIFIED.
C       ON FINAL EXIT F IS THE VALUE OF THE FUNCTION AT X.
C
C     G IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON FIRST ENTRY G IS UNSPECIFIED.
C       ON FINAL EXIT G IS THE VALUE OF THE GRADIENT AT X.
C
C     FACTR IS A DOUBLE PRECISION VARIABLE.
C       ON ENTRY FACTR >= 0 IS SPECIFIED BY THE USER.  THE ITERATION
C         WILL STOP WHEN
C
C         (F^K - F^{K+1})/MAX{|F^K|,|F^{K+1}|,1} <= FACTR*EPSMCH
C
C         WHERE EPSMCH IS THE MACHINE PRECISION, WHICH IS AUTOMATICALLY
C         GENERATED BY THE CODE. TYPICAL VALUES FOR FACTR: 1.D+12 FOR
C         LOW ACCURACY; 1.D+7 FOR MODERATE ACCURACY; 1.D+1 FOR EXTREMELY
C         HIGH ACCURACY.
C       ON EXIT FACTR IS UNCHANGED.
C
C     PGTOL IS A DOUBLE PRECISION VARIABLE.
C       ON ENTRY PGTOL >= 0 IS SPECIFIED BY THE USER.  THE ITERATION
C         WILL STOP WHEN
C
C                 MAX{|PROJ G_I | I = 1, ..., N} <= PGTOL
C
C         WHERE PG_I IS THE ITH COMPONENT OF THE PROJECTED GRADIENT.   
C       ON EXIT PGTOL IS UNCHANGED.
C
C     WA IS A DOUBLE PRECISION WORKING ARRAY OF LENGTH 
C       (2MMAX + 5)NMAX + 12MMAX^2 + 12MMAX.
C
C     IWA IS AN INTEGER WORKING ARRAY OF LENGTH 3NMAX.
C
C     TASK IS A WORKING STRING OF CHARACTERS OF LENGTH 60 INDICATING
C       THE CURRENT JOB WHEN ENTERING AND QUITTING THIS SUBROUTINE.
C
C     IPRINT IS AN INTEGER VARIABLE THAT MUST BE SET BY THE USER.
C       IT CONTROLS THE FREQUENCY AND TYPE OF OUTPUT GENERATED:
C        IPRINT<0    NO OUTPUT IS GENERATED;
C        IPRINT=0    PRINT ONLY ONE LINE AT THE LAST ITERATION;
C        0<IPRINT<99 PRINT ALSO F AND |PROJ G| EVERY IPRINT ITERATIONS;
C        IPRINT=99   PRINT DETAILS OF EVERY ITERATION EXCEPT N-VECTORS;
C        IPRINT=100  PRINT ALSO THE CHANGES OF ACTIVE SET AND FINAL X;
C        IPRINT>100  PRINT DETAILS OF EVERY ITERATION INCLUDING X AND G;
C       WHEN IPRINT > 0, THE FILE ITERATE.DAT WILL BE CREATED TO
C                        SUMMARIZE THE ITERATION.
C
C     CSAVE IS A WORKING STRING OF CHARACTERS OF LENGTH 60.
C
C     LSAVE IS A LOGICAL WORKING ARRAY OF DIMENSION 4.
C       ON EXIT WITH 'TASK' = NEW_X, THE FOLLOWING INFORMATION IS 
C                                                             AVAILABLE:
C         IF LSAVE(1) = .TRUE.  THEN  THE INITIAL X HAS BEEN REPLACED BY
C                                     ITS PROJECTION IN THE FEASIBLE SET;
C         IF LSAVE(2) = .TRUE.  THEN  THE PROBLEM IS CONSTRAINED;
C         IF LSAVE(3) = .TRUE.  THEN  EACH VARIABLE HAS UPPER AND LOWER
C                                     BOUNDS;
C
C     ISAVE IS AN INTEGER WORKING ARRAY OF DIMENSION 44.
C       ON EXIT WITH 'TASK' = NEW_X, THE FOLLOWING INFORMATION IS 
C                                                             AVAILABLE:
C         ISAVE(22) = THE TOTAL NUMBER OF INTERVALS EXPLORED IN THE 
C                         SEARCH OF CAUCHY POINTS;
C         ISAVE(26) = THE TOTAL NUMBER OF SKIPPED BFGS UPDATES BEFORE 
C                         THE CURRENT ITERATION;
C         ISAVE(30) = THE NUMBER OF CURRENT ITERATION;
C         ISAVE(31) = THE TOTAL NUMBER OF BFGS UPDATES PRIOR THE CURRENT
C                         ITERATION;
C         ISAVE(33) = THE NUMBER OF INTERVALS EXPLORED IN THE SEARCH OF
C                         CAUCHY POINT IN THE CURRENT ITERATION;
C         ISAVE(34) = THE TOTAL NUMBER OF FUNCTION AND GRADIENT 
C                         EVALUATIONS;
C         ISAVE(36) = THE NUMBER OF FUNCTION VALUE OR GRADIENT
C                                  EVALUATIONS IN THE CURRENT ITERATION;
C         IF ISAVE(37) = 0  THEN THE SUBSPACE ARGMIN IS WITHIN THE BOX;
C         IF ISAVE(37) = 1  THEN THE SUBSPACE ARGMIN IS BEYOND THE BOX;
C         ISAVE(38) = THE NUMBER OF FREE VARIABLES IN THE CURRENT
C                         ITERATION;
C         ISAVE(39) = THE NUMBER OF ACTIVE CONSTRAINTS IN THE CURRENT
C                         ITERATION;
C         N + 1 - ISAVE(40) = THE NUMBER OF VARIABLES LEAVING THE SET OF
C                           ACTIVE CONSTRAINTS IN THE CURRENT ITERATION;
C         ISAVE(41) = THE NUMBER OF VARIABLES ENTERING THE SET OF ACTIVE
C                         CONSTRAINTS IN THE CURRENT ITERATION.
C
C     DSAVE IS A DOUBLE PRECISION WORKING ARRAY OF DIMENSION 29.
C       ON EXIT WITH 'TASK' = NEW_X, THE FOLLOWING INFORMATION IS
C                                                             AVAILABLE:
C         DSAVE(1) = CURRENT 'THETA' IN THE BFGS MATRIX;
C         DSAVE(2) = F(X) IN THE PREVIOUS ITERATION;
C         DSAVE(3) = FACTR*EPSMCH;
C         DSAVE(4) = 2-NORM OF THE LINE SEARCH DIRECTION VECTOR;
C         DSAVE(5) = THE MACHINE PRECISION EPSMCH GENERATED BY THE CODE;
C         DSAVE(7) = THE ACCUMULATED TIME SPENT ON SEARCHING FOR
C                                                         CAUCHY POINTS;
C         DSAVE(8) = THE ACCUMULATED TIME SPENT ON
C                                                 SUBSPACE MINIMIZATION;
C         DSAVE(9) = THE ACCUMULATED TIME SPENT ON LINE SEARCH;
C         DSAVE(11) = THE SLOPE OF THE LINE SEARCH FUNCTION AT
C                                  THE CURRENT POINT OF LINE SEARCH;
C         DSAVE(12) = THE MAXIMUM RELATIVE STEP LENGTH IMPOSED IN
C                                                           LINE SEARCH;
C         DSAVE(13) = THE INFINITY NORM OF THE PROJECTED GRADIENT;
C         DSAVE(14) = THE RELATIVE STEP LENGTH IN THE LINE SEARCH;
C         DSAVE(15) = THE SLOPE OF THE LINE SEARCH FUNCTION AT
C                                 THE STARTING POINT OF THE LINE SEARCH;
C         DSAVE(16) = THE SQUARE OF THE 2-NORM OF THE LINE SEARCH
C                                                      DIRECTION VECTOR.
C
C     SUBPROGRAMS CALLED:
C
C       L-BFGS-B LIBRARY ... MAINLB.    
C
C
C     REFERENCES:
C
C       [1] R. H. BYRD, P. LU, J. NOCEDAL AND C. ZHU, ``A LIMITED
C       MEMORY ALGORITHM FOR BOUND CONSTRAINED OPTIMIZATION'',
C       SIAM J. SCIENTIFIC COMPUTING 16 (1995), NO. 5, PP. 1190--1208.
C
C       [2] C. ZHU, R.H. BYRD, P. LU, J. NOCEDAL, ``L-BFGS-B: A
C       LIMITED MEMORY FORTRAN CODE FOR SOLVING BOUND CONSTRAINED
C       OPTIMIZATION PROBLEMS'', TECH. REPORT, NAM-11, EECS DEPARTMENT,
C       NORTHWESTERN UNIVERSITY, 1994.
C
C       (POSTSCRIPT FILES OF THESE PAPERS ARE AVAILABLE VIA ANONYMOUS
C        FTP TO EECS.NWU.EDU IN THE DIRECTORY PUB/LBFGS/LBFGS_BCM.)
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     ************
C-JLM-JN 
      INTEGER   LWS,LR,LZ,LT,LD,LXP,LWA,
     +          LWY,LSY,LSS,LWT,LWN,LSND

      IF (TASK .EQ. 'START') THEN
         ISAVE(1)  = M*N
         ISAVE(2)  = M**2
         ISAVE(3)  = 4*M**2
         ISAVE(4)  = 1                      ! WS      M*N
         ISAVE(5)  = ISAVE(4)  + ISAVE(1)   ! WY      M*N
         ISAVE(6)  = ISAVE(5)  + ISAVE(1)   ! WSY     M**2
         ISAVE(7)  = ISAVE(6)  + ISAVE(2)   ! WSS     M**2
         ISAVE(8)  = ISAVE(7)  + ISAVE(2)   ! WT      M**2
         ISAVE(9)  = ISAVE(8)  + ISAVE(2)   ! WN      4*M**2
         ISAVE(10) = ISAVE(9)  + ISAVE(3)   ! WSND    4*M**2
         ISAVE(11) = ISAVE(10) + ISAVE(3)   ! WZ      N
         ISAVE(12) = ISAVE(11) + N          ! WR      N
         ISAVE(13) = ISAVE(12) + N          ! WD      N
         ISAVE(14) = ISAVE(13) + N          ! WT      N
         ISAVE(15) = ISAVE(14) + N          ! WXP     N
         ISAVE(16) = ISAVE(15) + N          ! WA      8*M
      ENDIF
      LWS  = ISAVE(4)
      LWY  = ISAVE(5)
      LSY  = ISAVE(6)
      LSS  = ISAVE(7)
      LWT  = ISAVE(8)
      LWN  = ISAVE(9)
      LSND = ISAVE(10)
      LZ   = ISAVE(11)
      LR   = ISAVE(12)
      LD   = ISAVE(13)
      LT   = ISAVE(14)
      LXP  = ISAVE(15)
      LWA  = ISAVE(16)

      CALL MAINLB(N,M,X,L,U,NBD,F,G,FACTR,PGTOL,
     +  WA(LWS),WA(LWY),WA(LSY),WA(LSS), WA(LWT),
     +  WA(LWN),WA(LSND),WA(LZ),WA(LR),WA(LD),WA(LT),WA(LXP),
     +  WA(LWA),
     +  IWA(1),IWA(N+1),IWA(2*N+1),TASK,IPRINT, 
     +  CSAVE,LSAVE,ISAVE(22),DSAVE)

      RETURN

      END

C======================= THE END OF SETULB =============================
 
      SUBROUTINE MAINLB(N, M, X, L, U, NBD, F, G, FACTR, PGTOL, WS, WY,
     +                  SY, SS, WT, WN, SND, Z, R, D, T, XP, WA, 
     +                  INDEX, IWHERE, INDX2, TASK,
     +                  IPRINT, CSAVE, LSAVE, ISAVE, DSAVE)
      IMPLICIT NONE
      CHARACTER*60     TASK, CSAVE
      LOGICAL          LSAVE(4)
      INTEGER          N, M, IPRINT, NBD(N), INDEX(N),
     +                 IWHERE(N), INDX2(N), ISAVE(23)
      DOUBLE PRECISION F, FACTR, PGTOL,
     +                 X(N), L(N), U(N), G(N), Z(N), R(N), D(N), T(N), 
C-JLM-JN
     +                 XP(N), 
     +                 WA(8*M), 
     +                 WS(N, M), WY(N, M), SY(M, M), SS(M, M), 
     +                 WT(M, M), WN(2*M, 2*M), SND(2*M, 2*M), DSAVE(29)

C     ************
C
C     SUBROUTINE MAINLB
C
C     THIS SUBROUTINE SOLVES BOUND CONSTRAINED OPTIMIZATION PROBLEMS BY
C       USING THE COMPACT FORMULA OF THE LIMITED MEMORY BFGS UPDATES.
C       
C     N IS AN INTEGER VARIABLE.
C       ON ENTRY N IS THE NUMBER OF VARIABLES.
C       ON EXIT N IS UNCHANGED.
C
C     M IS AN INTEGER VARIABLE.
C       ON ENTRY M IS THE MAXIMUM NUMBER OF VARIABLE METRIC
C          CORRECTIONS ALLOWED IN THE LIMITED MEMORY MATRIX.
C       ON EXIT M IS UNCHANGED.
C
C     X IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON ENTRY X IS AN APPROXIMATION TO THE SOLUTION.
C       ON EXIT X IS THE CURRENT APPROXIMATION.
C
C     L IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON ENTRY L IS THE LOWER BOUND OF X.
C       ON EXIT L IS UNCHANGED.
C
C     U IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON ENTRY U IS THE UPPER BOUND OF X.
C       ON EXIT U IS UNCHANGED.
C
C     NBD IS AN INTEGER ARRAY OF DIMENSION N.
C       ON ENTRY NBD REPRESENTS THE TYPE OF BOUNDS IMPOSED ON THE
C         VARIABLES, AND MUST BE SPECIFIED AS FOLLOWS:
C         NBD(I)=0 IF X(I) IS UNBOUNDED,
C                1 IF X(I) HAS ONLY A LOWER BOUND,
C                2 IF X(I) HAS BOTH LOWER AND UPPER BOUNDS,
C                3 IF X(I) HAS ONLY AN UPPER BOUND.
C       ON EXIT NBD IS UNCHANGED.
C
C     F IS A DOUBLE PRECISION VARIABLE.
C       ON FIRST ENTRY F IS UNSPECIFIED.
C       ON FINAL EXIT F IS THE VALUE OF THE FUNCTION AT X.
C
C     G IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON FIRST ENTRY G IS UNSPECIFIED.
C       ON FINAL EXIT G IS THE VALUE OF THE GRADIENT AT X.
C
C     FACTR IS A DOUBLE PRECISION VARIABLE.
C       ON ENTRY FACTR >= 0 IS SPECIFIED BY THE USER.  THE ITERATION
C         WILL STOP WHEN
C
C         (F^K - F^{K+1})/MAX{|F^K|,|F^{K+1}|,1} <= FACTR*EPSMCH
C
C         WHERE EPSMCH IS THE MACHINE PRECISION, WHICH IS AUTOMATICALLY
C         GENERATED BY THE CODE.
C       ON EXIT FACTR IS UNCHANGED.
C
C     PGTOL IS A DOUBLE PRECISION VARIABLE.
C       ON ENTRY PGTOL >= 0 IS SPECIFIED BY THE USER.  THE ITERATION
C         WILL STOP WHEN
C
C                 MAX{|PROJ G_I | I = 1, ..., N} <= PGTOL
C
C         WHERE PG_I IS THE ITH COMPONENT OF THE PROJECTED GRADIENT.
C       ON EXIT PGTOL IS UNCHANGED.
C
C     WS, WY, SY, AND WT ARE DOUBLE PRECISION WORKING ARRAYS USED TO
C       STORE THE FOLLOWING INFORMATION DEFINING THE LIMITED MEMORY
C          BFGS MATRIX:
C          WS, OF DIMENSION N X M, STORES S, THE MATRIX OF S-VECTORS;
C          WY, OF DIMENSION N X M, STORES Y, THE MATRIX OF Y-VECTORS;
C          SY, OF DIMENSION M X M, STORES S'Y;
C          SS, OF DIMENSION M X M, STORES S'S;
C          YY, OF DIMENSION M X M, STORES Y'Y;
C          WT, OF DIMENSION M X M, STORES THE CHOLESKY FACTORIZATION
C                                  OF (THETA*S'S+LD^(-1)L'); SEE EQ.
C                                  (2.26) IN [3].
C
C     WN IS A DOUBLE PRECISION WORKING ARRAY OF DIMENSION 2M X 2M
C       USED TO STORE THE LEL^T FACTORIZATION OF THE INDEFINITE MATRIX
C                 K = [-D -Y'ZZ'Y/THETA     L_A'-R_Z'  ]
C                     [L_A -R_Z           THETA*S'AA'S ]
C
C       WHERE     E = [-I  0]
C                     [ 0  I]
C
C     SND IS A DOUBLE PRECISION WORKING ARRAY OF DIMENSION 2M X 2M
C       USED TO STORE THE LOWER TRIANGULAR PART OF
C                 N = [Y' ZZ'Y   L_A'+R_Z']
C                     [L_A +R_Z  S'AA'S   ]
C            
C     Z(N),R(N),D(N),T(N), XP(N),WA(8*M) ARE DOUBLE PRECISION WORKING ARRAYS.
C       Z  IS USED AT DIFFERENT TIMES TO STORE THE CAUCHY POINT AND
C          THE NEWTON POINT.
C       XP IS USED TO SAFEGUARD THE PROJECTED NEWTON DIRECTION
C
C     SG(M),SGO(M),YG(M),YGO(M) ARE DOUBLE PRECISION WORKING ARRAYS. 
C
C     INDEX IS AN INTEGER WORKING ARRAY OF DIMENSION N.
C       IN SUBROUTINE FREEV, INDEX IS USED TO STORE THE FREE AND FIXED
C          VARIABLES AT THE GENERALIZED CAUCHY POINT (GCP).
C
C     IWHERE IS AN INTEGER WORKING ARRAY OF DIMENSION N USED TO RECORD
C       THE STATUS OF THE VECTOR X FOR GCP COMPUTATION.
C       IWHERE(I)=0 OR -3 IF X(I) IS FREE AND HAS BOUNDS,
C                 1       IF X(I) IS FIXED AT L(I), AND L(I) .NE. U(I)
C                 2       IF X(I) IS FIXED AT U(I), AND U(I) .NE. L(I)
C                 3       IF X(I) IS ALWAYS FIXED, I.E.,  U(I)=X(I)=L(I)
C                -1       IF X(I) IS ALWAYS FREE, I.E., NO BOUNDS ON IT.
C
C     INDX2 IS AN INTEGER WORKING ARRAY OF DIMENSION N.
C       WITHIN SUBROUTINE CAUCHY, INDX2 CORRESPONDS TO THE ARRAY IORDER.
C       IN SUBROUTINE FREEV, A LIST OF VARIABLES ENTERING AND LEAVING
C       THE FREE SET IS STORED IN INDX2, AND IT IS PASSED ON TO
C       SUBROUTINE FORMK WITH THIS INFORMATION.
C
C     TASK IS A WORKING STRING OF CHARACTERS OF LENGTH 60 INDICATING
C       THE CURRENT JOB WHEN ENTERING AND LEAVING THIS SUBROUTINE.
C
C     IPRINT IS AN INTEGER VARIABLE THAT MUST BE SET BY THE USER.
C       IT CONTROLS THE FREQUENCY AND TYPE OF OUTPUT GENERATED:
C        IPRINT<0    NO OUTPUT IS GENERATED;
C        IPRINT=0    PRINT ONLY ONE LINE AT THE LAST ITERATION;
C        0<IPRINT<99 PRINT ALSO F AND |PROJ G| EVERY IPRINT ITERATIONS;
C        IPRINT=99   PRINT DETAILS OF EVERY ITERATION EXCEPT N-VECTORS;
C        IPRINT=100  PRINT ALSO THE CHANGES OF ACTIVE SET AND FINAL X;
C        IPRINT>100  PRINT DETAILS OF EVERY ITERATION INCLUDING X AND G;
C       WHEN IPRINT > 0, THE FILE ITERATE.DAT WILL BE CREATED TO
C                        SUMMARIZE THE ITERATION.
C
C     CSAVE IS A WORKING STRING OF CHARACTERS OF LENGTH 60.
C
C     LSAVE IS A LOGICAL WORKING ARRAY OF DIMENSION 4.
C
C     ISAVE IS AN INTEGER WORKING ARRAY OF DIMENSION 23.
C
C     DSAVE IS A DOUBLE PRECISION WORKING ARRAY OF DIMENSION 29.
C
C
C     SUBPROGRAMS CALLED
C
C       L-BFGS-B LIBRARY ... CAUCHY, SUBSM, LNSRLB, FORMK, 
C
C        ERRCLB, PRN1LB, PRN2LB, PRN3LB, ACTIVE, PROJGR,
C
C        FREEV, CMPRLB, MATUPD, FORMT.
C
C       MINPACK2 LIBRARY ... TIMER
C
C       LINPACK LIBRARY ... DCOPY, DDOT.
C
C
C     REFERENCES:
C
C       [1] R. H. BYRD, P. LU, J. NOCEDAL AND C. ZHU, ``A LIMITED
C       MEMORY ALGORITHM FOR BOUND CONSTRAINED OPTIMIZATION'',
C       SIAM J. SCIENTIFIC COMPUTING 16 (1995), NO. 5, PP. 1190--1208.
C
C       [2] C. ZHU, R.H. BYRD, P. LU, J. NOCEDAL, ``L-BFGS-B: FORTRAN
C       SUBROUTINES FOR LARGE SCALE BOUND CONSTRAINED OPTIMIZATION''
C       TECH. REPORT, NAM-11, EECS DEPARTMENT, NORTHWESTERN UNIVERSITY,
C       1994.
C 
C       [3] R. BYRD, J. NOCEDAL AND R. SCHNABEL "REPRESENTATIONS OF
C       QUASI-NEWTON MATRICES AND THEIR USE IN LIMITED MEMORY METHODS'',
C       MATHEMATICAL PROGRAMMING 63 (1994), NO. 4, PP. 129-156.
C
C       (POSTSCRIPT FILES OF THESE PAPERS ARE AVAILABLE VIA ANONYMOUS
C        FTP TO EECS.NWU.EDU IN THE DIRECTORY PUB/LBFGS/LBFGS_BCM.)
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     ************
 
      LOGICAL          PRJCTD,CNSTND,BOXED,UPDATD,WRK
      CHARACTER*3      WORD
      INTEGER          I,K,NINTOL,ITFILE,IBACK,NSKIP,
     +                 HEAD,COL,ITER,ITAIL,IUPDAT,
     +                 NSEG,NFGV,INFO,IFUN,
     +                 IWORD,NFREE,NACT,ILEAVE,NENTER
      DOUBLE PRECISION THETA,FOLD,DDOT,DR,RR,TOL,
     +                 XSTEP,SBGNRM,DDUM,DNORM,DTD,EPSMCH,
     +                 CPU1,CPU2,CACHYT,SBTIME,LNSCHT,TIME1,TIME2,
     +                 GD,GDOLD,STP,STPMX,TIME
      DOUBLE PRECISION ONE,ZERO
      PARAMETER        (ONE=1.0D0,ZERO=0.0D0)
      
      IF (TASK .EQ. 'START') THEN

         EPSMCH = EPSILON(ONE)

         CALL TIMER(TIME1)

C        INITIALIZE COUNTERS AND SCALARS WHEN TASK='START'.

C           FOR THE LIMITED MEMORY BFGS MATRICES:
         COL    = 0
         HEAD   = 1
         THETA  = ONE
         IUPDAT = 0
         UPDATD = .FALSE.
         IBACK  = 0
         ITAIL  = 0
         IWORD  = 0
         NACT   = 0
         ILEAVE = 0
         NENTER = 0
         FOLD   = ZERO
         DNORM  = ZERO
         CPU1   = ZERO
         GD     = ZERO
         STPMX  = ZERO
         SBGNRM = ZERO
         STP    = ZERO
         GDOLD  = ZERO
         DTD    = ZERO

C           FOR OPERATION COUNTS:
         ITER   = 0
         NFGV   = 0
         NSEG   = 0
         NINTOL = 0
         NSKIP  = 0
         NFREE  = N
         IFUN   = 0
C           FOR STOPPING TOLERANCE:
         TOL = FACTR*EPSMCH

C           FOR MEASURING RUNNING TIME:
         CACHYT = 0
         SBTIME = 0
         LNSCHT = 0
 
C           'WORD' RECORDS THE STATUS OF SUBSPACE SOLUTIONS.
         WORD = '---'

C           'INFO' RECORDS THE TERMINATION INFORMATION.
         INFO = 0

         ITFILE = 8
         IF (IPRINT .GE. 1) THEN
C                                OPEN A SUMMARY FILE 'ITERATE.DAT'
            OPEN (8, FILE = 'ITERATE.DAT', STATUS = 'UNKNOWN')
         ENDIF            

C        CHECK THE INPUT ARGUMENTS FOR ERRORS.

         CALL ERRCLB(N,M,FACTR,L,U,NBD,TASK,INFO,K)
         IF (TASK(1:5) .EQ. 'ERROR') THEN
            CALL PRN3LB(N,X,F,TASK,IPRINT,INFO,ITFILE,
     +                  ITER,NFGV,NINTOL,NSKIP,NACT,SBGNRM,
     +                  ZERO,NSEG,WORD,IBACK,STP,XSTEP,K,
     +                  CACHYT,SBTIME,LNSCHT)
            RETURN
         ENDIF

         CALL PRN1LB(N,M,L,U,X,IPRINT,ITFILE,EPSMCH)
 
C        INITIALIZE IWHERE & PROJECT X ONTO THE FEASIBLE SET.
 
         CALL ACTIVE(N,L,U,NBD,X,IWHERE,IPRINT,PRJCTD,CNSTND,BOXED) 

C        THE END OF THE INITIALIZATION.

      ELSE
C          RESTORE LOCAL VARIABLES.

         PRJCTD = LSAVE(1)
         CNSTND = LSAVE(2)
         BOXED  = LSAVE(3)
         UPDATD = LSAVE(4)

         NINTOL = ISAVE(1)
         ITFILE = ISAVE(3)
         IBACK  = ISAVE(4)
         NSKIP  = ISAVE(5)
         HEAD   = ISAVE(6)
         COL    = ISAVE(7)
         ITAIL  = ISAVE(8)
         ITER   = ISAVE(9)
         IUPDAT = ISAVE(10)
         NSEG   = ISAVE(12)
         NFGV   = ISAVE(13)
         INFO   = ISAVE(14)
         IFUN   = ISAVE(15)
         IWORD  = ISAVE(16)
         NFREE  = ISAVE(17)
         NACT   = ISAVE(18)
         ILEAVE = ISAVE(19)
         NENTER = ISAVE(20)

         THETA  = DSAVE(1)
         FOLD   = DSAVE(2)
         TOL    = DSAVE(3)
         DNORM  = DSAVE(4)
         EPSMCH = DSAVE(5)
         CPU1   = DSAVE(6)
         CACHYT = DSAVE(7)
         SBTIME = DSAVE(8)
         LNSCHT = DSAVE(9)
         TIME1  = DSAVE(10)
         GD     = DSAVE(11)
         STPMX  = DSAVE(12)
         SBGNRM = DSAVE(13)
         STP    = DSAVE(14)
         GDOLD  = DSAVE(15)
         DTD    = DSAVE(16)
   
C        AFTER RETURNING FROM THE DRIVER GO TO THE POINT WHERE EXECUTION
C        IS TO RESUME.

         IF (TASK(1:5) .EQ. 'FG_LN') GOTO 666
         IF (TASK(1:5) .EQ. 'NEW_X') GOTO 777
         IF (TASK(1:5) .EQ. 'FG_ST') GOTO 111
         IF (TASK(1:4) .EQ. 'STOP') THEN
            IF (TASK(7:9) .EQ. 'CPU') THEN
C                                          RESTORE THE PREVIOUS ITERATE.
               CALL DCOPY(N,T,1,X,1)
               CALL DCOPY(N,R,1,G,1)
               F = FOLD
            ENDIF
            GOTO 999
         ENDIF
      ENDIF 

C     COMPUTE F0 AND G0.

      TASK = 'FG_START' 
C          RETURN TO THE DRIVER TO CALCULATE F AND G; REENTER AT 111.
      GOTO 1000
 111  CONTINUE
      NFGV = 1
 
C     COMPUTE THE INFINITY NORM OF THE (-) PROJECTED GRADIENT.
 
      CALL PROJGR(N,L,U,NBD,X,G,SBGNRM)
  
      IF (IPRINT .GE. 1) THEN
         WRITE (6,1002) ITER,F,SBGNRM
         WRITE (ITFILE,1003) ITER,NFGV,SBGNRM,F
      ENDIF
      IF (SBGNRM .LE. PGTOL) THEN
C                                TERMINATE THE ALGORITHM.
         TASK = 'CONVERGENCE: NORM_OF_PROJECTED_GRADIENT_<=_PGTOL'
         GOTO 999
      ENDIF 
 
C ----------------- THE BEGINNING OF THE LOOP --------------------------
 
 222  CONTINUE
      IF (IPRINT .GE. 99) WRITE (6,1001) ITER + 1
      IWORD = -1
C
      IF (.NOT. CNSTND .AND. COL .GT. 0) THEN 
C                                            SKIP THE SEARCH FOR GCP.
         CALL DCOPY(N,X,1,Z,1)
         WRK = UPDATD
         NSEG = 0
         GOTO 333
      ENDIF

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C     COMPUTE THE GENERALIZED CAUCHY POINT (GCP).
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

      CALL TIMER(CPU1) 
      CALL CAUCHY(N,X,L,U,NBD,G,INDX2,IWHERE,T,D,Z,
     +            M,WY,WS,SY,WT,THETA,COL,HEAD,
     +            WA(1),WA(2*M+1),WA(4*M+1),WA(6*M+1),NSEG,
     +            IPRINT, SBGNRM, INFO, EPSMCH)
      IF (INFO .NE. 0) THEN 
C         SINGULAR TRIANGULAR SYSTEM DETECTED; REFRESH THE LBFGS MEMORY.
         IF(IPRINT .GE. 1) WRITE (6, 1005)
         INFO   = 0
         COL    = 0
         HEAD   = 1
         THETA  = ONE
         IUPDAT = 0
         UPDATD = .FALSE.
         CALL TIMER(CPU2) 
         CACHYT = CACHYT + CPU2 - CPU1
         GOTO 222
      ENDIF
      CALL TIMER(CPU2) 
      CACHYT = CACHYT + CPU2 - CPU1
      NINTOL = NINTOL + NSEG

C     COUNT THE ENTERING AND LEAVING VARIABLES FOR ITER > 0; 
C     FIND THE INDEX SET OF FREE AND ACTIVE VARIABLES AT THE GCP.

      CALL FREEV(N,NFREE,INDEX,NENTER,ILEAVE,INDX2,
     +           IWHERE,WRK,UPDATD,CNSTND,IPRINT,ITER)
      NACT = N - NFREE

 333  CONTINUE
 
C     IF THERE ARE NO FREE VARIABLES OR B=THETA*I, THEN
C                                        SKIP THE SUBSPACE MINIMIZATION.
 
      IF (NFREE .EQ. 0 .OR. COL .EQ. 0) GOTO 555
 
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C     SUBSPACE MINIMIZATION.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

      CALL TIMER(CPU1) 

C     FORM  THE LEL^T FACTORIZATION OF THE INDEFINITE
C       MATRIX    K = [-D -Y'ZZ'Y/THETA     L_A'-R_Z'  ]
C                     [L_A -R_Z           THETA*S'AA'S ]
C       WHERE     E = [-I  0]
C                     [ 0  I]

      IF (WRK) CALL FORMK(N,NFREE,INDEX,NENTER,ILEAVE,INDX2,IUPDAT,
     +                 UPDATD,WN,SND,M,WS,WY,SY,THETA,COL,HEAD,INFO)
      IF (INFO .NE. 0) THEN
C          NONPOSITIVE DEFINITENESS IN CHOLESKY FACTORIZATION;
C          REFRESH THE LBFGS MEMORY AND RESTART THE ITERATION.
         IF(IPRINT .GE. 1) WRITE (6, 1006)
         INFO   = 0
         COL    = 0
         HEAD   = 1
         THETA  = ONE
         IUPDAT = 0
         UPDATD = .FALSE.
         CALL TIMER(CPU2) 
         SBTIME = SBTIME + CPU2 - CPU1 
         GOTO 222
      ENDIF 

C        COMPUTE R=-Z'B(XCP-XK)-Z'G (USING WA(2M+1)=W'(XCP-X)
C                                                   FROM 'CAUCHY').
      CALL CMPRLB(N,M,X,G,WS,WY,SY,WT,Z,R,WA,INDEX,
     +           THETA,COL,HEAD,NFREE,CNSTND,INFO)
      IF (INFO .NE. 0) GOTO 444

C-JLM-JN   CALL THE DIRECT METHOD. 

      CALL SUBSM( N, M, NFREE, INDEX, L, U, NBD, Z, R, XP, WS, WY,
     +           THETA, X, G, COL, HEAD, IWORD, WA, WN, IPRINT, INFO)
 444  CONTINUE
      IF (INFO .NE. 0) THEN 
C          SINGULAR TRIANGULAR SYSTEM DETECTED;
C          REFRESH THE LBFGS MEMORY AND RESTART THE ITERATION.
         IF(IPRINT .GE. 1) WRITE (6, 1005)
         INFO   = 0
         COL    = 0
         HEAD   = 1
         THETA  = ONE
         IUPDAT = 0
         UPDATD = .FALSE.
         CALL TIMER(CPU2) 
         SBTIME = SBTIME + CPU2 - CPU1 
         GOTO 222
      ENDIF
 
      CALL TIMER(CPU2) 
      SBTIME = SBTIME + CPU2 - CPU1 
 555  CONTINUE
 
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C     LINE SEARCH AND OPTIMALITY TESTS.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 
C     GENERATE THE SEARCH DIRECTION D:=Z-X.

      DO 40 I = 1, N
         D(I) = Z(I) - X(I)
  40  CONTINUE
      CALL TIMER(CPU1) 
 666  CONTINUE
      CALL LNSRLB(N,L,U,NBD,X,F,FOLD,GD,GDOLD,G,D,R,T,Z,STP,DNORM,
     +            DTD,XSTEP,STPMX,ITER,IFUN,IBACK,NFGV,INFO,TASK,
     +            BOXED,CNSTND,CSAVE,ISAVE(22),DSAVE(17))
      IF (INFO .NE. 0 .OR. IBACK .GE. 20) THEN
C          RESTORE THE PREVIOUS ITERATE.
         CALL DCOPY(N,T,1,X,1)
         CALL DCOPY(N,R,1,G,1)
         F = FOLD
         IF (COL .EQ. 0) THEN
C             ABNORMAL TERMINATION.
            IF (INFO .EQ. 0) THEN
               INFO = -9
C                RESTORE THE ACTUAL NUMBER OF F AND G EVALUATIONS ETC.
               NFGV = NFGV - 1
               IFUN = IFUN - 1
               IBACK = IBACK - 1
            ENDIF
            TASK = 'ABNORMAL_TERMINATION_IN_LNSRCH'
            ITER = ITER + 1
            GOTO 999
         ELSE
C             REFRESH THE LBFGS MEMORY AND RESTART THE ITERATION.
            IF(IPRINT .GE. 1) WRITE (6, 1008)
            IF (INFO .EQ. 0) NFGV = NFGV - 1
            INFO   = 0
            COL    = 0
            HEAD   = 1
            THETA  = ONE
            IUPDAT = 0
            UPDATD = .FALSE.
            TASK   = 'RESTART_FROM_LNSRCH'
            CALL TIMER(CPU2)
            LNSCHT = LNSCHT + CPU2 - CPU1
            GOTO 222
         ENDIF
      ELSE IF (TASK(1:5) .EQ. 'FG_LN') THEN
C          RETURN TO THE DRIVER FOR CALCULATING F AND G; REENTER AT 666.
         GOTO 1000
      ELSE 
C          CALCULATE AND PRINT OUT THE QUANTITIES RELATED TO THE NEW X.
         CALL TIMER(CPU2) 
         LNSCHT = LNSCHT + CPU2 - CPU1
         ITER = ITER + 1
 
C        COMPUTE THE INFINITY NORM OF THE PROJECTED (-)GRADIENT.
 
         CALL PROJGR(N,L,U,NBD,X,G,SBGNRM)
 
C        PRINT ITERATION INFORMATION.

         CALL PRN2LB(N,X,F,G,IPRINT,ITFILE,ITER,NFGV,NACT,
     +               SBGNRM,NSEG,WORD,IWORD,IBACK,STP,XSTEP)
         GOTO 1000
      ENDIF
 777  CONTINUE

C     TEST FOR TERMINATION.

      IF (SBGNRM .LE. PGTOL) THEN
C                                TERMINATE THE ALGORITHM.
         TASK = 'CONVERGENCE: NORM_OF_PROJECTED_GRADIENT_<=_PGTOL'
         GOTO 999
      ENDIF 

      DDUM = MAX(ABS(FOLD), ABS(F), ONE)
      IF ((FOLD - F) .LE. TOL*DDUM) THEN
C                                        TERMINATE THE ALGORITHM.
         TASK = 'CONVERGENCE: REL_REDUCTION_OF_F_<=_FACTR*EPSMCH'
         IF (IBACK .GE. 10) INFO = -5
C           I.E., TO ISSUE A WARNING IF IBACK>10 IN THE LINE SEARCH.
         GOTO 999
      ENDIF 

C     COMPUTE D=NEWX-OLDX, R=NEWG-OLDG, RR=Y'Y AND DR=Y'S.
 
      DO 42 I = 1, N
         R(I) = G(I) - R(I)
  42  CONTINUE
      RR = DDOT(N,R,1,R,1)
      IF (STP .EQ. ONE) THEN  
         DR = GD - GDOLD
         DDUM = -GDOLD
      ELSE
         DR = (GD - GDOLD)*STP
         CALL DSCAL(N,STP,D,1)
         DDUM = -GDOLD*STP
      ENDIF
 
      IF (DR .LE. EPSMCH*DDUM) THEN
C                            SKIP THE L-BFGS UPDATE.
         NSKIP = NSKIP + 1
         UPDATD = .FALSE.
         IF (IPRINT .GE. 1) WRITE (6,1004) DR, DDUM
         GOTO 888
      ENDIF 
 
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C     UPDATE THE L-BFGS MATRIX.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 
      UPDATD = .TRUE.
      IUPDAT = IUPDAT + 1

C     UPDATE MATRICES WS AND WY AND FORM THE MIDDLE MATRIX IN B.

      CALL MATUPD(N,M,WS,WY,SY,SS,D,R,ITAIL,
     +            IUPDAT,COL,HEAD,THETA,RR,DR,STP,DTD)

C     FORM THE UPPER HALF OF THE PDS T = THETA*SS + L*D^(-1)*L';
C        STORE T IN THE UPPER TRIANGULAR OF THE ARRAY WT;
C        CHOLESKY FACTORIZE T TO J*J' WITH
C           J' STORED IN THE UPPER TRIANGULAR OF WT.

      CALL FORMT(M,WT,SY,SS,COL,THETA,INFO)
 
      IF (INFO .NE. 0) THEN 
C          NONPOSITIVE DEFINITENESS IN CHOLESKY FACTORIZATION;
C          REFRESH THE LBFGS MEMORY AND RESTART THE ITERATION.
         IF(IPRINT .GE. 1) WRITE (6, 1007)
         INFO = 0
         COL = 0
         HEAD = 1
         THETA = ONE
         IUPDAT = 0
         UPDATD = .FALSE.
         GOTO 222
      ENDIF

C     NOW THE INVERSE OF THE MIDDLE MATRIX IN B IS

C       [  D^(1/2)      O ] [ -D^(1/2)  D^(-1/2)*L' ]
C       [ -L*D^(-1/2)   J ] [  0        J'          ]

 888  CONTINUE
 
C -------------------- THE END OF THE LOOP -----------------------------
 
      GOTO 222
 999  CONTINUE
      CALL TIMER(TIME2)
      TIME = TIME2 - TIME1
      CALL PRN3LB(N,X,F,TASK,IPRINT,INFO,ITFILE,
     +            ITER,NFGV,NINTOL,NSKIP,NACT,SBGNRM,
     +            TIME,NSEG,WORD,IBACK,STP,XSTEP,K,
     +            CACHYT,SBTIME,LNSCHT)
 1000 CONTINUE

C     SAVE LOCAL VARIABLES.

      LSAVE(1)  = PRJCTD
      LSAVE(2)  = CNSTND
      LSAVE(3)  = BOXED
      LSAVE(4)  = UPDATD

      ISAVE(1)  = NINTOL 
      ISAVE(3)  = ITFILE 
      ISAVE(4)  = IBACK 
      ISAVE(5)  = NSKIP 
      ISAVE(6)  = HEAD 
      ISAVE(7)  = COL 
      ISAVE(8)  = ITAIL 
      ISAVE(9)  = ITER 
      ISAVE(10) = IUPDAT 
      ISAVE(12) = NSEG
      ISAVE(13) = NFGV 
      ISAVE(14) = INFO 
      ISAVE(15) = IFUN 
      ISAVE(16) = IWORD 
      ISAVE(17) = NFREE 
      ISAVE(18) = NACT 
      ISAVE(19) = ILEAVE 
      ISAVE(20) = NENTER 

      DSAVE(1)  = THETA 
      DSAVE(2)  = FOLD 
      DSAVE(3)  = TOL 
      DSAVE(4)  = DNORM 
      DSAVE(5)  = EPSMCH 
      DSAVE(6)  = CPU1 
      DSAVE(7)  = CACHYT 
      DSAVE(8)  = SBTIME 
      DSAVE(9)  = LNSCHT 
      DSAVE(10) = TIME1 
      DSAVE(11) = GD 
      DSAVE(12) = STPMX 
      DSAVE(13) = SBGNRM
      DSAVE(14) = STP
      DSAVE(15) = GDOLD
      DSAVE(16) = DTD  

 1001 FORMAT (//,'ITERATION ',I5)
 1002 FORMAT
     +  (/,'AT ITERATE',I5,4X,'F= ',1P,D12.5,4X,'|PROJ G|= ',1P,D12.5)
 1003 FORMAT (2(1X,I4),5X,'-',5X,'-',3X,'-',5X,'-',5X,'-',8X,'-',3X,
     +        1P,2(1X,D10.3))
 1004 FORMAT ('  YS=',1P,E10.3,'  -GS=',1P,E10.3,' BFGS UPDATE SKIPPED')
 1005 FORMAT (/, 
     +' SINGULAR TRIANGULAR SYSTEM DETECTED;',/,
     +'   REFRESH THE LBFGS MEMORY AND RESTART THE ITERATION.')
 1006 FORMAT (/, 
     +' NONPOSITIVE DEFINITENESS IN CHOLESKY FACTORIZATION IN FORMK;',/,
     +'   REFRESH THE LBFGS MEMORY AND RESTART THE ITERATION.')
 1007 FORMAT (/, 
     +' NONPOSITIVE DEFINITENESS IN CHOLESKY FACTORIZATION IN FORMT;',/,
     +'   REFRESH THE LBFGS MEMORY AND RESTART THE ITERATION.')
 1008 FORMAT (/, 
     +' BAD DIRECTION IN THE LINE SEARCH;',/,
     +'   REFRESH THE LBFGS MEMORY AND RESTART THE ITERATION.')

      RETURN   

      END
 
C======================= THE END OF MAINLB =============================

      SUBROUTINE ACTIVE(N, L, U, NBD, X, IWHERE, IPRINT,
     +                  PRJCTD, CNSTND, BOXED)

      LOGICAL          PRJCTD, CNSTND, BOXED
      INTEGER          N, IPRINT, NBD(N), IWHERE(N)
      DOUBLE PRECISION X(N), L(N), U(N)

C     ************
C
C     SUBROUTINE ACTIVE
C
C     THIS SUBROUTINE INITIALIZES IWHERE AND PROJECTS THE INITIAL X TO
C       THE FEASIBLE SET IF NECESSARY.
C
C     IWHERE IS AN INTEGER ARRAY OF DIMENSION N.
C       ON ENTRY IWHERE IS UNSPECIFIED.
C       ON EXIT IWHERE(I)=-1  IF X(I) HAS NO BOUNDS
C                         3   IF L(I)=U(I)
C                         0   OTHERWISE.
C       IN CAUCHY, IWHERE IS GIVEN FINER GRADATIONS.
C
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     ************

      INTEGER          NBDD,I
      DOUBLE PRECISION ZERO
      PARAMETER        (ZERO=0.0D0)

C     INITIALIZE NBDD, PRJCTD, CNSTND AND BOXED.

      NBDD = 0
      PRJCTD = .FALSE.
      CNSTND = .FALSE.
      BOXED = .TRUE.

C     PROJECT THE INITIAL X TO THE EASIBLE SET IF NECESSARY.

      DO 10 I = 1, N
         IF (NBD(I) .GT. 0) THEN
            IF (NBD(I) .LE. 2 .AND. X(I) .LE. L(I)) THEN
               IF (X(I) .LT. L(I)) THEN
                  PRJCTD = .TRUE.
                  X(I) = L(I)
               ENDIF
               NBDD = NBDD + 1
            ELSE IF (NBD(I) .GE. 2 .AND. X(I) .GE. U(I)) THEN
               IF (X(I) .GT. U(I)) THEN
                  PRJCTD = .TRUE.
                  X(I) = U(I)
               ENDIF
               NBDD = NBDD + 1
            ENDIF
         ENDIF
  10  CONTINUE

C     INITIALIZE IWHERE AND ASSIGN VALUES TO CNSTND AND BOXED.

      DO 20 I = 1, N
         IF (NBD(I) .NE. 2) BOXED = .FALSE.
         IF (NBD(I) .EQ. 0) THEN
C                                THIS VARIABLE IS ALWAYS FREE
            IWHERE(I) = -1

C           OTHERWISE SET X(I)=MID(X(I), U(I), L(I)).
         ELSE
            CNSTND = .TRUE.
            IF (NBD(I) .EQ. 2 .AND. U(I) - L(I) .LE. ZERO) THEN
C                   THIS VARIABLE IS ALWAYS FIXED
               IWHERE(I) = 3
            ELSE 
               IWHERE(I) = 0
            ENDIF
         ENDIF
  20  CONTINUE

      IF (IPRINT .GE. 0) THEN
         IF (PRJCTD) WRITE (6,*)
     +   'THE INITIAL X IS INFEASIBLE.  RESTART WITH ITS PROJECTION.'
         IF (.NOT. CNSTND)
     +      WRITE (6,*) 'THIS PROBLEM IS UNCONSTRAINED.'
      ENDIF

      IF (IPRINT .GT. 0) WRITE (6,1001) NBDD

 1001 FORMAT (/,'AT X0 ',I9,' VARIABLES ARE EXACTLY AT THE BOUNDS') 

      RETURN

      END

C======================= THE END OF ACTIVE =============================
 
      SUBROUTINE BMV(M, SY, WT, COL, V, P, INFO)

      INTEGER M, COL, INFO
      DOUBLE PRECISION SY(M, M), WT(M, M), V(2*COL), P(2*COL)

C     ************
C
C     SUBROUTINE BMV
C
C     THIS SUBROUTINE COMPUTES THE PRODUCT OF THE 2M X 2M MIDDLE MATRIX 
C       IN THE COMPACT L-BFGS FORMULA OF B AND A 2M VECTOR V;  
C       IT RETURNS THE PRODUCT IN P.
C       
C     M IS AN INTEGER VARIABLE.
C       ON ENTRY M IS THE MAXIMUM NUMBER OF VARIABLE METRIC CORRECTIONS
C         USED TO DEFINE THE LIMITED MEMORY MATRIX.
C       ON EXIT M IS UNCHANGED.
C
C     SY IS A DOUBLE PRECISION ARRAY OF DIMENSION M X M.
C       ON ENTRY SY SPECIFIES THE MATRIX S'Y.
C       ON EXIT SY IS UNCHANGED.
C
C     WT IS A DOUBLE PRECISION ARRAY OF DIMENSION M X M.
C       ON ENTRY WT SPECIFIES THE UPPER TRIANGULAR MATRIX J' WHICH IS 
C         THE CHOLESKY FACTOR OF (THETAS'S+LD^(-1)L').
C       ON EXIT WT IS UNCHANGED.
C
C     COL IS AN INTEGER VARIABLE.
C       ON ENTRY COL SPECIFIES THE NUMBER OF S-VECTORS (OR Y-VECTORS)
C         STORED IN THE COMPACT L-BFGS FORMULA.
C       ON EXIT COL IS UNCHANGED.
C
C     V IS A DOUBLE PRECISION ARRAY OF DIMENSION 2COL.
C       ON ENTRY V SPECIFIES VECTOR V.
C       ON EXIT V IS UNCHANGED.
C
C     P IS A DOUBLE PRECISION ARRAY OF DIMENSION 2COL.
C       ON ENTRY P IS UNSPECIFIED.
C       ON EXIT P IS THE PRODUCT MV.
C
C     INFO IS AN INTEGER VARIABLE.
C       ON ENTRY INFO IS UNSPECIFIED.
C       ON EXIT INFO = 0       FOR NORMAL RETURN,
C                    = NONZERO FOR ABNORMAL RETURN WHEN THE SYSTEM
C                                TO BE SOLVED BY DTRSL IS SINGULAR.
C
C     SUBPROGRAMS CALLED:
C
C       LINPACK ... DTRSL.
C
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     ************
 
      INTEGER          I,K,I2
      DOUBLE PRECISION SUM
 
      IF (COL .EQ. 0) RETURN
 
C     PART I: SOLVE [  D^(1/2)      O ] [ P1 ] = [ V1 ]
C                   [ -L*D^(-1/2)   J ] [ P2 ]   [ V2 ].

C       SOLVE JP2=V2+LD^(-1)V1.
      P(COL + 1) = V(COL + 1)
      DO 20 I = 2, COL
         I2 = COL + I
         SUM = 0.0D0
         DO 10 K = 1, I - 1
            SUM = SUM + SY(I,K)*V(K)/SY(K,K)
  10     CONTINUE
         P(I2) = V(I2) + SUM
  20  CONTINUE  
C     SOLVE THE TRIANGULAR SYSTEM
      CALL DTRSL(WT,M,COL,P(COL+1),11,INFO)
      IF (INFO .NE. 0) RETURN
 
C       SOLVE D^(1/2)P1=V1.
      DO 30 I = 1, COL
         P(I) = V(I)/SQRT(SY(I,I))
  30  CONTINUE 
 
C     PART II: SOLVE [ -D^(1/2)   D^(-1/2)*L'  ] [ P1 ] = [ P1 ]
C                    [  0         J'           ] [ P2 ]   [ P2 ]. 
 
C       SOLVE J^TP2=P2. 
      CALL DTRSL(WT,M,COL,P(COL+1),01,INFO)
      IF (INFO .NE. 0) RETURN
 
C       COMPUTE P1=-D^(-1/2)(P1-D^(-1/2)L'P2)
C                 =-D^(-1/2)P1+D^(-1)L'P2.  
      DO 40 I = 1, COL
         P(I) = -P(I)/SQRT(SY(I,I))
  40  CONTINUE
      DO 60 I = 1, COL
         SUM = 0.D0
         DO 50 K = I + 1, COL
            SUM = SUM + SY(K,I)*P(COL+K)/SY(I,I)
  50     CONTINUE
         P(I) = P(I) + SUM
  60  CONTINUE

      RETURN

      END

C======================== THE END OF BMV ===============================

      SUBROUTINE CAUCHY(N, X, L, U, NBD, G, IORDER, IWHERE, T, D, XCP, 
     +                  M, WY, WS, SY, WT, THETA, COL, HEAD, P, C, WBP, 
     +                  V, NSEG, IPRINT, SBGNRM, INFO, EPSMCH)
      IMPLICIT NONE
      INTEGER          N, M, HEAD, COL, NSEG, IPRINT, INFO, 
     +                 NBD(N), IORDER(N), IWHERE(N)
      DOUBLE PRECISION THETA, EPSMCH,
     +                 X(N), L(N), U(N), G(N), T(N), D(N), XCP(N),
     +                 WY(N, COL), WS(N, COL), SY(M, M),
     +                 WT(M, M), P(2*M), C(2*M), WBP(2*M), V(2*M)

C     ************
C
C     SUBROUTINE CAUCHY
C
C     FOR GIVEN X, L, U, G (WITH SBGNRM > 0), AND A LIMITED MEMORY
C       BFGS MATRIX B DEFINED IN TERMS OF MATRICES WY, WS, WT, AND
C       SCALARS HEAD, COL, AND THETA, THIS SUBROUTINE COMPUTES THE
C       GENERALIZED CAUCHY POINT (GCP), DEFINED AS THE FIRST LOCAL
C       MINIMIZER OF THE QUADRATIC
C
C                  Q(X + S) = G'S + 1/2 S'BS
C
C       ALONG THE PROJECTED GRADIENT DIRECTION P(X-TG,L,U).
C       THE ROUTINE RETURNS THE GCP IN XCP. 
C       
C     N IS AN INTEGER VARIABLE.
C       ON ENTRY N IS THE DIMENSION OF THE PROBLEM.
C       ON EXIT N IS UNCHANGED.
C
C     X IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON ENTRY X IS THE STARTING POINT FOR THE GCP COMPUTATION.
C       ON EXIT X IS UNCHANGED.
C
C     L IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON ENTRY L IS THE LOWER BOUND OF X.
C       ON EXIT L IS UNCHANGED.
C
C     U IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON ENTRY U IS THE UPPER BOUND OF X.
C       ON EXIT U IS UNCHANGED.
C
C     NBD IS AN INTEGER ARRAY OF DIMENSION N.
C       ON ENTRY NBD REPRESENTS THE TYPE OF BOUNDS IMPOSED ON THE
C         VARIABLES, AND MUST BE SPECIFIED AS FOLLOWS:
C         NBD(I)=0 IF X(I) IS UNBOUNDED,
C                1 IF X(I) HAS ONLY A LOWER BOUND,
C                2 IF X(I) HAS BOTH LOWER AND UPPER BOUNDS, AND
C                3 IF X(I) HAS ONLY AN UPPER BOUND. 
C       ON EXIT NBD IS UNCHANGED.
C
C     G IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON ENTRY G IS THE GRADIENT OF F(X).  G MUST BE A NONZERO VECTOR.
C       ON EXIT G IS UNCHANGED.
C
C     IORDER IS AN INTEGER WORKING ARRAY OF DIMENSION N.
C       IORDER WILL BE USED TO STORE THE BREAKPOINTS IN THE PIECEWISE
C       LINEAR PATH AND FREE VARIABLES ENCOUNTERED. ON EXIT,
C         IORDER(1),...,IORDER(NLEFT) ARE INDICES OF BREAKPOINTS
C                                WHICH HAVE NOT BEEN ENCOUNTERED; 
C         IORDER(NLEFT+1),...,IORDER(NBREAK) ARE INDICES OF
C                                     ENCOUNTERED BREAKPOINTS; AND
C         IORDER(NFREE),...,IORDER(N) ARE INDICES OF VARIABLES WHICH
C                 HAVE NO BOUND CONSTRAITS ALONG THE SEARCH DIRECTION.
C
C     IWHERE IS AN INTEGER ARRAY OF DIMENSION N.
C       ON ENTRY IWHERE INDICATES ONLY THE PERMANENTLY FIXED (IWHERE=3)
C       OR FREE (IWHERE= -1) COMPONENTS OF X.
C       ON EXIT IWHERE RECORDS THE STATUS OF THE CURRENT X VARIABLES.
C       IWHERE(I)=-3  IF X(I) IS FREE AND HAS BOUNDS, BUT IS NOT MOVED
C                 0   IF X(I) IS FREE AND HAS BOUNDS, AND IS MOVED
C                 1   IF X(I) IS FIXED AT L(I), AND L(I) .NE. U(I)
C                 2   IF X(I) IS FIXED AT U(I), AND U(I) .NE. L(I)
C                 3   IF X(I) IS ALWAYS FIXED, I.E.,  U(I)=X(I)=L(I)
C                 -1  IF X(I) IS ALWAYS FREE, I.E., IT HAS NO BOUNDS.
C
C     T IS A DOUBLE PRECISION WORKING ARRAY OF DIMENSION N. 
C       T WILL BE USED TO STORE THE BREAK POINTS.
C
C     D IS A DOUBLE PRECISION ARRAY OF DIMENSION N USED TO STORE
C       THE CAUCHY DIRECTION P(X-TG)-X.
C
C     XCP IS A DOUBLE PRECISION ARRAY OF DIMENSION N USED TO RETURN THE
C       GCP ON EXIT.
C
C     M IS AN INTEGER VARIABLE.
C       ON ENTRY M IS THE MAXIMUM NUMBER OF VARIABLE METRIC CORRECTIONS 
C         USED TO DEFINE THE LIMITED MEMORY MATRIX.
C       ON EXIT M IS UNCHANGED.
C
C     WS, WY, SY, AND WT ARE DOUBLE PRECISION ARRAYS.
C       ON ENTRY THEY STORE INFORMATION THAT DEFINES THE
C                             LIMITED MEMORY BFGS MATRIX:
C         WS(N,M) STORES S, A SET OF S-VECTORS;
C         WY(N,M) STORES Y, A SET OF Y-VECTORS;
C         SY(M,M) STORES S'Y;
C         WT(M,M) STORES THE
C                 CHOLESKY FACTORIZATION OF (THETA*S'S+LD^(-1)L').
C       ON EXIT THESE ARRAYS ARE UNCHANGED.
C
C     THETA IS A DOUBLE PRECISION VARIABLE.
C       ON ENTRY THETA IS THE SCALING FACTOR SPECIFYING B_0 = THETA I.
C       ON EXIT THETA IS UNCHANGED.
C
C     COL IS AN INTEGER VARIABLE.
C       ON ENTRY COL IS THE ACTUAL NUMBER OF VARIABLE METRIC
C         CORRECTIONS STORED SO FAR.
C       ON EXIT COL IS UNCHANGED.
C
C     HEAD IS AN INTEGER VARIABLE.
C       ON ENTRY HEAD IS THE LOCATION OF THE FIRST S-VECTOR (OR Y-VECTOR)
C         IN S (OR Y).
C       ON EXIT COL IS UNCHANGED.
C
C     P IS A DOUBLE PRECISION WORKING ARRAY OF DIMENSION 2M.
C       P WILL BE USED TO STORE THE VECTOR P = W^(T)D.
C
C     C IS A DOUBLE PRECISION WORKING ARRAY OF DIMENSION 2M.
C       C WILL BE USED TO STORE THE VECTOR C = W^(T)(XCP-X).
C
C     WBP IS A DOUBLE PRECISION WORKING ARRAY OF DIMENSION 2M.
C       WBP WILL BE USED TO STORE THE ROW OF W CORRESPONDING
C         TO A BREAKPOINT.
C
C     V IS A DOUBLE PRECISION WORKING ARRAY OF DIMENSION 2M.
C
C     NSEG IS AN INTEGER VARIABLE.
C       ON EXIT NSEG RECORDS THE NUMBER OF QUADRATIC SEGMENTS EXPLORED
C         IN SEARCHING FOR THE GCP.
C
C     SG AND YG ARE DOUBLE PRECISION ARRAYS OF DIMENSION M.
C       ON ENTRY SG  AND YG STORE S'G AND Y'G CORRESPONDINGLY.
C       ON EXIT THEY ARE UNCHANGED. 
C 
C     IPRINT IS AN INTEGER VARIABLE THAT MUST BE SET BY THE USER.
C       IT CONTROLS THE FREQUENCY AND TYPE OF OUTPUT GENERATED:
C        IPRINT<0    NO OUTPUT IS GENERATED;
C        IPRINT=0    PRINT ONLY ONE LINE AT THE LAST ITERATION;
C        0<IPRINT<99 PRINT ALSO F AND |PROJ G| EVERY IPRINT ITERATIONS;
C        IPRINT=99   PRINT DETAILS OF EVERY ITERATION EXCEPT N-VECTORS;
C        IPRINT=100  PRINT ALSO THE CHANGES OF ACTIVE SET AND FINAL X;
C        IPRINT>100  PRINT DETAILS OF EVERY ITERATION INCLUDING X AND G;
C       WHEN IPRINT > 0, THE FILE ITERATE.DAT WILL BE CREATED TO
C                        SUMMARIZE THE ITERATION.
C
C     SBGNRM IS A DOUBLE PRECISION VARIABLE.
C       ON ENTRY SBGNRM IS THE NORM OF THE PROJECTED GRADIENT AT X.
C       ON EXIT SBGNRM IS UNCHANGED.
C
C     INFO IS AN INTEGER VARIABLE.
C       ON ENTRY INFO IS 0.
C       ON EXIT INFO = 0       FOR NORMAL RETURN,
C                    = NONZERO FOR ABNORMAL RETURN WHEN THE THE SYSTEM
C                              USED IN ROUTINE BMV IS SINGULAR.
C
C     SUBPROGRAMS CALLED:
C 
C       L-BFGS-B LIBRARY ... HPSOLB, BMV.
C
C       LINPACK ... DSCAL DCOPY, DAXPY.
C
C
C     REFERENCES:
C
C       [1] R. H. BYRD, P. LU, J. NOCEDAL AND C. ZHU, ``A LIMITED
C       MEMORY ALGORITHM FOR BOUND CONSTRAINED OPTIMIZATION'',
C       SIAM J. SCIENTIFIC COMPUTING 16 (1995), NO. 5, PP. 1190--1208.
C
C       [2] C. ZHU, R.H. BYRD, P. LU, J. NOCEDAL, ``L-BFGS-B: FORTRAN
C       SUBROUTINES FOR LARGE SCALE BOUND CONSTRAINED OPTIMIZATION''
C       TECH. REPORT, NAM-11, EECS DEPARTMENT, NORTHWESTERN UNIVERSITY,
C       1994.
C
C       (POSTSCRIPT FILES OF THESE PAPERS ARE AVAILABLE VIA ANONYMOUS
C        FTP TO EECS.NWU.EDU IN THE DIRECTORY PUB/LBFGS/LBFGS_BCM.)
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     ************

      LOGICAL          XLOWER,XUPPER,BNDED
      INTEGER          I,J,COL2,NFREE,NBREAK,POINTR,
     +                 IBP,NLEFT,IBKMIN,ITER
      DOUBLE PRECISION F1,F2,DT,DTM,TSUM,DIBP,ZIBP,DIBP2,BKMIN,
     +                 TU,TL,WMC,WMP,WMW,DDOT,TJ,TJ0,NEGGI,SBGNRM,
     +                 F2_ORG
      DOUBLE PRECISION ONE,ZERO
      PARAMETER        (ONE=1.0D0,ZERO=0.0D0)
 
C     CHECK THE STATUS OF THE VARIABLES, RESET IWHERE(I) IF NECESSARY;
C       COMPUTE THE CAUCHY DIRECTION D AND THE BREAKPOINTS T; INITIALIZE
C       THE DERIVATIVE F1 AND THE VECTOR P = W'D (FOR THETA = 1).
 
      IF (SBGNRM .LE. ZERO) THEN
         IF (IPRINT .GE. 0) WRITE (6,*) 'SUBGNORM = 0.  GCP = X.'
         CALL DCOPY(N,X,1,XCP,1)
         RETURN
      ENDIF 
      BNDED = .TRUE.
      NFREE = N + 1
      NBREAK = 0
      IBKMIN = 0
      BKMIN = ZERO
      COL2 = 2*COL
      F1 = ZERO
      IF (IPRINT .GE. 99) WRITE (6,3010)

C     WE SET P TO ZERO AND BUILD IT UP AS WE DETERMINE D.

      DO 20 I = 1, COL2
         P(I) = ZERO
  20  CONTINUE 

C     IN THE FOLLOWING LOOP WE DETERMINE FOR EACH VARIABLE ITS BOUND
C        STATUS AND ITS BREAKPOINT, AND UPDATE P ACCORDINGLY.
C        SMALLEST BREAKPOINT IS IDENTIFIED.

      DO 50 I = 1, N 
         NEGGI = -G(I)      
         IF (IWHERE(I) .NE. 3 .AND. IWHERE(I) .NE. -1) THEN
C             IF X(I) IS NOT A CONSTANT AND HAS BOUNDS,
C             COMPUTE THE DIFFERENCE BETWEEN X(I) AND ITS BOUNDS.
            IF (NBD(I) .LE. 2) TL = X(I) - L(I)
            IF (NBD(I) .GE. 2) TU = U(I) - X(I)

C           IF A VARIABLE IS CLOSE ENOUGH TO A BOUND
C             WE TREAT IT AS AT BOUND.
            XLOWER = NBD(I) .LE. 2 .AND. TL .LE. ZERO
            XUPPER = NBD(I) .GE. 2 .AND. TU .LE. ZERO

C              RESET IWHERE(I).
            IWHERE(I) = 0
            IF (XLOWER) THEN
               IF (NEGGI .LE. ZERO) IWHERE(I) = 1
            ELSE IF (XUPPER) THEN
               IF (NEGGI .GE. ZERO) IWHERE(I) = 2
            ELSE
               IF (ABS(NEGGI) .LE. ZERO) IWHERE(I) = -3
            ENDIF
         ENDIF 
         POINTR = HEAD
         IF (IWHERE(I) .NE. 0 .AND. IWHERE(I) .NE. -1) THEN
            D(I) = ZERO
         ELSE
            D(I) = NEGGI
            F1 = F1 - NEGGI*NEGGI
C             CALCULATE P := P - W'E_I* (G_I).
            DO 40 J = 1, COL
               P(J) = P(J) +  WY(I,POINTR)* NEGGI
               P(COL + J) = P(COL + J) + WS(I,POINTR)*NEGGI
               POINTR = MOD(POINTR,M) + 1
  40        CONTINUE 
            IF (NBD(I) .LE. 2 .AND. NBD(I) .NE. 0
     +                        .AND. NEGGI .LT. ZERO) THEN
C                                 X(I) + D(I) IS BOUNDED; COMPUTE T(I).
               NBREAK = NBREAK + 1
               IORDER(NBREAK) = I
               T(NBREAK) = TL/(-NEGGI)
               IF (NBREAK .EQ. 1 .OR. T(NBREAK) .LT. BKMIN) THEN
                  BKMIN = T(NBREAK)
                  IBKMIN = NBREAK
               ENDIF
            ELSE IF (NBD(I) .GE. 2 .AND. NEGGI .GT. ZERO) THEN
C                                 X(I) + D(I) IS BOUNDED; COMPUTE T(I).
               NBREAK = NBREAK + 1
               IORDER(NBREAK) = I
               T(NBREAK) = TU/NEGGI
               IF (NBREAK .EQ. 1 .OR. T(NBREAK) .LT. BKMIN) THEN
                  BKMIN = T(NBREAK)
                  IBKMIN = NBREAK
               ENDIF
            ELSE
C                X(I) + D(I) IS NOT BOUNDED.
               NFREE = NFREE - 1
               IORDER(NFREE) = I
               IF (ABS(NEGGI) .GT. ZERO) BNDED = .FALSE.
            ENDIF
         ENDIF
  50  CONTINUE 
 
C     THE INDICES OF THE NONZERO COMPONENTS OF D ARE NOW STORED
C       IN IORDER(1),...,IORDER(NBREAK) AND IORDER(NFREE),...,IORDER(N).
C       THE SMALLEST OF THE NBREAK BREAKPOINTS IS IN T(IBKMIN)=BKMIN.
 
      IF (THETA .NE. ONE) THEN
C                   COMPLETE THE INITIALIZATION OF P FOR THETA NOT= ONE.
         CALL DSCAL(COL,THETA,P(COL+1),1)
      ENDIF
 
C     INITIALIZE GCP XCP = X.

      CALL DCOPY(N,X,1,XCP,1)

      IF (NBREAK .EQ. 0 .AND. NFREE .EQ. N + 1) THEN
C                  IS A ZERO VECTOR, RETURN WITH THE INITIAL XCP AS GCP.
         IF (IPRINT .GT. 100) WRITE (6,1010) (XCP(I), I = 1, N)
         RETURN
      ENDIF    
 
C     INITIALIZE C = W'(XCP - X) = 0.
  
      DO 60 J = 1, COL2
         C(J) = ZERO
  60  CONTINUE 
 
C     INITIALIZE DERIVATIVE F2.
 
      F2 =  -THETA*F1 
      F2_ORG  =  F2
      IF (COL .GT. 0) THEN
         CALL BMV(M,SY,WT,COL,P,V,INFO)
         IF (INFO .NE. 0) RETURN
         F2 = F2 - DDOT(COL2,V,1,P,1)
      ENDIF
      DTM = -F1/F2
      TSUM = ZERO
      NSEG = 1
      IF (IPRINT .GE. 99) 
     +   WRITE (6,*) 'THERE ARE ',NBREAK,'  BREAKPOINTS '
 
C     IF THERE ARE NO BREAKPOINTS, LOCATE THE GCP AND RETURN. 
 
      IF (NBREAK .EQ. 0) GOTO 888
             
      NLEFT = NBREAK
      ITER = 1
 
 
      TJ = ZERO
 
C------------------- THE BEGINNING OF THE LOOP -------------------------
 
 777  CONTINUE
 
C     FIND THE NEXT SMALLEST BREAKPOINT;
C       COMPUTE DT = T(NLEFT) - T(NLEFT + 1).
 
      TJ0 = TJ
      IF (ITER .EQ. 1) THEN
C         SINCE WE ALREADY HAVE THE SMALLEST BREAKPOINT WE NEED NOT DO
C         HEAPSORT YET. OFTEN ONLY ONE BREAKPOINT IS USED AND THE
C         COST OF HEAPSORT IS AVOIDED.
         TJ = BKMIN
         IBP = IORDER(IBKMIN)
      ELSE
         IF (ITER .EQ. 2) THEN
C             REPLACE THE ALREADY USED SMALLEST BREAKPOINT WITH THE
C             BREAKPOINT NUMBERED NBREAK > NLAST, BEFORE HEAPSORT CALL.
            IF (IBKMIN .NE. NBREAK) THEN
               T(IBKMIN) = T(NBREAK)
               IORDER(IBKMIN) = IORDER(NBREAK)
            ENDIF 
C        UPDATE HEAP STRUCTURE OF BREAKPOINTS
C           (IF ITER=2, INITIALIZE HEAP).
         ENDIF
         CALL HPSOLB(NLEFT,T,IORDER,ITER-2)
         TJ = T(NLEFT)
         IBP = IORDER(NLEFT)  
      ENDIF 
         
      DT = TJ - TJ0
 
      IF (DT .NE. ZERO .AND. IPRINT .GE. 100) THEN
         WRITE (6,4011) NSEG,F1,F2
         WRITE (6,5010) DT
         WRITE (6,6010) DTM
      ENDIF          
 
C     IF A MINIMIZER IS WITHIN THIS INTERVAL, LOCATE THE GCP AND RETURN. 
 
      IF (DTM .LT. DT) GOTO 888
 
C     OTHERWISE FIX ONE VARIABLE AND
C       RESET THE CORRESPONDING COMPONENT OF D TO ZERO.
    
      TSUM = TSUM + DT
      NLEFT = NLEFT - 1
      ITER = ITER + 1
      DIBP = D(IBP)
      D(IBP) = ZERO
      IF (DIBP .GT. ZERO) THEN
         ZIBP = U(IBP) - X(IBP)
         XCP(IBP) = U(IBP)
         IWHERE(IBP) = 2
      ELSE
         ZIBP = L(IBP) - X(IBP)
         XCP(IBP) = L(IBP)
         IWHERE(IBP) = 1
      ENDIF
      IF (IPRINT .GE. 100) WRITE (6,*) 'VARIABLE  ',IBP,'  IS FIXED.'
      IF (NLEFT .EQ. 0 .AND. NBREAK .EQ. N) THEN
C                                             ALL N VARIABLES ARE FIXED,
C                                                RETURN WITH XCP AS GCP.
         DTM = DT
         GOTO 999
      ENDIF
 
C     UPDATE THE DERIVATIVE INFORMATION.
 
      NSEG = NSEG + 1
      DIBP2 = DIBP**2
 
C     UPDATE F1 AND F2.
 
C        TEMPORARILY SET F1 AND F2 FOR COL=0.
      F1 = F1 + DT*F2 + DIBP2 - THETA*DIBP*ZIBP
      F2 = F2 - THETA*DIBP2

      IF (COL .GT. 0) THEN
C                          UPDATE C = C + DT*P.
         CALL DAXPY(COL2,DT,P,1,C,1)
 
C           CHOOSE WBP,
C           THE ROW OF W CORRESPONDING TO THE BREAKPOINT ENCOUNTERED.
         POINTR = HEAD
         DO 70 J = 1,COL
            WBP(J) = WY(IBP,POINTR)
            WBP(COL + J) = THETA*WS(IBP,POINTR)
            POINTR = MOD(POINTR,M) + 1
  70     CONTINUE 
 
C           COMPUTE (WBP)MC, (WBP)MP, AND (WBP)M(WBP)'.
         CALL BMV(M,SY,WT,COL,WBP,V,INFO)
         IF (INFO .NE. 0) RETURN
         WMC = DDOT(COL2,C,1,V,1)
         WMP = DDOT(COL2,P,1,V,1) 
         WMW = DDOT(COL2,WBP,1,V,1)
 
C           UPDATE P = P - DIBP*WBP. 
         CALL DAXPY(COL2,-DIBP,WBP,1,P,1)
 
C           COMPLETE UPDATING F1 AND F2 WHILE COL > 0.
         F1 = F1 + DIBP*WMC
         F2 = F2 + 2.0D0*DIBP*WMP - DIBP2*WMW
      ENDIF

      F2 = MAX(EPSMCH*F2_ORG,F2)
      IF (NLEFT .GT. 0) THEN
         DTM = -F1/F2
         GOTO 777
C                 TO REPEAT THE LOOP FOR UNSEARCHED INTERVALS. 
      ELSE IF(BNDED) THEN
         F1 = ZERO
         F2 = ZERO
         DTM = ZERO
      ELSE
         DTM = -F1/F2
      ENDIF 

C------------------- THE END OF THE LOOP -------------------------------
 
 888  CONTINUE
      IF (IPRINT .GE. 99) THEN
         WRITE (6,*)
         WRITE (6,*) 'GCP FOUND IN THIS SEGMENT'
         WRITE (6,4010) NSEG,F1,F2
         WRITE (6,6010) DTM
      ENDIF 
      IF (DTM .LE. ZERO) DTM = ZERO
      TSUM = TSUM + DTM
 
C     MOVE FREE VARIABLES (I.E., THE ONES W/O BREAKPOINTS) AND 
C       THE VARIABLES WHOSE BREAKPOINTS HAVEN'T BEEN REACHED.
 
      CALL DAXPY(N,TSUM,D,1,XCP,1)
 
 999  CONTINUE
 
C     UPDATE C = C + DTM*P = W'(X^C - X) 
C       WHICH WILL BE USED IN COMPUTING R = Z'(B(X^C - X) + G).
 
      IF (COL .GT. 0) CALL DAXPY(COL2,DTM,P,1,C,1)
      IF (IPRINT .GT. 100) WRITE (6,1010) (XCP(I),I = 1,N)
      IF (IPRINT .GE. 99) WRITE (6,2010)

 1010 FORMAT ('CAUCHY X =  ',/,(4X,1P,6(1X,D11.4)))
 2010 FORMAT (/,'---------------- EXIT CAUCHY----------------------',/)
 3010 FORMAT (/,'---------------- CAUCHY ENTERED-------------------')
 4010 FORMAT ('PIECE    ',I3,' --F1, F2 AT START POINT ',1P,2(1X,D11.4))
 4011 FORMAT (/,'PIECE    ',I3,' --F1, F2 AT START POINT ',
     +        1P,2(1X,D11.4))
 5010 FORMAT ('DISTANCE TO THE NEXT BREAK POINT =  ',1P,D11.4)
 6010 FORMAT ('DISTANCE TO THE STATIONARY POINT =  ',1P,D11.4) 
 
      RETURN
 
      END

C====================== THE END OF CAUCHY ==============================

      SUBROUTINE CMPRLB(N, M, X, G, WS, WY, SY, WT, Z, R, WA, INDEX, 
     +                 THETA, COL, HEAD, NFREE, CNSTND, INFO)
 
      LOGICAL          CNSTND
      INTEGER          N, M, COL, HEAD, NFREE, INFO, INDEX(N)
      DOUBLE PRECISION THETA, 
     +                 X(N), G(N), Z(N), R(N), WA(4*M), 
     +                 WS(N, M), WY(N, M), SY(M, M), WT(M, M)

C     ************
C
C     SUBROUTINE CMPRLB 
C
C       THIS SUBROUTINE COMPUTES R=-Z'B(XCP-XK)-Z'G BY USING 
C         WA(2M+1)=W'(XCP-X) FROM SUBROUTINE CAUCHY.
C
C     SUBPROGRAMS CALLED:
C
C       L-BFGS-B LIBRARY ... BMV.
C
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     ************
 
      INTEGER          I,J,K,POINTR
      DOUBLE PRECISION A1,A2

      IF (.NOT. CNSTND .AND. COL .GT. 0) THEN 
         DO 26 I = 1, N
            R(I) = -G(I)
  26     CONTINUE
      ELSE
         DO 30 I = 1, NFREE
            K = INDEX(I)
            R(I) = -THETA*(Z(K) - X(K)) - G(K)
  30     CONTINUE
         CALL BMV(M,SY,WT,COL,WA(2*M+1),WA(1),INFO)
         IF (INFO .NE. 0) THEN
            INFO = -8
            RETURN
         ENDIF
         POINTR = HEAD 
         DO 34 J = 1, COL
            A1 = WA(J)
            A2 = THETA*WA(COL + J)
            DO 32 I = 1, NFREE
               K = INDEX(I)
               R(I) = R(I) + WY(K,POINTR)*A1 + WS(K,POINTR)*A2
  32        CONTINUE
            POINTR = MOD(POINTR,M) + 1
  34     CONTINUE
      ENDIF

      RETURN

      END

C======================= THE END OF CMPRLB =============================

      SUBROUTINE ERRCLB(N, M, FACTR, L, U, NBD, TASK, INFO, K)
 
      CHARACTER*60     TASK
      INTEGER          N, M, INFO, K, NBD(N)
      DOUBLE PRECISION FACTR, L(N), U(N)

C     ************
C
C     SUBROUTINE ERRCLB
C
C     THIS SUBROUTINE CHECKS THE VALIDITY OF THE INPUT DATA.
C
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     ************

      INTEGER          I
      DOUBLE PRECISION ONE,ZERO
      PARAMETER        (ONE=1.0D0,ZERO=0.0D0)

C     CHECK THE INPUT ARGUMENTS FOR ERRORS.

      IF (N .LE. 0) TASK = 'ERROR: N .LE. 0'
      IF (M .LE. 0) TASK = 'ERROR: M .LE. 0'
      IF (FACTR .LT. ZERO) TASK = 'ERROR: FACTR .LT. 0'

C     CHECK THE VALIDITY OF THE ARRAYS NBD(I), U(I), AND L(I).

      DO 10 I = 1, N
         IF (NBD(I) .LT. 0 .OR. NBD(I) .GT. 3) THEN
C                                                   RETURN
            TASK = 'ERROR: INVALID NBD'
            INFO = -6
            K = I
         ENDIF
         IF (NBD(I) .EQ. 2) THEN
            IF (L(I) .GT. U(I)) THEN
C                                    RETURN
               TASK = 'ERROR: NO FEASIBLE SOLUTION'
               INFO = -7
               K = I
            ENDIF
         ENDIF
  10  CONTINUE

      RETURN

      END

C======================= THE END OF ERRCLB =============================
 
      SUBROUTINE FORMK(N, NSUB, IND, NENTER, ILEAVE, INDX2, IUPDAT, 
     +                 UPDATD, WN, WN1, M, WS, WY, SY, THETA, COL,
     +                 HEAD, INFO)

      INTEGER          N, NSUB, M, COL, HEAD, NENTER, ILEAVE, IUPDAT,
     +                 INFO, IND(N), INDX2(N)
      DOUBLE PRECISION THETA, WN(2*M, 2*M), WN1(2*M, 2*M),
     +                 WS(N, M), WY(N, M), SY(M, M)
      LOGICAL          UPDATD

C     ************
C
C     SUBROUTINE FORMK 
C
C     THIS SUBROUTINE FORMS  THE LEL^T FACTORIZATION OF THE INDEFINITE
C
C       MATRIX    K = [-D -Y'ZZ'Y/THETA     L_A'-R_Z'  ]
C                     [L_A -R_Z           THETA*S'AA'S ]
C                                                    WHERE E = [-I  0]
C                                                              [ 0  I]
C     THE MATRIX K CAN BE SHOWN TO BE EQUAL TO THE MATRIX M^[-1]N
C       OCCURRING IN SECTION 5.1 OF [1], AS WELL AS TO THE MATRIX
C       MBAR^[-1] NBAR IN SECTION 5.3.
C
C     N IS AN INTEGER VARIABLE.
C       ON ENTRY N IS THE DIMENSION OF THE PROBLEM.
C       ON EXIT N IS UNCHANGED.
C
C     NSUB IS AN INTEGER VARIABLE
C       ON ENTRY NSUB IS THE NUMBER OF SUBSPACE VARIABLES IN FREE SET.
C       ON EXIT NSUB IS NOT CHANGED.
C
C     IND IS AN INTEGER ARRAY OF DIMENSION NSUB.
C       ON ENTRY IND SPECIFIES THE INDICES OF SUBSPACE VARIABLES.
C       ON EXIT IND IS UNCHANGED. 
C
C     NENTER IS AN INTEGER VARIABLE.
C       ON ENTRY NENTER IS THE NUMBER OF VARIABLES ENTERING THE 
C         FREE SET.
C       ON EXIT NENTER IS UNCHANGED. 
C
C     ILEAVE IS AN INTEGER VARIABLE.
C       ON ENTRY INDX2(ILEAVE),...,INDX2(N) ARE THE VARIABLES LEAVING
C         THE FREE SET.
C       ON EXIT ILEAVE IS UNCHANGED. 
C
C     INDX2 IS AN INTEGER ARRAY OF DIMENSION N.
C       ON ENTRY INDX2(1),...,INDX2(NENTER) ARE THE VARIABLES ENTERING
C         THE FREE SET, WHILE INDX2(ILEAVE),...,INDX2(N) ARE THE
C         VARIABLES LEAVING THE FREE SET.
C       ON EXIT INDX2 IS UNCHANGED. 
C
C     IUPDAT IS AN INTEGER VARIABLE.
C       ON ENTRY IUPDAT IS THE TOTAL NUMBER OF BFGS UPDATES MADE SO FAR.
C       ON EXIT IUPDAT IS UNCHANGED. 
C
C     UPDATD IS A LOGICAL VARIABLE.
C       ON ENTRY 'UPDATD' IS TRUE IF THE L-BFGS MATRIX IS UPDATD.
C       ON EXIT 'UPDATD' IS UNCHANGED. 
C
C     WN IS A DOUBLE PRECISION ARRAY OF DIMENSION 2M X 2M.
C       ON ENTRY WN IS UNSPECIFIED.
C       ON EXIT THE UPPER TRIANGLE OF WN STORES THE LEL^T FACTORIZATION
C         OF THE 2*COL X 2*COL INDEFINITE MATRIX
C                     [-D -Y'ZZ'Y/THETA     L_A'-R_Z'  ]
C                     [L_A -R_Z           THETA*S'AA'S ]
C
C     WN1 IS A DOUBLE PRECISION ARRAY OF DIMENSION 2M X 2M.
C       ON ENTRY WN1 STORES THE LOWER TRIANGULAR PART OF 
C                     [Y' ZZ'Y   L_A'+R_Z']
C                     [L_A+R_Z   S'AA'S   ]
C         IN THE PREVIOUS ITERATION.
C       ON EXIT WN1 STORES THE CORRESPONDING UPDATED MATRICES.
C       THE PURPOSE OF WN1 IS JUST TO STORE THESE INNER PRODUCTS
C       SO THEY CAN BE EASILY UPDATED AND INSERTED INTO WN.
C
C     M IS AN INTEGER VARIABLE.
C       ON ENTRY M IS THE MAXIMUM NUMBER OF VARIABLE METRIC CORRECTIONS
C         USED TO DEFINE THE LIMITED MEMORY MATRIX.
C       ON EXIT M IS UNCHANGED.
C
C     WS, WY, SY, AND WTYY ARE DOUBLE PRECISION ARRAYS;
C     THETA IS A DOUBLE PRECISION VARIABLE;
C     COL IS AN INTEGER VARIABLE;
C     HEAD IS AN INTEGER VARIABLE.
C       ON ENTRY THEY STORE THE INFORMATION DEFINING THE
C                                          LIMITED MEMORY BFGS MATRIX:
C         WS(N,M) STORES S, A SET OF S-VECTORS;
C         WY(N,M) STORES Y, A SET OF Y-VECTORS;
C         SY(M,M) STORES S'Y;
C         WTYY(M,M) STORES THE CHOLESKY FACTORIZATION
C                                   OF (THETA*S'S+LD^(-1)L')
C         THETA IS THE SCALING FACTOR SPECIFYING B_0 = THETA I;
C         COL IS THE NUMBER OF VARIABLE METRIC CORRECTIONS STORED;
C         HEAD IS THE LOCATION OF THE 1ST S- (OR Y-) VECTOR IN S (OR Y).
C       ON EXIT THEY ARE UNCHANGED.
C
C     INFO IS AN INTEGER VARIABLE.
C       ON ENTRY INFO IS UNSPECIFIED.
C       ON EXIT INFO =  0 FOR NORMAL RETURN;
C                    = -1 WHEN THE 1ST CHOLESKY FACTORIZATION FAILED;
C                    = -2 WHEN THE 2ST CHOLESKY FACTORIZATION FAILED.
C
C     SUBPROGRAMS CALLED:
C
C       LINPACK ... DCOPY, DPOFA, DTRSL.
C
C
C     REFERENCES:
C       [1] R. H. BYRD, P. LU, J. NOCEDAL AND C. ZHU, ``A LIMITED
C       MEMORY ALGORITHM FOR BOUND CONSTRAINED OPTIMIZATION'',
C       SIAM J. SCIENTIFIC COMPUTING 16 (1995), NO. 5, PP. 1190--1208.
C
C       [2] C. ZHU, R.H. BYRD, P. LU, J. NOCEDAL, ``L-BFGS-B: A
C       LIMITED MEMORY FORTRAN CODE FOR SOLVING BOUND CONSTRAINED
C       OPTIMIZATION PROBLEMS'', TECH. REPORT, NAM-11, EECS DEPARTMENT,
C       NORTHWESTERN UNIVERSITY, 1994.
C
C       (POSTSCRIPT FILES OF THESE PAPERS ARE AVAILABLE VIA ANONYMOUS
C        FTP TO EECS.NWU.EDU IN THE DIRECTORY PUB/LBFGS/LBFGS_BCM.)
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     ************

      INTEGER          M2,IPNTR,JPNTR,IY,IS,JY,JS,IS1,JS1,K1,I,K,
     +                 COL2,PBEGIN,PEND,DBEGIN,DEND,UPCL
      DOUBLE PRECISION DDOT,TEMP1,TEMP2,TEMP3,TEMP4
      DOUBLE PRECISION ONE,ZERO
      PARAMETER        (ONE=1.0D0,ZERO=0.0D0)

C     FORM THE LOWER TRIANGULAR PART OF
C               WN1 = [Y' ZZ'Y   L_A'+R_Z'] 
C                     [L_A+R_Z   S'AA'S   ]
C        WHERE L_A IS THE STRICTLY LOWER TRIANGULAR PART OF S'AA'Y
C              R_Z IS THE UPPER TRIANGULAR PART OF S'ZZ'Y.
      
      IF (UPDATD) THEN
         IF (IUPDAT .GT. M) THEN 
C                                 SHIFT OLD PART OF WN1.
            DO 10 JY = 1, M - 1
               JS = M + JY
               CALL DCOPY(M-JY,WN1(JY+1,JY+1),1,WN1(JY,JY),1)
               CALL DCOPY(M-JY,WN1(JS+1,JS+1),1,WN1(JS,JS),1)
               CALL DCOPY(M-1,WN1(M+2,JY+1),1,WN1(M+1,JY),1)
  10        CONTINUE
         ENDIF
 
C          PUT NEW ROWS IN BLOCKS (1,1), (2,1) AND (2,2).
         PBEGIN = 1
         PEND = NSUB
         DBEGIN = NSUB + 1
         DEND = N
         IY = COL
         IS = M + COL
         IPNTR = HEAD + COL - 1
         IF (IPNTR .GT. M) IPNTR = IPNTR - M    
         JPNTR = HEAD
         DO 20 JY = 1, COL
            JS = M + JY
            TEMP1 = ZERO
            TEMP2 = ZERO
            TEMP3 = ZERO
C             COMPUTE ELEMENT JY OF ROW 'COL' OF Y'ZZ'Y
            DO 15 K = PBEGIN, PEND
               K1 = IND(K)
               TEMP1 = TEMP1 + WY(K1,IPNTR)*WY(K1,JPNTR)
  15        CONTINUE
C             COMPUTE ELEMENTS JY OF ROW 'COL' OF L_A AND S'AA'S
            DO 16 K = DBEGIN, DEND
               K1 = IND(K)
               TEMP2 = TEMP2 + WS(K1,IPNTR)*WS(K1,JPNTR)
               TEMP3 = TEMP3 + WS(K1,IPNTR)*WY(K1,JPNTR)
  16        CONTINUE
            WN1(IY,JY) = TEMP1
            WN1(IS,JS) = TEMP2
            WN1(IS,JY) = TEMP3
            JPNTR = MOD(JPNTR,M) + 1
  20     CONTINUE
 
C          PUT NEW COLUMN IN BLOCK (2,1).
         JY = COL       
         JPNTR = HEAD + COL - 1
         IF (JPNTR .GT. M) JPNTR = JPNTR - M
         IPNTR = HEAD
         DO 30 I = 1, COL
            IS = M + I
            TEMP3 = ZERO
C             COMPUTE ELEMENT I OF COLUMN 'COL' OF R_Z
            DO 25 K = PBEGIN, PEND
               K1 = IND(K)
               TEMP3 = TEMP3 + WS(K1,IPNTR)*WY(K1,JPNTR)
  25        CONTINUE 
            IPNTR = MOD(IPNTR,M) + 1
            WN1(IS,JY) = TEMP3
  30     CONTINUE
         UPCL = COL - 1
      ELSE
         UPCL = COL
      ENDIF
 
C       MODIFY THE OLD PARTS IN BLOCKS (1,1) AND (2,2) DUE TO CHANGES
C       IN THE SET OF FREE VARIABLES.
      IPNTR = HEAD      
      DO 45 IY = 1, UPCL
         IS = M + IY
         JPNTR = HEAD
         DO 40 JY = 1, IY
            JS = M + JY
            TEMP1 = ZERO
            TEMP2 = ZERO
            TEMP3 = ZERO
            TEMP4 = ZERO
            DO 35 K = 1, NENTER
               K1 = INDX2(K)
               TEMP1 = TEMP1 + WY(K1,IPNTR)*WY(K1,JPNTR)
               TEMP2 = TEMP2 + WS(K1,IPNTR)*WS(K1,JPNTR)
  35        CONTINUE
            DO 36 K = ILEAVE, N
               K1 = INDX2(K)
               TEMP3 = TEMP3 + WY(K1,IPNTR)*WY(K1,JPNTR)
               TEMP4 = TEMP4 + WS(K1,IPNTR)*WS(K1,JPNTR)
  36        CONTINUE
            WN1(IY,JY) = WN1(IY,JY) + TEMP1 - TEMP3 
            WN1(IS,JS) = WN1(IS,JS) - TEMP2 + TEMP4 
            JPNTR = MOD(JPNTR,M) + 1
  40     CONTINUE
         IPNTR = MOD(IPNTR,M) + 1
  45  CONTINUE
 
C       MODIFY THE OLD PARTS IN BLOCK (2,1).
      IPNTR = HEAD      
      DO 60 IS = M + 1, M + UPCL
         JPNTR = HEAD 
         DO 55 JY = 1, UPCL
            TEMP1 = ZERO
            TEMP3 = ZERO
            DO 50 K = 1, NENTER
               K1 = INDX2(K)
               TEMP1 = TEMP1 + WS(K1,IPNTR)*WY(K1,JPNTR)
  50        CONTINUE
            DO 51 K = ILEAVE, N
               K1 = INDX2(K)
               TEMP3 = TEMP3 + WS(K1,IPNTR)*WY(K1,JPNTR)
  51        CONTINUE
         IF (IS .LE. JY + M) THEN
               WN1(IS,JY) = WN1(IS,JY) + TEMP1 - TEMP3  
            ELSE
               WN1(IS,JY) = WN1(IS,JY) - TEMP1 + TEMP3  
            ENDIF
            JPNTR = MOD(JPNTR,M) + 1
  55     CONTINUE
         IPNTR = MOD(IPNTR,M) + 1
  60  CONTINUE
 
C     FORM THE UPPER TRIANGLE OF WN = [D+Y' ZZ'Y/THETA   -L_A'+R_Z' ] 
C                                     [-L_A +R_Z        S'AA'S*THETA]

      M2 = 2*M
      DO 70 IY = 1, COL
         IS = COL + IY
         IS1 = M + IY
         DO 65 JY = 1, IY
            JS = COL + JY
            JS1 = M + JY
            WN(JY,IY) = WN1(IY,JY)/THETA
            WN(JS,IS) = WN1(IS1,JS1)*THETA
  65     CONTINUE
         DO 66 JY = 1, IY - 1
            WN(JY,IS) = -WN1(IS1,JY)
  66     CONTINUE
         DO 67 JY = IY, COL
            WN(JY,IS) = WN1(IS1,JY)
  67     CONTINUE
         WN(IY,IY) = WN(IY,IY) + SY(IY,IY)
  70  CONTINUE

C     FORM THE UPPER TRIANGLE OF WN= [  LL'            L^-1(-L_A'+R_Z')] 
C                                    [(-L_A +R_Z)L'^-1   S'AA'S*THETA  ]

C        FIRST CHOLESKY FACTOR (1,1) BLOCK OF WN TO GET LL'
C                          WITH L' STORED IN THE UPPER TRIANGLE OF WN.
      CALL DPOFA(WN,M2,COL,INFO)
      IF (INFO .NE. 0) THEN
         INFO = -1
         RETURN
      ENDIF
C        THEN FORM L^-1(-L_A'+R_Z') IN THE (1,2) BLOCK.
      COL2 = 2*COL
      DO 71 JS = COL+1 ,COL2
         CALL DTRSL(WN,M2,COL,WN(1,JS),11,INFO)
  71  CONTINUE

C     FORM S'AA'S*THETA + (L^-1(-L_A'+R_Z'))'L^-1(-L_A'+R_Z') IN THE
C        UPPER TRIANGLE OF (2,2) BLOCK OF WN.
                      

      DO 72 IS = COL+1, COL2
         DO 74 JS = IS, COL2
               WN(IS,JS) = WN(IS,JS) + DDOT(COL,WN(1,IS),1,WN(1,JS),1)
  74        CONTINUE
  72     CONTINUE

C     CHOLESKY FACTORIZATION OF (2,2) BLOCK OF WN.

      CALL DPOFA(WN(COL+1,COL+1),M2,COL,INFO)
      IF (INFO .NE. 0) THEN
         INFO = -2
         RETURN
      ENDIF

      RETURN

      END

C======================= THE END OF FORMK ==============================

      SUBROUTINE FORMT(M, WT, SY, SS, COL, THETA, INFO)
 
      INTEGER          M, COL, INFO
      DOUBLE PRECISION THETA, WT(M, M), SY(M, M), SS(M, M)

C     ************
C
C     SUBROUTINE FORMT
C
C       THIS SUBROUTINE FORMS THE UPPER HALF OF THE POS. DEF. AND SYMM.
C         T = THETA*SS + L*D^(-1)*L', STORES T IN THE UPPER TRIANGLE
C         OF THE ARRAY WT, AND PERFORMS THE CHOLESKY FACTORIZATION OF T
C         TO PRODUCE J*J', WITH J' STORED IN THE UPPER TRIANGLE OF WT.
C
C     SUBPROGRAMS CALLED:
C
C       LINPACK ... DPOFA.
C
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     ************

      INTEGER          I,J,K,K1
      DOUBLE PRECISION DDUM
      DOUBLE PRECISION ZERO
      PARAMETER        (ZERO=0.0D0)


C     FORM THE UPPER HALF OF  T = THETA*SS + L*D^(-1)*L',
C        STORE T IN THE UPPER TRIANGLE OF THE ARRAY WT.
 
      DO 52 J = 1, COL
         WT(1,J) = THETA*SS(1,J)
  52  CONTINUE
      DO 55 I = 2, COL
         DO 54 J = I, COL
            K1 = MIN(I,J) - 1
            DDUM  = ZERO
            DO 53 K = 1, K1
               DDUM  = DDUM + SY(I,K)*SY(J,K)/SY(K,K)
  53        CONTINUE
            WT(I,J) = DDUM + THETA*SS(I,J)
  54     CONTINUE
  55  CONTINUE
 
C     CHOLESKY FACTORIZE T TO J*J' WITH 
C        J' STORED IN THE UPPER TRIANGLE OF WT.
 
      CALL DPOFA(WT,M,COL,INFO)
      IF (INFO .NE. 0) THEN
         INFO = -3
      ENDIF

      RETURN

      END

C======================= THE END OF FORMT ==============================
 
      SUBROUTINE FREEV(N, NFREE, INDEX, NENTER, ILEAVE, INDX2, 
     +                 IWHERE, WRK, UPDATD, CNSTND, IPRINT, ITER)

      INTEGER N, NFREE, NENTER, ILEAVE, IPRINT, ITER, 
     +        INDEX(N), INDX2(N), IWHERE(N)
      LOGICAL WRK, UPDATD, CNSTND

C     ************
C
C     SUBROUTINE FREEV 
C
C     THIS SUBROUTINE COUNTS THE ENTERING AND LEAVING VARIABLES WHEN
C       ITER > 0, AND FINDS THE INDEX SET OF FREE AND ACTIVE VARIABLES
C       AT THE GCP.
C
C     CNSTND IS A LOGICAL VARIABLE INDICATING WHETHER BOUNDS ARE PRESENT
C
C     INDEX IS AN INTEGER ARRAY OF DIMENSION N
C       FOR I=1,...,NFREE, INDEX(I) ARE THE INDICES OF FREE VARIABLES
C       FOR I=NFREE+1,...,N, INDEX(I) ARE THE INDICES OF BOUND VARIABLES
C       ON ENTRY AFTER THE FIRST ITERATION, INDEX GIVES 
C         THE FREE VARIABLES AT THE PREVIOUS ITERATION.
C       ON EXIT IT GIVES THE FREE VARIABLES BASED ON THE DETERMINATION
C         IN CAUCHY USING THE ARRAY IWHERE.
C
C     INDX2 IS AN INTEGER ARRAY OF DIMENSION N
C       ON ENTRY INDX2 IS UNSPECIFIED.
C       ON EXIT WITH ITER>0, INDX2 INDICATES WHICH VARIABLES
C          HAVE CHANGED STATUS SINCE THE PREVIOUS ITERATION.
C       FOR I= 1,...,NENTER, INDX2(I) HAVE CHANGED FROM BOUND TO FREE.
C       FOR I= ILEAVE+1,...,N, INDX2(I) HAVE CHANGED FROM FREE TO BOUND.
C 
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     ************
 
      INTEGER IACT,I,K

      NENTER = 0
      ILEAVE = N + 1
      IF (ITER .GT. 0 .AND. CNSTND) THEN
C                           COUNT THE ENTERING AND LEAVING VARIABLES.
         DO 20 I = 1, NFREE
            K = INDEX(I)

C            WRITE(6,*) ' K  = INDEX(I) ', K
C            WRITE(6,*) ' INDEX = ', I

            IF (IWHERE(K) .GT. 0) THEN
               ILEAVE = ILEAVE - 1
               INDX2(ILEAVE) = K
               IF (IPRINT .GE. 100) WRITE (6,*)
     +             'VARIABLE ',K,' LEAVES THE SET OF FREE VARIABLES'
            ENDIF
  20     CONTINUE
         DO 22 I = 1 + NFREE, N
            K = INDEX(I)
            IF (IWHERE(K) .LE. 0) THEN
               NENTER = NENTER + 1
               INDX2(NENTER) = K
               IF (IPRINT .GE. 100) WRITE (6,*)
     +             'VARIABLE ',K,' ENTERS THE SET OF FREE VARIABLES'
            ENDIF
  22     CONTINUE
         IF (IPRINT .GE. 99) WRITE (6,*)
     +       N+1-ILEAVE,' VARIABLES LEAVE; ',NENTER,' VARIABLES ENTER'
      ENDIF
      WRK = (ILEAVE .LT. N+1) .OR. (NENTER .GT. 0) .OR. UPDATD
 
C     FIND THE INDEX SET OF FREE AND ACTIVE VARIABLES AT THE GCP.
 
      NFREE = 0 
      IACT = N + 1
      DO 24 I = 1, N
         IF (IWHERE(I) .LE. 0) THEN
            NFREE = NFREE + 1
            INDEX(NFREE) = I
         ELSE
            IACT = IACT - 1
            INDEX(IACT) = I
         ENDIF
  24  CONTINUE
      IF (IPRINT .GE. 99) WRITE (6,*)
     +      NFREE,' VARIABLES ARE FREE AT GCP ',ITER + 1  

      RETURN

      END

C======================= THE END OF FREEV ==============================

      SUBROUTINE HPSOLB(N, T, IORDER, IHEAP)
      INTEGER          IHEAP, N, IORDER(N)
      DOUBLE PRECISION T(N)
  
C     ************
C
C     SUBROUTINE HPSOLB 
C
C     THIS SUBROUTINE SORTS OUT THE LEAST ELEMENT OF T, AND PUTS THE
C       REMAINING ELEMENTS OF T IN A HEAP.
C 
C     N IS AN INTEGER VARIABLE.
C       ON ENTRY N IS THE DIMENSION OF THE ARRAYS T AND IORDER.
C       ON EXIT N IS UNCHANGED.
C
C     T IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON ENTRY T STORES THE ELEMENTS TO BE SORTED,
C       ON EXIT T(N) STORES THE LEAST ELEMENTS OF T, AND T(1) TO T(N-1)
C         STORES THE REMAINING ELEMENTS IN THE FORM OF A HEAP.
C
C     IORDER IS AN INTEGER ARRAY OF DIMENSION N.
C       ON ENTRY IORDER(I) IS THE INDEX OF T(I).
C       ON EXIT IORDER(I) IS STILL THE INDEX OF T(I), BUT IORDER MAY BE
C         PERMUTED IN ACCORDANCE WITH T.
C
C     IHEAP IS AN INTEGER VARIABLE SPECIFYING THE TASK.
C       ON ENTRY IHEAP SHOULD BE SET AS FOLLOWS:
C         IHEAP .EQ. 0 IF T(1) TO T(N) IS NOT IN THE FORM OF A HEAP,
C         IHEAP .NE. 0 IF OTHERWISE.
C       ON EXIT IHEAP IS UNCHANGED.
C
C
C     REFERENCES:
C       ALGORITHM 232 OF CACM (J. W. J. WILLIAMS): HEAPSORT.
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C     ************
  
      INTEGER          I,J,K,INDXIN,INDXOU
      DOUBLE PRECISION DDUM,OUT

      IF (IHEAP .EQ. 0) THEN

C        REARRANGE THE ELEMENTS T(1) TO T(N) TO FORM A HEAP.

         DO 20 K = 2, N
            DDUM  = T(K)
            INDXIN = IORDER(K)

C           ADD DDUM TO THE HEAP.
            I = K
   10       CONTINUE
            IF (I.GT.1) THEN
               J = I/2
               IF (DDUM .LT. T(J)) THEN
                  T(I) = T(J)
                  IORDER(I) = IORDER(J)
                  I = J
                  GOTO 10 
               ENDIF  
            ENDIF  
            T(I) = DDUM
            IORDER(I) = INDXIN
   20    CONTINUE
      ENDIF
 
C     ASSIGN TO 'OUT' THE VALUE OF T(1), THE LEAST MEMBER OF THE HEAP,
C        AND REARRANGE THE REMAINING MEMBERS TO FORM A HEAP AS
C        ELEMENTS 1 TO N-1 OF T.
 
      IF (N .GT. 1) THEN
         I = 1
         OUT = T(1)
         INDXOU = IORDER(1)
         DDUM  = T(N)
         INDXIN  = IORDER(N)

C        RESTORE THE HEAP 
   30    CONTINUE
         J = I+I
         IF (J .LE. N-1) THEN
            IF (T(J+1) .LT. T(J)) J = J+1
            IF (T(J) .LT. DDUM ) THEN
               T(I) = T(J)
               IORDER(I) = IORDER(J)
               I = J
               GOTO 30
            ENDIF 
         ENDIF 
         T(I) = DDUM
         IORDER(I) = INDXIN
 
C     PUT THE LEAST MEMBER IN T(N). 

         T(N) = OUT
         IORDER(N) = INDXOU
      ENDIF 

      RETURN

      END

C====================== THE END OF HPSOLB ==============================

      SUBROUTINE LNSRLB(N, L, U, NBD, X, F, FOLD, GD, GDOLD, G, D, R, T,
     +                  Z, STP, DNORM, DTD, XSTEP, STPMX, ITER, IFUN,
     +                  IBACK, NFGV, INFO, TASK, BOXED, CNSTND, CSAVE,
     +                  ISAVE, DSAVE)

      CHARACTER*60     TASK, CSAVE
      LOGICAL          BOXED, CNSTND
      INTEGER          N, ITER, IFUN, IBACK, NFGV, INFO,
     +                 NBD(N), ISAVE(2)
      DOUBLE PRECISION F, FOLD, GD, GDOLD, STP, DNORM, DTD, XSTEP,
     +                 STPMX, X(N), L(N), U(N), G(N), D(N), R(N), T(N),
     +                 Z(N), DSAVE(13)
C     **********
C
C     SUBROUTINE LNSRLB
C
C     THIS SUBROUTINE CALLS SUBROUTINE DCSRCH FROM THE MINPACK2 LIBRARY
C       TO PERFORM THE LINE SEARCH.  SUBROUTINE DSCRCH IS SAFEGUARDED SO
C       THAT ALL TRIAL POINTS LIE WITHIN THE FEASIBLE REGION.
C
C     SUBPROGRAMS CALLED:
C
C       MINPACK2 LIBRARY ... DCSRCH.
C
C       LINPACK ... DTRSL, DDOT.
C
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     **********

      INTEGER          I
      DOUBLE           PRECISION DDOT,A1,A2
      DOUBLE PRECISION ONE,ZERO,BIG
      PARAMETER        (ONE=1.0D0,ZERO=0.0D0,BIG=1.0D+10)
      DOUBLE PRECISION FTOL,GTOL,XTOL
      PARAMETER        (FTOL=1.0D-3,GTOL=0.9D0,XTOL=0.1D0)

      IF (TASK(1:5) .EQ. 'FG_LN') GOTO 556

      DTD = DDOT(N,D,1,D,1)
      DNORM = SQRT(DTD)

C     DETERMINE THE MAXIMUM STEP LENGTH.

      STPMX = BIG
      IF (CNSTND) THEN
         IF (ITER .EQ. 0) THEN
            STPMX = ONE
         ELSE
            DO 43 I = 1, N
               A1 = D(I)
               IF (NBD(I) .NE. 0) THEN
                  IF (A1 .LT. ZERO .AND. NBD(I) .LE. 2) THEN
                     A2 = L(I) - X(I)
                     IF (A2 .GE. ZERO) THEN
                        STPMX = ZERO
                     ELSE IF (A1*STPMX .LT. A2) THEN
                        STPMX = A2/A1
                     ENDIF
                  ELSE IF (A1 .GT. ZERO .AND. NBD(I) .GE. 2) THEN
                     A2 = U(I) - X(I)
                     IF (A2 .LE. ZERO) THEN
                        STPMX = ZERO
                     ELSE IF (A1*STPMX .GT. A2) THEN
                        STPMX = A2/A1
                     ENDIF
                  ENDIF
               ENDIF
  43        CONTINUE
         ENDIF
      ENDIF
 
      IF (ITER .EQ. 0 .AND. .NOT. BOXED) THEN
         STP = MIN(ONE/DNORM, STPMX)
      ELSE
         STP = ONE
      ENDIF 

      CALL DCOPY(N,X,1,T,1)
      CALL DCOPY(N,G,1,R,1)
      FOLD = F
      IFUN = 0
      IBACK = 0
      CSAVE = 'START'
 556  CONTINUE
      GD = DDOT(N,G,1,D,1)
      IF (IFUN .EQ. 0) THEN
         GDOLD=GD
         IF (GD .GE. ZERO) THEN
C                               THE DIRECTIONAL DERIVATIVE >=0.
C                               LINE SEARCH IS IMPOSSIBLE.
            WRITE(6,*)' ASCENT DIRECTION IN PROJECTION GD = ', GD
            INFO = -4
            RETURN
         ENDIF
      ENDIF

      CALL DCSRCH(F,GD,STP,FTOL,GTOL,XTOL,ZERO,STPMX,CSAVE,ISAVE,DSAVE)

      XSTEP = STP*DNORM
      IF (CSAVE(1:4) .NE. 'CONV' .AND. CSAVE(1:4) .NE. 'WARN') THEN
         TASK = 'FG_LNSRCH'
         IFUN = IFUN + 1
         NFGV = NFGV + 1
         IBACK = IFUN - 1 
         IF (STP .EQ. ONE) THEN
            CALL DCOPY(N,Z,1,X,1)
         ELSE
            DO 41 I = 1, N
               X(I) = STP*D(I) + T(I)
  41        CONTINUE
         ENDIF
      ELSE
         TASK = 'NEW_X'
      ENDIF

      RETURN

      END

C======================= THE END OF LNSRLB =============================

      SUBROUTINE MATUPD(N, M, WS, WY, SY, SS, D, R, ITAIL, 
     +                  IUPDAT, COL, HEAD, THETA, RR, DR, STP, DTD)
 
      INTEGER          N, M, ITAIL, IUPDAT, COL, HEAD
      DOUBLE PRECISION THETA, RR, DR, STP, DTD, D(N), R(N), 
     +                 WS(N, M), WY(N, M), SY(M, M), SS(M, M)

C     ************
C
C     SUBROUTINE MATUPD
C
C       THIS SUBROUTINE UPDATES MATRICES WS AND WY, AND FORMS THE
C         MIDDLE MATRIX IN B.
C
C     SUBPROGRAMS CALLED:
C
C       LINPACK ... DCOPY, DDOT.
C
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     ************
 
      INTEGER          J,POINTR
      DOUBLE PRECISION DDOT
      DOUBLE PRECISION ONE
      PARAMETER        (ONE=1.0D0)

C     SET POINTERS FOR MATRICES WS AND WY.
 
      IF (IUPDAT .LE. M) THEN
         COL = IUPDAT
         ITAIL = MOD(HEAD+IUPDAT-2,M) + 1
      ELSE
         ITAIL = MOD(ITAIL,M) + 1
         HEAD = MOD(HEAD,M) + 1
      ENDIF
 
C     UPDATE MATRICES WS AND WY.

      CALL DCOPY(N,D,1,WS(1,ITAIL),1)
      CALL DCOPY(N,R,1,WY(1,ITAIL),1)
 
C     SET THETA=YY/YS.
 
      THETA = RR/DR
 
C     FORM THE MIDDLE MATRIX IN B.
 
C        UPDATE THE UPPER TRIANGLE OF SS,
C                                         AND THE LOWER TRIANGLE OF SY:
      IF (IUPDAT .GT. M) THEN
C                              MOVE OLD INFORMATION
         DO 50 J = 1, COL - 1
            CALL DCOPY(J,SS(2,J+1),1,SS(1,J),1)
            CALL DCOPY(COL-J,SY(J+1,J+1),1,SY(J,J),1)
  50     CONTINUE
      ENDIF
C        ADD NEW INFORMATION: THE LAST ROW OF SY
C                                             AND THE LAST COLUMN OF SS:
      POINTR = HEAD
      DO 51 J = 1, COL - 1
         SY(COL,J) = DDOT(N,D,1,WY(1,POINTR),1)
         SS(J,COL) = DDOT(N,WS(1,POINTR),1,D,1)
         POINTR = MOD(POINTR,M) + 1
  51  CONTINUE
      IF (STP .EQ. ONE) THEN
         SS(COL,COL) = DTD
      ELSE
         SS(COL,COL) = STP*STP*DTD
      ENDIF
      SY(COL,COL) = DR
 
      RETURN

      END

C======================= THE END OF MATUPD =============================

      SUBROUTINE PRN1LB(N, M, L, U, X, IPRINT, ITFILE, EPSMCH)
 
      INTEGER N, M, IPRINT, ITFILE
      DOUBLE PRECISION EPSMCH, X(N), L(N), U(N)

C     ************
C
C     SUBROUTINE PRN1LB
C
C     THIS SUBROUTINE PRINTS THE INPUT DATA, INITIAL POINT, UPPER AND
C       LOWER BOUNDS OF EACH VARIABLE, MACHINE PRECISION, AS WELL AS 
C       THE HEADINGS OF THE OUTPUT.
C
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     ************

      INTEGER I

      IF (IPRINT .GE. 0) THEN
         WRITE (6,7001) EPSMCH
         WRITE (6,*) 'N = ',N,'    M = ',M
         IF (IPRINT .GE. 1) THEN
            WRITE (ITFILE,2001) EPSMCH
            WRITE (ITFILE,*)'N = ',N,'    M = ',M
            WRITE (ITFILE,9001)
            IF (IPRINT .GT. 100) THEN
               WRITE (6,1004) 'L =',(L(I),I = 1,N)
               WRITE (6,1004) 'X0 =',(X(I),I = 1,N)
               WRITE (6,1004) 'U =',(U(I),I = 1,N)
            ENDIF 
         ENDIF
      ENDIF 

 1004 FORMAT (/,A4, 1P, 6(1X,D11.4),/,(4X,1P,6(1X,D11.4)))
 2001 FORMAT ('RUNNING THE L-BFGS-B CODE',/,/,
     + 'IT    = ITERATION NUMBER',/,
     + 'NF    = NUMBER OF FUNCTION EVALUATIONS',/,
     + 'NSEG  = NUMBER OF SEGMENTS EXPLORED DURING THE CAUCHY SEARCH',/,
     + 'NACT  = NUMBER OF ACTIVE BOUNDS AT THE GENERALIZED CAUCHY POINT'
     + ,/,
     + 'SUB   = MANNER IN WHICH THE SUBSPACE MINIMIZATION TERMINATED:'
     + ,/,'        CON = CONVERGED, BND = A BOUND WAS REACHED',/,
     + 'ITLS  = NUMBER OF ITERATIONS PERFORMED IN THE LINE SEARCH',/,
     + 'STEPL = STEP LENGTH USED',/,
     + 'TSTEP = NORM OF THE DISPLACEMENT (TOTAL STEP)',/,
     + 'PROJG = NORM OF THE PROJECTED GRADIENT',/,
     + 'F     = FUNCTION VALUE',/,/,
     + '           * * *',/,/,
     + 'MACHINE PRECISION =',1P,D10.3)
 7001 FORMAT ('RUNNING THE L-BFGS-B CODE',/,/,
     + '           * * *',/,/,
     + 'MACHINE PRECISION =',1P,D10.3)
 9001 FORMAT (/,3X,'IT',3X,'NF',2X,'NSEG',2X,'NACT',2X,'SUB',2X,'ITLS',
     +        2X,'STEPL',4X,'TSTEP',5X,'PROJG',8X,'F')

      RETURN

      END

C======================= THE END OF PRN1LB =============================

      SUBROUTINE PRN2LB(N, X, F, G, IPRINT, ITFILE, ITER, NFGV, NACT, 
     +                  SBGNRM, NSEG, WORD, IWORD, IBACK, STP, XSTEP)
 
      CHARACTER*3      WORD
      INTEGER          N, IPRINT, ITFILE, ITER, NFGV, NACT, NSEG,
     +                 IWORD, IBACK
      DOUBLE PRECISION F, SBGNRM, STP, XSTEP, X(N), G(N)

C     ************
C
C     SUBROUTINE PRN2LB
C
C     THIS SUBROUTINE PRINTS OUT NEW INFORMATION AFTER A SUCCESSFUL
C       LINE SEARCH. 
C
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     ************

      INTEGER I,IMOD

C           'WORD' RECORDS THE STATUS OF SUBSPACE SOLUTIONS.
      IF (IWORD .EQ. 0) THEN
C                            THE SUBSPACE MINIMIZATION CONVERGED.
         WORD = 'CON'
      ELSE IF (IWORD .EQ. 1) THEN
C                          THE SUBSPACE MINIMIZATION STOPPED AT A BOUND.
         WORD = 'BND'
      ELSE IF (IWORD .EQ. 5) THEN
C                             THE TRUNCATED NEWTON STEP HAS BEEN USED.
         WORD = 'TNT'
      ELSE
         WORD = '---'
      ENDIF
      IF (IPRINT .GE. 99) THEN
         WRITE (6,*) 'LINE SEARCH',IBACK,' TIMES; NORM OF STEP = ',XSTEP
         WRITE (6,2001) ITER,F,SBGNRM
         IF (IPRINT .GT. 100) THEN      
            WRITE (6,1004) 'X =',(X(I), I = 1, N)
            WRITE (6,1004) 'G =',(G(I), I = 1, N)
         ENDIF
      ELSE IF (IPRINT .GT. 0) THEN 
         IMOD = MOD(ITER,IPRINT)
         IF (IMOD .EQ. 0) WRITE (6,2001) ITER,F,SBGNRM
      ENDIF
      IF (IPRINT .GE. 1) WRITE (ITFILE,3001)
     +          ITER,NFGV,NSEG,NACT,WORD,IBACK,STP,XSTEP,SBGNRM,F

 1004 FORMAT (/,A4, 1P, 6(1X,D11.4),/,(4X,1P,6(1X,D11.4)))
 2001 FORMAT
     +  (/,'AT ITERATE',I5,4X,'F= ',1P,D12.5,4X,'|PROJ G|= ',1P,D12.5)
 3001 FORMAT(2(1X,I4),2(1X,I5),2X,A3,1X,I4,1P,2(2X,D7.1),1P,2(1X,D10.3))

      RETURN

      END

C======================= THE END OF PRN2LB =============================

      SUBROUTINE PRN3LB(N, X, F, TASK, IPRINT, INFO, ITFILE, 
     +                  ITER, NFGV, NINTOL, NSKIP, NACT, SBGNRM, 
     +                  TIME, NSEG, WORD, IBACK, STP, XSTEP, K, 
     +                  CACHYT, SBTIME, LNSCHT)
 
      CHARACTER*60     TASK
      CHARACTER*3      WORD
      INTEGER          N, IPRINT, INFO, ITFILE, ITER, NFGV, NINTOL,
     +                 NSKIP, NACT, NSEG, IBACK, K
      DOUBLE PRECISION F, SBGNRM, TIME, STP, XSTEP, CACHYT, SBTIME,
     +                 LNSCHT, X(N)

C     ************
C
C     SUBROUTINE PRN3LB
C
C     THIS SUBROUTINE PRINTS OUT INFORMATION WHEN EITHER A BUILT-IN
C       CONVERGENCE TEST IS SATISFIED OR WHEN AN ERROR MESSAGE IS
C       GENERATED.
C       
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     ************

      INTEGER I

      IF (TASK(1:5) .EQ. 'ERROR') GOTO 999

      IF (IPRINT .GE. 0) THEN
         WRITE (6,3003)
         WRITE (6,3004)
         WRITE(6,3005) N,ITER,NFGV,NINTOL,NSKIP,NACT,SBGNRM,F
         IF (IPRINT .GE. 100) THEN
            WRITE (6,1004) 'X =',(X(I),I = 1,N)
         ENDIF  
         IF (IPRINT .GE. 1) WRITE (6,*) ' F =',F
      ENDIF 
 999  CONTINUE
      IF (IPRINT .GE. 0) THEN
         WRITE (6,3009) TASK
         IF (INFO .NE. 0) THEN
            IF (INFO .EQ. -1) WRITE (6,9011)
            IF (INFO .EQ. -2) WRITE (6,9012)
            IF (INFO .EQ. -3) WRITE (6,9013)
            IF (INFO .EQ. -4) WRITE (6,9014)
            IF (INFO .EQ. -5) WRITE (6,9015)
            IF (INFO .EQ. -6) WRITE (6,*)' INPUT NBD(',K,') IS INVALID.'
            IF (INFO .EQ. -7) 
     +      WRITE (6,*)' L(',K,') > U(',K,').  NO FEASIBLE SOLUTION.'
            IF (INFO .EQ. -8) WRITE (6,9018)
            IF (INFO .EQ. -9) WRITE (6,9019)
         ENDIF
         IF (IPRINT .GE. 1) WRITE (6,3007) CACHYT,SBTIME,LNSCHT
         WRITE (6,3008) TIME
         IF (IPRINT .GE. 1) THEN
            IF (INFO .EQ. -4 .OR. INFO .EQ. -9) THEN
               WRITE (ITFILE,3002)
     +             ITER,NFGV,NSEG,NACT,WORD,IBACK,STP,XSTEP
            ENDIF
            WRITE (ITFILE,3009) TASK
            IF (INFO .NE. 0) THEN
               IF (INFO .EQ. -1) WRITE (ITFILE,9011)
               IF (INFO .EQ. -2) WRITE (ITFILE,9012)
               IF (INFO .EQ. -3) WRITE (ITFILE,9013)
               IF (INFO .EQ. -4) WRITE (ITFILE,9014)
               IF (INFO .EQ. -5) WRITE (ITFILE,9015)
               IF (INFO .EQ. -8) WRITE (ITFILE,9018)
               IF (INFO .EQ. -9) WRITE (ITFILE,9019)
            ENDIF
            WRITE (ITFILE,3008) TIME
         ENDIF
      ENDIF

 1004 FORMAT (/,A4, 1P, 6(1X,D11.4),/,(4X,1P,6(1X,D11.4)))
 3002 FORMAT(2(1X,I4),2(1X,I5),2X,A3,1X,I4,1P,2(2X,D7.1),6X,'-',10X,'-')
 3003 FORMAT (/,
     + '           * * *',/,/,
     + 'TIT   = TOTAL NUMBER OF ITERATIONS',/,
     + 'TNF   = TOTAL NUMBER OF FUNCTION EVALUATIONS',/,
     + 'TNINT = TOTAL NUMBER OF SEGMENTS EXPLORED DURING',
     +           ' CAUCHY SEARCHES',/,
     + 'SKIP  = NUMBER OF BFGS UPDATES SKIPPED',/,
     + 'NACT  = NUMBER OF ACTIVE BOUNDS AT FINAL GENERALIZED',
     +          ' CAUCHY POINT',/,
     + 'PROJG = NORM OF THE FINAL PROJECTED GRADIENT',/,
     + 'F     = FINAL FUNCTION VALUE',/,/,
     + '           * * *')
 3004 FORMAT (/,3X,'N',4X,'TIT',5X,'TNF',2X,'TNINT',2X,
     +       'SKIP',2X,'NACT',5X,'PROJG',8X,'F')
 3005 FORMAT (I5,2(1X,I6),(1X,I6),(2X,I4),(1X,I5),1P,2(2X,D10.3))
 3007 FORMAT (/,' CAUCHY                TIME',1P,E10.3,' SECONDS.',/ 
     +        ' SUBSPACE MINIMIZATION TIME',1P,E10.3,' SECONDS.',/
     +        ' LINE SEARCH           TIME',1P,E10.3,' SECONDS.')
 3008 FORMAT (/,' TOTAL USER TIME',1P,E10.3,' SECONDS.',/)
 3009 FORMAT (/,A60)
 9011 FORMAT (/,
     +' MATRIX IN 1ST CHOLESKY FACTORIZATION IN FORMK IS NOT POS. DEF.')
 9012 FORMAT (/,
     +' MATRIX IN 2ST CHOLESKY FACTORIZATION IN FORMK IS NOT POS. DEF.')
 9013 FORMAT (/,
     +' MATRIX IN THE CHOLESKY FACTORIZATION IN FORMT IS NOT POS. DEF.')
 9014 FORMAT (/,
     +' DERIVATIVE >= 0, BACKTRACKING LINE SEARCH IMPOSSIBLE.',/,
     +'   PREVIOUS X, F AND G RESTORED.',/,
     +' POSSIBLE CAUSES: 1 ERROR IN FUNCTION OR GRADIENT EVALUATION;',/,
     +'                  2 ROUNDING ERRORS DOMINATE COMPUTATION.')
 9015 FORMAT (/,
     +' WARNING:  MORE THAN 10 FUNCTION AND GRADIENT',/,
     +'   EVALUATIONS IN THE LAST LINE SEARCH.  TERMINATION',/,
     +'   MAY POSSIBLY BE CAUSED BY A BAD SEARCH DIRECTION.')
 9018 FORMAT (/,' THE TRIANGULAR SYSTEM IS SINGULAR.')
 9019 FORMAT (/,
     +' LINE SEARCH CANNOT LOCATE AN ADEQUATE POINT AFTER 20 FUNCTION',/
     +,'  AND GRADIENT EVALUATIONS.  PREVIOUS X, F AND G RESTORED.',/,
     +' POSSIBLE CAUSES: 1 ERROR IN FUNCTION OR GRADIENT EVALUATION;',/,
     +'                  2 ROUNDING ERROR DOMINATE COMPUTATION.')

      RETURN

      END

C======================= THE END OF PRN3LB =============================

      SUBROUTINE PROJGR(N, L, U, NBD, X, G, SBGNRM)

      INTEGER          N, NBD(N)
      DOUBLE PRECISION SBGNRM, X(N), L(N), U(N), G(N)

C     ************
C
C     SUBROUTINE PROJGR
C
C     THIS SUBROUTINE COMPUTES THE INFINITY NORM OF THE PROJECTED
C       GRADIENT.
C
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     ************

      INTEGER I
      DOUBLE PRECISION GI
      DOUBLE PRECISION ONE,ZERO
      PARAMETER        (ONE=1.0D0,ZERO=0.0D0)

      SBGNRM = ZERO
      DO 15 I = 1, N
        GI = G(I)
        IF (NBD(I) .NE. 0) THEN
           IF (GI .LT. ZERO) THEN
              IF (NBD(I) .GE. 2) GI = MAX((X(I)-U(I)),GI)
           ELSE
              IF (NBD(I) .LE. 2) GI = MIN((X(I)-L(I)),GI)
           ENDIF
        ENDIF
        SBGNRM = MAX(SBGNRM,ABS(GI))
  15  CONTINUE

      RETURN

      END

C======================= THE END OF PROJGR =============================

      SUBROUTINE SUBSM ( N, M, NSUB, IND, L, U, NBD, X, D, XP, WS, WY,
     +                   THETA, XX, GG,
     +                   COL, HEAD, IWORD, WV, WN, IPRINT, INFO )
      IMPLICIT NONE
      INTEGER          N, M, NSUB, COL, HEAD, IWORD, IPRINT, INFO, 
     +                 IND(NSUB), NBD(N)
      DOUBLE PRECISION THETA, 
     +                 L(N), U(N), X(N), D(N), XP(N), XX(N), GG(N),
     +                 WS(N, M), WY(N, M), 
     +                 WV(2*M), WN(2*M, 2*M)

C     **********************************************************************
C
C     THIS ROUTINE CONTAINS THE MAJOR CHANGES IN THE UPDATED VERSION.
C     THE CHANGES ARE DESCRIBED IN THE ACCOMPANYING PAPER
C
C      JOSE LUIS MORALES, JORGE NOCEDAL
C      "REMARK ON ALGORITHM 788: L-BFGS-B: FORTRAN SUBROUTINES FOR LARGE-SCALE
C       BOUND CONSTRAINED OPTIMIZATION". DECEMMBER 27, 2010.
C
C             J.L. MORALES  DEPARTAMENTO DE MATEMATICAS, 
C                           INSTITUTO TECNOLOGICO AUTONOMO DE MEXICO
C                           MEXICO D.F.
C
C             J, NOCEDAL    DEPARTMENT OF ELECTRICAL ENGINEERING AND
C                           COMPUTER SCIENCE.
C                           NORTHWESTERN UNIVERSITY. EVANSTON, IL. USA
C
C                           JANUARY 17, 2011
C
C      **********************************************************************
C                           
C
C     SUBROUTINE SUBSM
C
C     GIVEN XCP, L, U, R, AN INDEX SET THAT SPECIFIES
C       THE ACTIVE SET AT XCP, AND AN L-BFGS MATRIX B 
C       (IN TERMS OF WY, WS, SY, WT, HEAD, COL, AND THETA), 
C       THIS SUBROUTINE COMPUTES AN APPROXIMATE SOLUTION
C       OF THE SUBSPACE PROBLEM
C
C       (P)   MIN Q(X) = R'(X-XCP) + 1/2 (X-XCP)' B (X-XCP)
C
C             SUBJECT TO L<=X<=U
C                       X_I=XCP_I FOR ALL I IN A(XCP)
C                     
C       ALONG THE SUBSPACE UNCONSTRAINED NEWTON DIRECTION 
C       
C          D = -(Z'BZ)^(-1) R.
C
C       THE FORMULA FOR THE NEWTON DIRECTION, GIVEN THE L-BFGS MATRIX
C       AND THE SHERMAN-MORRISON FORMULA, IS
C
C          D = (1/THETA)R + (1/THETA*2) Z'WK^(-1)W'Z R.
C 
C       WHERE
C                 K = [-D -Y'ZZ'Y/THETA     L_A'-R_Z'  ]
C                     [L_A -R_Z           THETA*S'AA'S ]
C
C     NOTE THAT THIS PROCEDURE FOR COMPUTING D DIFFERS 
C     FROM THAT DESCRIBED IN [1]. ONE CAN SHOW THAT THE MATRIX K IS
C     EQUAL TO THE MATRIX M^[-1]N IN THAT PAPER.
C
C     N IS AN INTEGER VARIABLE.
C       ON ENTRY N IS THE DIMENSION OF THE PROBLEM.
C       ON EXIT N IS UNCHANGED.
C
C     M IS AN INTEGER VARIABLE.
C       ON ENTRY M IS THE MAXIMUM NUMBER OF VARIABLE METRIC CORRECTIONS
C         USED TO DEFINE THE LIMITED MEMORY MATRIX.
C       ON EXIT M IS UNCHANGED.
C
C     NSUB IS AN INTEGER VARIABLE.
C       ON ENTRY NSUB IS THE NUMBER OF FREE VARIABLES.
C       ON EXIT NSUB IS UNCHANGED.
C
C     IND IS AN INTEGER ARRAY OF DIMENSION NSUB.
C       ON ENTRY IND SPECIFIES THE COORDINATE INDICES OF FREE VARIABLES.
C       ON EXIT IND IS UNCHANGED.
C
C     L IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON ENTRY L IS THE LOWER BOUND OF X.
C       ON EXIT L IS UNCHANGED.
C
C     U IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON ENTRY U IS THE UPPER BOUND OF X.
C       ON EXIT U IS UNCHANGED.
C
C     NBD IS A INTEGER ARRAY OF DIMENSION N.
C       ON ENTRY NBD REPRESENTS THE TYPE OF BOUNDS IMPOSED ON THE
C         VARIABLES, AND MUST BE SPECIFIED AS FOLLOWS:
C         NBD(I)=0 IF X(I) IS UNBOUNDED,
C                1 IF X(I) HAS ONLY A LOWER BOUND,
C                2 IF X(I) HAS BOTH LOWER AND UPPER BOUNDS, AND
C                3 IF X(I) HAS ONLY AN UPPER BOUND.
C       ON EXIT NBD IS UNCHANGED.
C
C     X IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON ENTRY X SPECIFIES THE CAUCHY POINT XCP. 
C       ON EXIT X(I) IS THE MINIMIZER OF Q OVER THE SUBSPACE OF
C                                                        FREE VARIABLES. 
C
C     D IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       ON ENTRY D IS THE REDUCED GRADIENT OF Q AT XCP.
C       ON EXIT D IS THE NEWTON DIRECTION OF Q. 
C
C    XP IS A DOUBLE PRECISION ARRAY OF DIMENSION N.
C       USED TO SAFEGUARD THE PROJECTED NEWTON DIRECTION 
C
C    XX IS A DOUBLE PRECISION ARRAY OF DIMENSION N
C       ON ENTRY IT HOLDS THE CURRENT ITERATE
C       ON OUTPUT IT IS UNCHANGED

C    GG IS A DOUBLE PRECISION ARRAY OF DIMENSION N
C       ON ENTRY IT HOLDS THE GRADIENT AT THE CURRENT ITERATE
C       ON OUTPUT IT IS UNCHANGED
C
C     WS AND WY ARE DOUBLE PRECISION ARRAYS;
C     THETA IS A DOUBLE PRECISION VARIABLE;
C     COL IS AN INTEGER VARIABLE;
C     HEAD IS AN INTEGER VARIABLE.
C       ON ENTRY THEY STORE THE INFORMATION DEFINING THE
C                                          LIMITED MEMORY BFGS MATRIX:
C         WS(N,M) STORES S, A SET OF S-VECTORS;
C         WY(N,M) STORES Y, A SET OF Y-VECTORS;
C         THETA IS THE SCALING FACTOR SPECIFYING B_0 = THETA I;
C         COL IS THE NUMBER OF VARIABLE METRIC CORRECTIONS STORED;
C         HEAD IS THE LOCATION OF THE 1ST S- (OR Y-) VECTOR IN S (OR Y).
C       ON EXIT THEY ARE UNCHANGED.
C
C     IWORD IS AN INTEGER VARIABLE.
C       ON ENTRY IWORD IS UNSPECIFIED.
C       ON EXIT IWORD SPECIFIES THE STATUS OF THE SUBSPACE SOLUTION.
C         IWORD = 0 IF THE SOLUTION IS IN THE BOX,
C                 1 IF SOME BOUND IS ENCOUNTERED.
C
C     WV IS A DOUBLE PRECISION WORKING ARRAY OF DIMENSION 2M.
C
C     WN IS A DOUBLE PRECISION ARRAY OF DIMENSION 2M X 2M.
C       ON ENTRY THE UPPER TRIANGLE OF WN STORES THE LEL^T FACTORIZATION
C         OF THE INDEFINITE MATRIX
C
C              K = [-D -Y'ZZ'Y/THETA     L_A'-R_Z'  ]
C                  [L_A -R_Z           THETA*S'AA'S ]
C                                                    WHERE E = [-I  0]
C                                                              [ 0  I]
C       ON EXIT WN IS UNCHANGED.
C
C     IPRINT IS AN INTEGER VARIABLE THAT MUST BE SET BY THE USER.
C       IT CONTROLS THE FREQUENCY AND TYPE OF OUTPUT GENERATED:
C        IPRINT<0    NO OUTPUT IS GENERATED;
C        IPRINT=0    PRINT ONLY ONE LINE AT THE LAST ITERATION;
C        0<IPRINT<99 PRINT ALSO F AND |PROJ G| EVERY IPRINT ITERATIONS;
C        IPRINT=99   PRINT DETAILS OF EVERY ITERATION EXCEPT N-VECTORS;
C        IPRINT=100  PRINT ALSO THE CHANGES OF ACTIVE SET AND FINAL X;
C        IPRINT>100  PRINT DETAILS OF EVERY ITERATION INCLUDING X AND G;
C       WHEN IPRINT > 0, THE FILE ITERATE.DAT WILL BE CREATED TO
C                        SUMMARIZE THE ITERATION.
C
C     INFO IS AN INTEGER VARIABLE.
C       ON ENTRY INFO IS UNSPECIFIED.
C       ON EXIT INFO = 0       FOR NORMAL RETURN,
C                    = NONZERO FOR ABNORMAL RETURN 
C                                  WHEN THE MATRIX K IS ILL-CONDITIONED.
C
C     SUBPROGRAMS CALLED:
C
C       LINPACK DTRSL.
C
C
C     REFERENCES:
C
C       [1] R. H. BYRD, P. LU, J. NOCEDAL AND C. ZHU, ``A LIMITED
C       MEMORY ALGORITHM FOR BOUND CONSTRAINED OPTIMIZATION'',
C       SIAM J. SCIENTIFIC COMPUTING 16 (1995), NO. 5, PP. 1190--1208.
C
C
C
C                           *  *  *
C
C     NEOS, NOVEMBER 1994. (LATEST REVISION JUNE 1996.)
C     OPTIMIZATION TECHNOLOGY CENTER.
C     ARGONNE NATIONAL LABORATORY AND NORTHWESTERN UNIVERSITY.
C     WRITTEN BY
C                        CIYOU ZHU
C     IN COLLABORATION WITH R.H. BYRD, P. LU-CHEN AND J. NOCEDAL.
C
C
C     ************

      INTEGER          POINTR,M2,COL2,IBD,JY,JS,I,J,K
      DOUBLE PRECISION ALPHA, XK, DK, TEMP1, TEMP2 
      DOUBLE PRECISION ONE,ZERO
      PARAMETER        (ONE=1.0D0,ZERO=0.0D0)
C
      DOUBLE PRECISION DD_P

      IF (NSUB .LE. 0) RETURN
      IF (IPRINT .GE. 99) WRITE (6,1001)

C     COMPUTE WV = W'ZD.

      POINTR = HEAD 
      DO 20 I = 1, COL
         TEMP1 = ZERO
         TEMP2 = ZERO
         DO 10 J = 1, NSUB
            K = IND(J)
            TEMP1 = TEMP1 + WY(K,POINTR)*D(J)
            TEMP2 = TEMP2 + WS(K,POINTR)*D(J)
  10     CONTINUE
         WV(I) = TEMP1
         WV(COL + I) = THETA*TEMP2
         POINTR = MOD(POINTR,M) + 1
  20  CONTINUE
 
C     COMPUTE WV:=K^(-1)WV.

      M2 = 2*M
      COL2 = 2*COL
      CALL DTRSL(WN,M2,COL2,WV,11,INFO)
      IF (INFO .NE. 0) RETURN
      DO 25 I = 1, COL
         WV(I) = -WV(I)
  25     CONTINUE
      CALL DTRSL(WN,M2,COL2,WV,01,INFO)
      IF (INFO .NE. 0) RETURN
 
C     COMPUTE D = (1/THETA)D + (1/THETA**2)Z'W WV.
 
      POINTR = HEAD
      DO 40 JY = 1, COL
         JS = COL + JY
         DO 30 I = 1, NSUB
            K = IND(I)
            D(I) = D(I) + WY(K,POINTR)*WV(JY)/THETA     
     +                  + WS(K,POINTR)*WV(JS)
  30     CONTINUE
         POINTR = MOD(POINTR,M) + 1
  40  CONTINUE

      CALL DSCAL( NSUB, ONE/THETA, D, 1 )
C 
C-----------------------------------------------------------------
C     LET US TRY THE PROJECTION, D IS THE NEWTON DIRECTION

      IWORD = 0

      CALL DCOPY ( N, X, 1, XP, 1 )
C
      DO 50 I=1, NSUB
         K  = IND(I)
         DK = D(I)
         XK = X(K)
         IF ( NBD(K) .NE. 0 ) THEN
C
            IF ( NBD(K).EQ.1 ) THEN          ! LOWER BOUNDS ONLY
               X(K) = MAX( L(K), XK + DK )
               IF ( X(K).EQ.L(K) ) IWORD = 1
            ELSE 
C     
               IF ( NBD(K).EQ.2 ) THEN       ! UPPER AND LOWER BOUNDS
                  XK   = MAX( L(K), XK + DK ) 
                  X(K) = MIN( U(K), XK )
                  IF ( X(K).EQ.L(K) .OR. X(K).EQ.U(K) ) IWORD = 1
               ELSE
C
                  IF ( NBD(K).EQ.3 ) THEN    ! UPPER BOUNDS ONLY
                     X(K) = MIN( U(K), XK + DK )
                     IF ( X(K).EQ.U(K) ) IWORD = 1
                  END IF 
               END IF
            END IF
C            
         ELSE                                ! FREE VARIABLES
            X(K) = XK + DK
         END IF 
 50   CONTINUE
C
      IF ( IWORD.EQ.0 ) THEN
         GO TO 911
      END IF
C
C     CHECK SIGN OF THE DIRECTIONAL DERIVATIVE
C
      DD_P = ZERO
      DO 55 I=1, N
         DD_P  = DD_P + (X(I) - XX(I))*GG(I)
 55   CONTINUE
      IF ( DD_P .GT.ZERO ) THEN
         CALL DCOPY( N, XP, 1, X, 1 )
         WRITE(6,*) ' POSITIVE DIR DERIVATIVE IN PROJECTION '
         WRITE(6,*) ' USING THE BACKTRACKING STEP '
      ELSE
         GO TO 911
      ENDIF
C
C-----------------------------------------------------------------
C
      ALPHA = ONE
      TEMP1 = ALPHA
      IBD   = 0 
      DO 60 I = 1, NSUB
         K = IND(I)
         DK = D(I)
         IF (NBD(K) .NE. 0) THEN
            IF (DK .LT. ZERO .AND. NBD(K) .LE. 2) THEN
               TEMP2 = L(K) - X(K)
               IF (TEMP2 .GE. ZERO) THEN
                  TEMP1 = ZERO
               ELSE IF (DK*ALPHA .LT. TEMP2) THEN
                  TEMP1 = TEMP2/DK
               ENDIF
            ELSE IF (DK .GT. ZERO .AND. NBD(K) .GE. 2) THEN
               TEMP2 = U(K) - X(K)
               IF (TEMP2 .LE. ZERO) THEN
                  TEMP1 = ZERO
               ELSE IF (DK*ALPHA .GT. TEMP2) THEN
                  TEMP1 = TEMP2/DK
               ENDIF
            ENDIF
            IF (TEMP1 .LT. ALPHA) THEN
               ALPHA = TEMP1
               IBD = I
            ENDIF
         ENDIF
 60   CONTINUE
      
      IF (ALPHA .LT. ONE) THEN
         DK = D(IBD)
         K = IND(IBD)
         IF (DK .GT. ZERO) THEN
            X(K) = U(K)
            D(IBD) = ZERO
         ELSE IF (DK .LT. ZERO) THEN
            X(K) = L(K)
            D(IBD) = ZERO
         ENDIF
      ENDIF
      DO 70 I = 1, NSUB
         K    = IND(I)
         X(K) = X(K) + ALPHA*D(I)
 70   CONTINUE
CCCCCC
 911  CONTINUE

      IF (IPRINT .GE. 99) WRITE (6,1004)

 1001 FORMAT (/,'----------------SUBSM ENTERED-----------------',/)
 1004 FORMAT (/,'----------------EXIT SUBSM --------------------',/)

      RETURN

      END
C====================== THE END OF SUBSM ===============================

      SUBROUTINE DCSRCH(F,G,STP,FTOL,GTOL,XTOL,STPMIN,STPMAX,
     +                  TASK,ISAVE,DSAVE)
      CHARACTER*(*) TASK
      INTEGER ISAVE(2)
      DOUBLE PRECISION F,G,STP,FTOL,GTOL,XTOL,STPMIN,STPMAX
      DOUBLE PRECISION DSAVE(13)
C     **********
C
C     SUBROUTINE DCSRCH
C
C     THIS SUBROUTINE FINDS A STEP THAT SATISFIES A SUFFICIENT
C     DECREASE CONDITION AND A CURVATURE CONDITION.
C
C     EACH CALL OF THE SUBROUTINE UPDATES AN INTERVAL WITH 
C     ENDPOINTS STX AND STY. THE INTERVAL IS INITIALLY CHOSEN 
C     SO THAT IT CONTAINS A MINIMIZER OF THE MODIFIED FUNCTION
C
C           PSI(STP) = F(STP) - F(0) - FTOL*STP*F'(0).
C
C     IF PSI(STP) <= 0 AND F'(STP) >= 0 FOR SOME STEP, THEN THE
C     INTERVAL IS CHOSEN SO THAT IT CONTAINS A MINIMIZER OF F. 
C
C     THE ALGORITHM IS DESIGNED TO FIND A STEP THAT SATISFIES 
C     THE SUFFICIENT DECREASE CONDITION 
C
C           F(STP) <= F(0) + FTOL*STP*F'(0),
C
C     AND THE CURVATURE CONDITION
C
C           ABS(F'(STP)) <= GTOL*ABS(F'(0)).
C
C     IF FTOL IS LESS THAN GTOL AND IF, FOR EXAMPLE, THE FUNCTION
C     IS BOUNDED BELOW, THEN THERE IS ALWAYS A STEP WHICH SATISFIES
C     BOTH CONDITIONS. 
C
C     IF NO STEP CAN BE FOUND THAT SATISFIES BOTH CONDITIONS, THEN 
C     THE ALGORITHM STOPS WITH A WARNING. IN THIS CASE STP ONLY 
C     SATISFIES THE SUFFICIENT DECREASE CONDITION.
C
C     A TYPICAL INVOCATION OF DCSRCH HAS THE FOLLOWING OUTLINE:
C
C     TASK = 'START'
C  10 CONTINUE
C        CALL DCSRCH( ... )
C        IF (TASK .EQ. 'FG') THEN
C           EVALUATE THE FUNCTION AND THE GRADIENT AT STP 
C           GOTO 10
C           END IF
C
C     NOTE: THE USER MUST NO ALTER WORK ARRAYS BETWEEN CALLS.
C
C     THE SUBROUTINE STATEMENT IS
C
C        SUBROUTINE DCSRCH(F,G,STP,FTOL,GTOL,XTOL,STPMIN,STPMAX,
C                          TASK,ISAVE,DSAVE)
C     WHERE
C
C       F IS A DOUBLE PRECISION VARIABLE.
C         ON INITIAL ENTRY F IS THE VALUE OF THE FUNCTION AT 0.
C            ON SUBSEQUENT ENTRIES F IS THE VALUE OF THE 
C            FUNCTION AT STP.
C         ON EXIT F IS THE VALUE OF THE FUNCTION AT STP.
C
C       G IS A DOUBLE PRECISION VARIABLE.
C         ON INITIAL ENTRY G IS THE DERIVATIVE OF THE FUNCTION AT 0.
C            ON SUBSEQUENT ENTRIES G IS THE DERIVATIVE OF THE 
C            FUNCTION AT STP.
C         ON EXIT G IS THE DERIVATIVE OF THE FUNCTION AT STP.
C
C       STP IS A DOUBLE PRECISION VARIABLE. 
C         ON ENTRY STP IS THE CURRENT ESTIMATE OF A SATISFACTORY 
C            STEP. ON INITIAL ENTRY, A POSITIVE INITIAL ESTIMATE 
C            MUST BE PROVIDED. 
C         ON EXIT STP IS THE CURRENT ESTIMATE OF A SATISFACTORY STEP
C            IF TASK = 'FG'. IF TASK = 'CONV' THEN STP SATISFIES
C            THE SUFFICIENT DECREASE AND CURVATURE CONDITION.
C
C       FTOL IS A DOUBLE PRECISION VARIABLE.
C         ON ENTRY FTOL SPECIFIES A NONNEGATIVE TOLERANCE FOR THE 
C            SUFFICIENT DECREASE CONDITION.
C         ON EXIT FTOL IS UNCHANGED.
C
C       GTOL IS A DOUBLE PRECISION VARIABLE.
C         ON ENTRY GTOL SPECIFIES A NONNEGATIVE TOLERANCE FOR THE 
C            CURVATURE CONDITION. 
C         ON EXIT GTOL IS UNCHANGED.
C
C       XTOL IS A DOUBLE PRECISION VARIABLE.
C         ON ENTRY XTOL SPECIFIES A NONNEGATIVE RELATIVE TOLERANCE
C            FOR AN ACCEPTABLE STEP. THE SUBROUTINE EXITS WITH A
C            WARNING IF THE RELATIVE DIFFERENCE BETWEEN STY AND STX
C            IS LESS THAN XTOL.
C         ON EXIT XTOL IS UNCHANGED.
C
C       STPMIN IS A DOUBLE PRECISION VARIABLE.
C         ON ENTRY STPMIN IS A NONNEGATIVE LOWER BOUND FOR THE STEP.
C         ON EXIT STPMIN IS UNCHANGED.
C
C       STPMAX IS A DOUBLE PRECISION VARIABLE.
C         ON ENTRY STPMAX IS A NONNEGATIVE UPPER BOUND FOR THE STEP.
C         ON EXIT STPMAX IS UNCHANGED.
C
C       TASK IS A CHARACTER VARIABLE OF LENGTH AT LEAST 60.
C         ON INITIAL ENTRY TASK MUST BE SET TO 'START'.
C         ON EXIT TASK INDICATES THE REQUIRED ACTION:
C
C            IF TASK(1:2) = 'FG' THEN EVALUATE THE FUNCTION AND 
C            DERIVATIVE AT STP AND CALL DCSRCH AGAIN.
C
C            IF TASK(1:4) = 'CONV' THEN THE SEARCH IS SUCCESSFUL.
C
C            IF TASK(1:4) = 'WARN' THEN THE SUBROUTINE IS NOT ABLE
C            TO SATISFY THE CONVERGENCE CONDITIONS. THE EXIT VALUE OF
C            STP CONTAINS THE BEST POINT FOUND DURING THE SEARCH.
C
C            IF TASK(1:5) = 'ERROR' THEN THERE IS AN ERROR IN THE
C            INPUT ARGUMENTS.
C
C         ON EXIT WITH CONVERGENCE, A WARNING OR AN ERROR, THE
C            VARIABLE TASK CONTAINS ADDITIONAL INFORMATION.
C
C       ISAVE IS AN INTEGER WORK ARRAY OF DIMENSION 2.
C         
C       DSAVE IS A DOUBLE PRECISION WORK ARRAY OF DIMENSION 13.
C
C     SUBPROGRAMS CALLED
C
C       MINPACK-2 ... DCSTEP
C
C     MINPACK-1 PROJECT. JUNE 1983.
C     ARGONNE NATIONAL LABORATORY. 
C     JORGE J. MORE' AND DAVID J. THUENTE.
C
C     MINPACK-2 PROJECT. OCTOBER 1993.
C     ARGONNE NATIONAL LABORATORY AND UNIVERSITY OF MINNESOTA. 
C     BRETT M. AVERICK, RICHARD G. CARTER, AND JORGE J. MORE'. 
C
C     **********
      DOUBLE PRECISION ZERO,P5,P66
      PARAMETER(ZERO=0.0D0,P5=0.5D0,P66=0.66D0)
      DOUBLE PRECISION XTRAPL,XTRAPU
      PARAMETER(XTRAPL=1.1D0,XTRAPU=4.0D0)

      LOGICAL BRACKT
      INTEGER STAGE
      DOUBLE PRECISION FINIT,FTEST,FM,FX,FXM,FY,FYM,GINIT,GTEST,
     +       GM,GX,GXM,GY,GYM,STX,STY,STMIN,STMAX,WIDTH,WIDTH1

C     INITIALIZATION BLOCK.

      IF (TASK(1:5) .EQ. 'START') THEN

C        CHECK THE INPUT ARGUMENTS FOR ERRORS.

         IF (STP .LT. STPMIN) TASK = 'ERROR: STP .LT. STPMIN'
         IF (STP .GT. STPMAX) TASK = 'ERROR: STP .GT. STPMAX'
         IF (G .GE. ZERO) TASK = 'ERROR: INITIAL G .GE. ZERO'
         IF (FTOL .LT. ZERO) TASK = 'ERROR: FTOL .LT. ZERO'
         IF (GTOL .LT. ZERO) TASK = 'ERROR: GTOL .LT. ZERO'
         IF (XTOL .LT. ZERO) TASK = 'ERROR: XTOL .LT. ZERO'
         IF (STPMIN .LT. ZERO) TASK = 'ERROR: STPMIN .LT. ZERO'
         IF (STPMAX .LT. STPMIN) TASK = 'ERROR: STPMAX .LT. STPMIN'

C        EXIT IF THERE ARE ERRORS ON INPUT.

         IF (TASK(1:5) .EQ. 'ERROR') RETURN

C        INITIALIZE LOCAL VARIABLES.

         BRACKT = .FALSE.
         STAGE = 1
         FINIT = F
         GINIT = G
         GTEST = FTOL*GINIT
         WIDTH = STPMAX - STPMIN
         WIDTH1 = WIDTH/P5

C        THE VARIABLES STX, FX, GX CONTAIN THE VALUES OF THE STEP, 
C        FUNCTION, AND DERIVATIVE AT THE BEST STEP. 
C        THE VARIABLES STY, FY, GY CONTAIN THE VALUE OF THE STEP, 
C        FUNCTION, AND DERIVATIVE AT STY.
C        THE VARIABLES STP, F, G CONTAIN THE VALUES OF THE STEP, 
C        FUNCTION, AND DERIVATIVE AT STP.

         STX = ZERO
         FX = FINIT
         GX = GINIT
         STY = ZERO
         FY = FINIT
         GY = GINIT
         STMIN = ZERO
         STMAX = STP + XTRAPU*STP
         TASK = 'FG'

         GOTO 1000

      ELSE

C        RESTORE LOCAL VARIABLES.

         IF (ISAVE(1) .EQ. 1) THEN
            BRACKT = .TRUE.
         ELSE
            BRACKT = .FALSE.
         ENDIF
         STAGE = ISAVE(2) 
         GINIT = DSAVE(1) 
         GTEST = DSAVE(2) 
         GX = DSAVE(3) 
         GY = DSAVE(4) 
         FINIT = DSAVE(5) 
         FX = DSAVE(6) 
         FY = DSAVE(7) 
         STX = DSAVE(8) 
         STY = DSAVE(9) 
         STMIN = DSAVE(10) 
         STMAX = DSAVE(11) 
         WIDTH = DSAVE(12) 
         WIDTH1 = DSAVE(13) 

      ENDIF

C     IF PSI(STP) <= 0 AND F'(STP) >= 0 FOR SOME STEP, THEN THE
C     ALGORITHM ENTERS THE SECOND STAGE.

      FTEST = FINIT + STP*GTEST
      IF (STAGE .EQ. 1 .AND. F .LE. FTEST .AND. G .GE. ZERO) 
     +   STAGE = 2

C     TEST FOR WARNINGS.

      IF (BRACKT .AND. (STP .LE. STMIN .OR. STP .GE. STMAX))
     +   TASK = 'WARNING: ROUNDING ERRORS PREVENT PROGRESS'
      IF (BRACKT .AND. STMAX - STMIN .LE. XTOL*STMAX) 
     +   TASK = 'WARNING: XTOL TEST SATISFIED'
      IF (STP .EQ. STPMAX .AND. F .LE. FTEST .AND. G .LE. GTEST) 
     +   TASK = 'WARNING: STP = STPMAX'
      IF (STP .EQ. STPMIN .AND. (F .GT. FTEST .OR. G .GE. GTEST)) 
     +   TASK = 'WARNING: STP = STPMIN'

C     TEST FOR CONVERGENCE.

      IF (F .LE. FTEST .AND. ABS(G) .LE. GTOL*(-GINIT)) 
     +   TASK = 'CONVERGENCE'

C     TEST FOR TERMINATION.

      IF (TASK(1:4) .EQ. 'WARN' .OR. TASK(1:4) .EQ. 'CONV') GOTO 1000

C     A MODIFIED FUNCTION IS USED TO PREDICT THE STEP DURING THE
C     FIRST STAGE IF A LOWER FUNCTION VALUE HAS BEEN OBTAINED BUT 
C     THE DECREASE IS NOT SUFFICIENT.

      IF (STAGE .EQ. 1 .AND. F .LE. FX .AND. F .GT. FTEST) THEN

C        DEFINE THE MODIFIED FUNCTION AND DERIVATIVE VALUES.

         FM = F - STP*GTEST
         FXM = FX - STX*GTEST
         FYM = FY - STY*GTEST
         GM = G - GTEST
         GXM = GX - GTEST
         GYM = GY - GTEST

C        CALL DCSTEP TO UPDATE STX, STY, AND TO COMPUTE THE NEW STEP.

         CALL DCSTEP(STX,FXM,GXM,STY,FYM,GYM,STP,FM,GM,
     +               BRACKT,STMIN,STMAX)

C        RESET THE FUNCTION AND DERIVATIVE VALUES FOR F.

         FX = FXM + STX*GTEST
         FY = FYM + STY*GTEST
         GX = GXM + GTEST
         GY = GYM + GTEST

      ELSE

C       CALL DCSTEP TO UPDATE STX, STY, AND TO COMPUTE THE NEW STEP.

        CALL DCSTEP(STX,FX,GX,STY,FY,GY,STP,F,G,
     +              BRACKT,STMIN,STMAX)

      ENDIF

C     DECIDE IF A BISECTION STEP IS NEEDED.

      IF (BRACKT) THEN
         IF (ABS(STY-STX) .GE. P66*WIDTH1) STP = STX + P5*(STY - STX)
         WIDTH1 = WIDTH
         WIDTH = ABS(STY-STX)
      ENDIF

C     SET THE MINIMUM AND MAXIMUM STEPS ALLOWED FOR STP.

      IF (BRACKT) THEN
         STMIN = MIN(STX,STY)
         STMAX = MAX(STX,STY)
      ELSE
         STMIN = STP + XTRAPL*(STP - STX)
         STMAX = STP + XTRAPU*(STP - STX)
      ENDIF
 
C     FORCE THE STEP TO BE WITHIN THE BOUNDS STPMAX AND STPMIN.
 
      STP = MAX(STP,STPMIN)
      STP = MIN(STP,STPMAX)

C     IF FURTHER PROGRESS IS NOT POSSIBLE, LET STP BE THE BEST
C     POINT OBTAINED DURING THE SEARCH.

      IF (BRACKT .AND. (STP .LE. STMIN .OR. STP .GE. STMAX)
     +   .OR. (BRACKT .AND. STMAX-STMIN .LE. XTOL*STMAX)) STP = STX

C     OBTAIN ANOTHER FUNCTION AND DERIVATIVE.

      TASK = 'FG'

 1000 CONTINUE

C     SAVE LOCAL VARIABLES.

      IF (BRACKT) THEN
         ISAVE(1) = 1
      ELSE
         ISAVE(1) = 0
      ENDIF
      ISAVE(2) = STAGE
      DSAVE(1) =  GINIT
      DSAVE(2) =  GTEST
      DSAVE(3) =  GX
      DSAVE(4) =  GY
      DSAVE(5) =  FINIT
      DSAVE(6) =  FX
      DSAVE(7) =  FY
      DSAVE(8) =  STX
      DSAVE(9) =  STY
      DSAVE(10) = STMIN
      DSAVE(11) = STMAX
      DSAVE(12) = WIDTH
      DSAVE(13) = WIDTH1

      RETURN
      END
      
C====================== THE END OF DCSRCH ==============================

      SUBROUTINE DCSTEP(STX,FX,DX,STY,FY,DY,STP,FP,DP,BRACKT,
     +                  STPMIN,STPMAX)
      LOGICAL BRACKT
      DOUBLE PRECISION STX,FX,DX,STY,FY,DY,STP,FP,DP,STPMIN,STPMAX
C     **********
C
C     SUBROUTINE DCSTEP
C
C     THIS SUBROUTINE COMPUTES A SAFEGUARDED STEP FOR A SEARCH
C     PROCEDURE AND UPDATES AN INTERVAL THAT CONTAINS A STEP THAT
C     SATISFIES A SUFFICIENT DECREASE AND A CURVATURE CONDITION.
C
C     THE PARAMETER STX CONTAINS THE STEP WITH THE LEAST FUNCTION
C     VALUE. IF BRACKT IS SET TO .TRUE. THEN A MINIMIZER HAS
C     BEEN BRACKETED IN AN INTERVAL WITH ENDPOINTS STX AND STY.
C     THE PARAMETER STP CONTAINS THE CURRENT STEP. 
C     THE SUBROUTINE ASSUMES THAT IF BRACKT IS SET TO .TRUE. THEN
C
C           MIN(STX,STY) < STP < MAX(STX,STY),
C
C     AND THAT THE DERIVATIVE AT STX IS NEGATIVE IN THE DIRECTION 
C     OF THE STEP.
C
C     THE SUBROUTINE STATEMENT IS
C
C       SUBROUTINE DCSTEP(STX,FX,DX,STY,FY,DY,STP,FP,DP,BRACKT,
C                         STPMIN,STPMAX)
C
C     WHERE
C
C       STX IS A DOUBLE PRECISION VARIABLE.
C         ON ENTRY STX IS THE BEST STEP OBTAINED SO FAR AND IS AN
C            ENDPOINT OF THE INTERVAL THAT CONTAINS THE MINIMIZER. 
C         ON EXIT STX IS THE UPDATED BEST STEP.
C
C       FX IS A DOUBLE PRECISION VARIABLE.
C         ON ENTRY FX IS THE FUNCTION AT STX.
C         ON EXIT FX IS THE FUNCTION AT STX.
C
C       DX IS A DOUBLE PRECISION VARIABLE.
C         ON ENTRY DX IS THE DERIVATIVE OF THE FUNCTION AT 
C            STX. THE DERIVATIVE MUST BE NEGATIVE IN THE DIRECTION OF 
C            THE STEP, THAT IS, DX AND STP - STX MUST HAVE OPPOSITE 
C            SIGNS.
C         ON EXIT DX IS THE DERIVATIVE OF THE FUNCTION AT STX.
C
C       STY IS A DOUBLE PRECISION VARIABLE.
C         ON ENTRY STY IS THE SECOND ENDPOINT OF THE INTERVAL THAT 
C            CONTAINS THE MINIMIZER.
C         ON EXIT STY IS THE UPDATED ENDPOINT OF THE INTERVAL THAT 
C            CONTAINS THE MINIMIZER.
C
C       FY IS A DOUBLE PRECISION VARIABLE.
C         ON ENTRY FY IS THE FUNCTION AT STY.
C         ON EXIT FY IS THE FUNCTION AT STY.
C
C       DY IS A DOUBLE PRECISION VARIABLE.
C         ON ENTRY DY IS THE DERIVATIVE OF THE FUNCTION AT STY.
C         ON EXIT DY IS THE DERIVATIVE OF THE FUNCTION AT THE EXIT STY.
C
C       STP IS A DOUBLE PRECISION VARIABLE.
C         ON ENTRY STP IS THE CURRENT STEP. IF BRACKT IS SET TO .TRUE.
C            THEN ON INPUT STP MUST BE BETWEEN STX AND STY. 
C         ON EXIT STP IS A NEW TRIAL STEP.
C
C       FP IS A DOUBLE PRECISION VARIABLE.
C         ON ENTRY FP IS THE FUNCTION AT STP
C         ON EXIT FP IS UNCHANGED.
C
C       DP IS A DOUBLE PRECISION VARIABLE.
C         ON ENTRY DP IS THE THE DERIVATIVE OF THE FUNCTION AT STP.
C         ON EXIT DP IS UNCHANGED.
C
C       BRACKT IS AN LOGICAL VARIABLE.
C         ON ENTRY BRACKT SPECIFIES IF A MINIMIZER HAS BEEN BRACKETED.
C            INITIALLY BRACKT MUST BE SET TO .FALSE.
C         ON EXIT BRACKT SPECIFIES IF A MINIMIZER HAS BEEN BRACKETED.
C            WHEN A MINIMIZER IS BRACKETED BRACKT IS SET TO .TRUE.
C
C       STPMIN IS A DOUBLE PRECISION VARIABLE.
C         ON ENTRY STPMIN IS A LOWER BOUND FOR THE STEP.
C         ON EXIT STPMIN IS UNCHANGED.
C
C       STPMAX IS A DOUBLE PRECISION VARIABLE.
C         ON ENTRY STPMAX IS AN UPPER BOUND FOR THE STEP.
C         ON EXIT STPMAX IS UNCHANGED.
C
C     MINPACK-1 PROJECT. JUNE 1983
C     ARGONNE NATIONAL LABORATORY. 
C     JORGE J. MORE' AND DAVID J. THUENTE.
C
C     MINPACK-2 PROJECT. OCTOBER 1993.
C     ARGONNE NATIONAL LABORATORY AND UNIVERSITY OF MINNESOTA. 
C     BRETT M. AVERICK AND JORGE J. MORE'.
C
C     **********
      DOUBLE PRECISION ZERO,P66,TWO,THREE
      PARAMETER(ZERO=0.0D0,P66=0.66D0,TWO=2.0D0,THREE=3.0D0)
   
      DOUBLE PRECISION GAMMA,P,Q,R,S,SGND,STPC,STPF,STPQ,THETA

      SGND = DP*(DX/ABS(DX))

C     FIRST CASE: A HIGHER FUNCTION VALUE. THE MINIMUM IS BRACKETED. 
C     IF THE CUBIC STEP IS CLOSER TO STX THAN THE QUADRATIC STEP, THE 
C     CUBIC STEP IS TAKEN, OTHERWISE THE AVERAGE OF THE CUBIC AND 
C     QUADRATIC STEPS IS TAKEN.

      IF (FP .GT. FX) THEN
         THETA = THREE*(FX - FP)/(STP - STX) + DX + DP
         S = MAX(ABS(THETA),ABS(DX),ABS(DP))
         GAMMA = S*SQRT((THETA/S)**2 - (DX/S)*(DP/S))
         IF (STP .LT. STX) GAMMA = -GAMMA
         P = (GAMMA - DX) + THETA
         Q = ((GAMMA - DX) + GAMMA) + DP
         R = P/Q
         STPC = STX + R*(STP - STX)
         STPQ = STX + ((DX/((FX - FP)/(STP - STX) + DX))/TWO)*
     +                                                       (STP - STX)
         IF (ABS(STPC-STX) .LT. ABS(STPQ-STX)) THEN
            STPF = STPC
         ELSE
            STPF = STPC + (STPQ - STPC)/TWO
         ENDIF
         BRACKT = .TRUE.

C     SECOND CASE: A LOWER FUNCTION VALUE AND DERIVATIVES OF OPPOSITE 
C     SIGN. THE MINIMUM IS BRACKETED. IF THE CUBIC STEP IS FARTHER FROM 
C     STP THAN THE SECANT STEP, THE CUBIC STEP IS TAKEN, OTHERWISE THE 
C     SECANT STEP IS TAKEN.

      ELSE IF (SGND .LT. ZERO) THEN
         THETA = THREE*(FX - FP)/(STP - STX) + DX + DP
         S = MAX(ABS(THETA),ABS(DX),ABS(DP))
         GAMMA = S*SQRT((THETA/S)**2 - (DX/S)*(DP/S))
         IF (STP .GT. STX) GAMMA = -GAMMA
         P = (GAMMA - DP) + THETA
         Q = ((GAMMA - DP) + GAMMA) + DX
         R = P/Q
         STPC = STP + R*(STX - STP)
         STPQ = STP + (DP/(DP - DX))*(STX - STP)
         IF (ABS(STPC-STP) .GT. ABS(STPQ-STP)) THEN
            STPF = STPC
         ELSE
            STPF = STPQ
         ENDIF
         BRACKT = .TRUE.

C     THIRD CASE: A LOWER FUNCTION VALUE, DERIVATIVES OF THE SAME SIGN,
C     AND THE MAGNITUDE OF THE DERIVATIVE DECREASES.

      ELSE IF (ABS(DP) .LT. ABS(DX)) THEN

C        THE CUBIC STEP IS COMPUTED ONLY IF THE CUBIC TENDS TO INFINITY 
C        IN THE DIRECTION OF THE STEP OR IF THE MINIMUM OF THE CUBIC
C        IS BEYOND STP. OTHERWISE THE CUBIC STEP IS DEFINED TO BE THE 
C        SECANT STEP.

         THETA = THREE*(FX - FP)/(STP - STX) + DX + DP
         S = MAX(ABS(THETA),ABS(DX),ABS(DP))

C        THE CASE GAMMA = 0 ONLY ARISES IF THE CUBIC DOES NOT TEND
C        TO INFINITY IN THE DIRECTION OF THE STEP.

         GAMMA = S*SQRT(MAX(ZERO,(THETA/S)**2-(DX/S)*(DP/S)))
         IF (STP .GT. STX) GAMMA = -GAMMA
         P = (GAMMA - DP) + THETA
         Q = (GAMMA + (DX - DP)) + GAMMA
         R = P/Q
         IF (R .LT. ZERO .AND. GAMMA .NE. ZERO) THEN
            STPC = STP + R*(STX - STP)
         ELSE IF (STP .GT. STX) THEN
            STPC = STPMAX
         ELSE
            STPC = STPMIN
         ENDIF
         STPQ = STP + (DP/(DP - DX))*(STX - STP)

         IF (BRACKT) THEN

C           A MINIMIZER HAS BEEN BRACKETED. IF THE CUBIC STEP IS 
C           CLOSER TO STP THAN THE SECANT STEP, THE CUBIC STEP IS 
C           TAKEN, OTHERWISE THE SECANT STEP IS TAKEN.

            IF (ABS(STPC-STP) .LT. ABS(STPQ-STP)) THEN
               STPF = STPC
            ELSE
               STPF = STPQ
            ENDIF
            IF (STP .GT. STX) THEN
               STPF = MIN(STP+P66*(STY-STP),STPF)
            ELSE
               STPF = MAX(STP+P66*(STY-STP),STPF)
            ENDIF
         ELSE

C           A MINIMIZER HAS NOT BEEN BRACKETED. IF THE CUBIC STEP IS 
C           FARTHER FROM STP THAN THE SECANT STEP, THE CUBIC STEP IS 
C           TAKEN, OTHERWISE THE SECANT STEP IS TAKEN.

            IF (ABS(STPC-STP) .GT. ABS(STPQ-STP)) THEN
               STPF = STPC
            ELSE
               STPF = STPQ
            ENDIF
            STPF = MIN(STPMAX,STPF)
            STPF = MAX(STPMIN,STPF)
         ENDIF

C     FOURTH CASE: A LOWER FUNCTION VALUE, DERIVATIVES OF THE SAME SIGN, 
C     AND THE MAGNITUDE OF THE DERIVATIVE DOES NOT DECREASE. IF THE 
C     MINIMUM IS NOT BRACKETED, THE STEP IS EITHER STPMIN OR STPMAX, 
C     OTHERWISE THE CUBIC STEP IS TAKEN.

      ELSE
         IF (BRACKT) THEN
            THETA = THREE*(FP - FY)/(STY - STP) + DY + DP
            S = MAX(ABS(THETA),ABS(DY),ABS(DP))
            GAMMA = S*SQRT((THETA/S)**2 - (DY/S)*(DP/S))
            IF (STP .GT. STY) GAMMA = -GAMMA
            P = (GAMMA - DP) + THETA
            Q = ((GAMMA - DP) + GAMMA) + DY
            R = P/Q
            STPC = STP + R*(STY - STP)
            STPF = STPC
         ELSE IF (STP .GT. STX) THEN
            STPF = STPMAX
         ELSE
            STPF = STPMIN
         ENDIF
      ENDIF

C     UPDATE THE INTERVAL WHICH CONTAINS A MINIMIZER.

      IF (FP .GT. FX) THEN
         STY = STP
         FY = FP
         DY = DP
      ELSE
         IF (SGND .LT. ZERO) THEN
            STY = STX
            FY = FX
            DY = DX
         ENDIF
         STX = STP
         FX = FP
         DX = DP
      ENDIF

C     COMPUTE THE NEW STEP.

      STP = STPF

      RETURN
      END
      
