from setuptools import setup

setup(
    name='bw2ui',
    version="0.8.1",
    packages=["bw2ui", "bw2ui.web"],
    package_data={'bw2ui.web': [
        "static/blueprint/*.css",
        "static/blueprint/plugins/buttons/*.css",
        "static/blueprint/plugins/fancy-type/*.css",
        "static/jqueryFileTree/*.css",
        "static/jqueryFileTree/*.js",
        "static/jqueryFileTree/images/*.png",
        "static/jqueryFileTree/images/*.gif",
        "static/backgrid/*.js",
        "static/backgrid/*.css",
        "static/jsoneditor/*.css",
        "static/jsoneditor/*.js",
        "static/jsoneditor/*.png",
        "static/img/*.png",
        "static/img/*.ico",
        "static/img/*.jpg",
        "static/js/*.js",
        "static/css/*.css",
        "templates/*.html",
    ]},
    author="Chris Mutel",
    author_email="cmutel@gmail.com",
    license=open('LICENSE.txt').read(),
    install_requires=["brightway2>=0.10"],
    scripts=["bw2ui/bin/bw2-web.py", "bw2ui/bin/bw2-controller.py"],
    url="https://bitbucket.org/cmutel/brightway2-ui",
    long_description=open('README.rst').read(),
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: End Users/Desktop',
        'Intended Audience :: Developers',
        'Intended Audience :: Science/Research',
        'License :: OSI Approved :: BSD License',
        'Operating System :: MacOS :: MacOS X',
        'Operating System :: Microsoft :: Windows',
        'Operating System :: POSIX',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 2 :: Only',
        'Topic :: Scientific/Engineering :: Information Analysis',
        'Topic :: Scientific/Engineering :: Mathematics',
        'Topic :: Scientific/Engineering :: Visualization',
    ],
)
