from setuptools import setup

setup(
  name='bw2webreports',
  version="0.2",
  packages=["bw2webreports"],
  package_data={'bw2webreports': [
    "static/blueprint/*.css",
    "static/blueprint/plugins/buttons/*.css",
    "static/blueprint/plugins/fancy-type/*.css",
    "static/img/*.png",
    "static/img/*.ico",
    "static/img/*.jpg",
    "static/js/*.js",
    "static/css/*.css",
    "templates/*.html",
    ]},
  author="Chris Mutel",
  author_email="cmutel@gmail.com",
  license=open('LICENSE.txt').read(),
  install_requires=["docopt", "flask"],
  scripts=["bw2webreports/bin/bw2-report-server.py"],
  url="https://bitbucket.org/cmutel/brightway2-web-reports",
  long_description=open('README.rst').read(),
  classifiers=[
    'Development Status :: 3 - Alpha',
    'Intended Audience :: End Users/Desktop',
    'Intended Audience :: Developers',
    'Intended Audience :: Science/Research',
    'License :: OSI Approved :: BSD License',
    'Operating System :: MacOS :: MacOS X',
    'Operating System :: Microsoft :: Windows',
    'Operating System :: POSIX',
    'Programming Language :: Python',
    'Programming Language :: Python :: 2.7',
    'Programming Language :: Python :: 2 :: Only',
    'Topic :: Scientific/Engineering :: Information Analysis',
    'Topic :: Scientific/Engineering :: Mathematics',
    'Topic :: Scientific/Engineering :: Visualization',
    ],
)
