/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdf.extractor.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;

public final class BTreeSet
extends AbstractSet
implements Set {
    public BTreeNode root;
    private Comparator comparator = null;
    int order;
    int size = 0;

    public BTreeSet() {
        this(6);
    }

    public BTreeSet(Collection c) {
        this(6);
        this.addAll(c);
    }

    public BTreeSet(int order) {
        this(order, null);
    }

    public BTreeSet(int order, Comparator comparator) {
        this.order = order;
        this.comparator = comparator;
        this.root = new BTreeNode(null);
    }

    public boolean add(Object x) throws IllegalArgumentException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        return this.root.insert(x, -1);
    }

    public boolean contains(Object x) {
        return this.root.includes(x);
    }

    public boolean remove(Object x) {
        if (x == null) {
            return false;
        }
        return this.root.delete(x, -1);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.root = new BTreeNode(null);
        this.size = 0;
    }

    public Iterator iterator() {
        return new BTIterator();
    }

    int compare(Object x, Object y) {
        return this.comparator == null ? ((Comparable)x).compareTo(y) : this.comparator.compare(x, y);
    }

    public class BTreeNode {
        public Entry[] _entries;
        public BTreeNode _parent;
        int _nrElements = 0;
        private final int MIN;

        BTreeNode(BTreeNode parent) {
            this.MIN = (BTreeSet.this.order - 1) / 2;
            this._parent = parent;
            this._entries = new Entry[BTreeSet.this.order];
            this._entries[0] = new Entry();
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean insert(Object x, int parentIndex) {
            if (this.isFull()) {
                Object splitNode = this._entries[this._nrElements / 2].element;
                BTreeNode rightSibling = this.split();
                if (!this.isRoot()) {
                    this._parent.insertSplitNode(splitNode, this, rightSibling, parentIndex);
                    if (BTreeSet.this.compare(x, this._parent._entries[parentIndex].element) >= 0) return rightSibling.insert(x, parentIndex + 1);
                    return this.insert(x, parentIndex);
                }
                this.splitRoot(splitNode, this, rightSibling);
                if (BTreeSet.this.compare(x, BTreeSet.this.root._entries[0].element) < 0) {
                    this.insert(x, 0);
                    return false;
                }
                rightSibling.insert(x, 1);
                return false;
            }
            if (this.isLeaf()) {
                int insertAt = this.childToInsertAt(x, true);
                if (insertAt == -1) {
                    return false;
                }
                this.insertNewElement(x, insertAt);
                ++BTreeSet.this.size;
                return true;
            }
            int insertAt = this.childToInsertAt(x, true);
            if (insertAt == -1) {
                return false;
            }
            boolean bl = this._entries[insertAt].child.insert(x, insertAt);
            return bl;
        }

        boolean includes(Object x) {
            int index = this.childToInsertAt(x, true);
            if (index == -1) {
                return true;
            }
            if (this._entries[index] == null || this._entries[index].child == null) {
                return false;
            }
            return this._entries[index].child.includes(x);
        }

        boolean delete(Object x, int parentIndex) {
            int i = this.childToInsertAt(x, true);
            int priorParentIndex = parentIndex;
            BTreeNode temp = this;
            if (i != -1) {
                do {
                    if (temp._entries[i] == null || temp._entries[i].child == null) {
                        return false;
                    }
                    temp = temp._entries[i].child;
                    priorParentIndex = parentIndex;
                    parentIndex = i;
                } while ((i = temp.childToInsertAt(x, true)) != -1);
            }
            if (temp.isLeaf()) {
                if (temp._nrElements > this.MIN) {
                    temp.deleteElement(x);
                    --BTreeSet.this.size;
                    return true;
                }
                temp.prepareForDeletion(parentIndex);
                temp.deleteElement(x);
                --BTreeSet.this.size;
                temp.fixAfterDeletion(priorParentIndex);
                return true;
            }
            temp.switchWithSuccessor(x);
            parentIndex = temp.childToInsertAt(x, false) + 1;
            return temp._entries[parentIndex].child.delete(x, parentIndex);
        }

        private boolean isFull() {
            return this._nrElements == BTreeSet.this.order - 1;
        }

        boolean isLeaf() {
            return this._entries[0].child == null;
        }

        private boolean isRoot() {
            return this._parent == null;
        }

        private BTreeNode split() {
            BTreeNode rightSibling = new BTreeNode(this._parent);
            int index = this._nrElements / 2;
            this._entries[index++].element = null;
            int i = 0;
            int nr = this._nrElements;
            while (index <= nr) {
                rightSibling._entries[i] = this._entries[index];
                if (rightSibling._entries[i] != null && rightSibling._entries[i].child != null) {
                    rightSibling._entries[i].child._parent = rightSibling;
                }
                this._entries[index] = null;
                --this._nrElements;
                ++rightSibling._nrElements;
                ++i;
                ++index;
            }
            --rightSibling._nrElements;
            return rightSibling;
        }

        private void splitRoot(Object splitNode, BTreeNode left, BTreeNode right) {
            BTreeNode newRoot = new BTreeNode(null);
            newRoot._entries[0].element = splitNode;
            newRoot._entries[0].child = left;
            newRoot._entries[1] = new Entry();
            newRoot._entries[1].child = right;
            newRoot._nrElements = 1;
            left._parent = right._parent = newRoot;
            BTreeSet.this.root = newRoot;
        }

        private void insertSplitNode(Object splitNode, BTreeNode left, BTreeNode right, int insertAt) {
            for (int i = this._nrElements; i >= insertAt; --i) {
                this._entries[i + 1] = this._entries[i];
            }
            this._entries[insertAt] = new Entry();
            this._entries[insertAt].element = splitNode;
            this._entries[insertAt].child = left;
            this._entries[insertAt + 1].child = right;
            ++this._nrElements;
        }

        private void insertNewElement(Object x, int insertAt) {
            for (int i = this._nrElements; i > insertAt; --i) {
                this._entries[i] = this._entries[i - 1];
            }
            this._entries[insertAt] = new Entry();
            this._entries[insertAt].element = x;
            ++this._nrElements;
        }

        private int childToInsertAt(Object x, boolean position) {
            int index = this._nrElements / 2;
            if (this._entries[index] == null || this._entries[index].element == null) {
                return index;
            }
            int lo = 0;
            int hi = this._nrElements - 1;
            while (lo <= hi) {
                if (BTreeSet.this.compare(x, this._entries[index].element) > 0) {
                    lo = index + 1;
                    index = (hi + lo) / 2;
                    continue;
                }
                hi = index - 1;
                index = (hi + lo) / 2;
            }
            if (this._entries[++hi] == null || this._entries[hi].element == null) {
                return hi;
            }
            return !position ? hi : (BTreeSet.this.compare(x, this._entries[hi].element) == 0 ? -1 : hi);
        }

        private void deleteElement(Object x) {
            for (int index = this.childToInsertAt(x, false); index < this._nrElements - 1; ++index) {
                this._entries[index] = this._entries[index + 1];
            }
            this._entries[index] = this._nrElements == 1 ? new Entry() : null;
            --this._nrElements;
        }

        private void prepareForDeletion(int parentIndex) {
            if (this.isRoot()) {
                return;
            }
            if (parentIndex != 0 && this._parent._entries[parentIndex - 1].child._nrElements > this.MIN) {
                this.stealLeft(parentIndex);
                return;
            }
            if (parentIndex < this._entries.length && this._parent._entries[parentIndex + 1] != null && this._parent._entries[parentIndex + 1].child != null && this._parent._entries[parentIndex + 1].child._nrElements > this.MIN) {
                this.stealRight(parentIndex);
                return;
            }
            if (parentIndex != 0) {
                this.mergeLeft(parentIndex);
                return;
            }
            this.mergeRight(parentIndex);
        }

        private void fixAfterDeletion(int parentIndex) {
            if (this.isRoot() || this._parent.isRoot()) {
                return;
            }
            if (this._parent._nrElements < this.MIN) {
                BTreeNode temp = this._parent;
                temp.prepareForDeletion(parentIndex);
                if (temp._parent == null) {
                    return;
                }
                if (!temp._parent.isRoot() && temp._parent._nrElements < this.MIN) {
                    int i;
                    BTreeNode x = temp._parent._parent;
                    for (i = 0; i < this._entries.length && x._entries[i].child != temp._parent; ++i) {
                    }
                    temp._parent.fixAfterDeletion(i);
                }
            }
        }

        private void switchWithSuccessor(Object x) {
            int index = this.childToInsertAt(x, false);
            BTreeNode temp = this._entries[index + 1].child;
            while (temp._entries[0] != null && temp._entries[0].child != null) {
                temp = temp._entries[0].child;
            }
            Object successor = temp._entries[0].element;
            temp._entries[0].element = this._entries[index].element;
            this._entries[index].element = successor;
        }

        private void stealLeft(int parentIndex) {
            BTreeNode p = this._parent;
            BTreeNode ls = this._parent._entries[parentIndex - 1].child;
            if (this.isLeaf()) {
                int add = this.childToInsertAt(p._entries[parentIndex - 1].element, true);
                this.insertNewElement(p._entries[parentIndex - 1].element, add);
                p._entries[parentIndex - 1].element = ls._entries[ls._nrElements - 1].element;
                ls._entries[ls._nrElements - 1] = null;
                --ls._nrElements;
            } else {
                this._entries[0].element = p._entries[parentIndex - 1].element;
                p._entries[parentIndex - 1].element = ls._entries[ls._nrElements - 1].element;
                this._entries[0].child = ls._entries[ls._nrElements].child;
                this._entries[0].child._parent = this;
                ls._entries[ls._nrElements] = null;
                ls._entries[ls._nrElements - 1].element = null;
                ++this._nrElements;
                --ls._nrElements;
            }
        }

        private void stealRight(int parentIndex) {
            BTreeNode p = this._parent;
            BTreeNode rs = p._entries[parentIndex + 1].child;
            if (this.isLeaf()) {
                this._entries[this._nrElements] = new Entry();
                this._entries[this._nrElements].element = p._entries[parentIndex].element;
                p._entries[parentIndex].element = rs._entries[0].element;
                for (int i = 0; i < rs._nrElements; ++i) {
                    rs._entries[i] = rs._entries[i + 1];
                }
                rs._entries[rs._nrElements - 1] = null;
                ++this._nrElements;
                --rs._nrElements;
            } else {
                int i;
                for (i = 0; i <= this._nrElements; ++i) {
                    this._entries[i] = this._entries[i + 1];
                }
                this._entries[this._nrElements].element = p._entries[parentIndex].element;
                p._entries[parentIndex].element = rs._entries[0].element;
                this._entries[this._nrElements + 1] = new Entry();
                this._entries[this._nrElements + 1].child = rs._entries[0].child;
                this._entries[this._nrElements + 1].child._parent = this;
                for (i = 0; i <= rs._nrElements; ++i) {
                    rs._entries[i] = rs._entries[i + 1];
                }
                rs._entries[rs._nrElements] = null;
                ++this._nrElements;
                --rs._nrElements;
            }
        }

        private void mergeLeft(int parentIndex) {
            BTreeNode p = this._parent;
            BTreeNode ls = p._entries[parentIndex - 1].child;
            if (this.isLeaf()) {
                int y;
                int x;
                int i;
                int add = this.childToInsertAt(p._entries[parentIndex - 1].element, true);
                this.insertNewElement(p._entries[parentIndex - 1].element, add);
                p._entries[parentIndex - 1].element = null;
                int nr = ls._nrElements;
                for (i = this._nrElements - 1; i >= 0; --i) {
                    this._entries[i + nr] = this._entries[i];
                }
                for (i = ls._nrElements - 1; i >= 0; --i) {
                    this._entries[i] = ls._entries[i];
                    ++this._nrElements;
                }
                if (p._nrElements == this.MIN && p != BTreeSet.this.root) {
                    x = parentIndex - 1;
                    for (y = parentIndex - 2; y >= 0; --y) {
                        p._entries[x] = p._entries[y];
                        --x;
                    }
                    p._entries[0] = new Entry();
                    p._entries[0].child = ls;
                } else {
                    x = parentIndex - 1;
                    for (y = parentIndex; y <= p._nrElements; ++y) {
                        p._entries[x] = p._entries[y];
                        ++x;
                    }
                    p._entries[p._nrElements] = null;
                }
                --p._nrElements;
                if (p.isRoot() && p._nrElements == 0) {
                    BTreeSet.this.root = this;
                    this._parent = null;
                }
            } else {
                int y;
                int x;
                this._entries[0].element = p._entries[parentIndex - 1].element;
                this._entries[0].child = ls._entries[ls._nrElements].child;
                ++this._nrElements;
                int nr = ls._nrElements;
                for (x = this._nrElements; x >= 0; --x) {
                    this._entries[x + nr] = this._entries[x];
                }
                for (x = ls._nrElements - 1; x >= 0; --x) {
                    this._entries[x] = ls._entries[x];
                    this._entries[x].child._parent = this;
                    ++this._nrElements;
                }
                if (p._nrElements == this.MIN && p != BTreeSet.this.root) {
                    x = parentIndex - 1;
                    for (y = parentIndex - 2; y >= 0; ++y) {
                        System.out.println(x + " " + y);
                        p._entries[x] = p._entries[y];
                        ++x;
                    }
                    p._entries[0] = new Entry();
                } else {
                    x = parentIndex - 1;
                    for (y = parentIndex; y <= p._nrElements; ++y) {
                        p._entries[x] = p._entries[y];
                        ++x;
                    }
                    p._entries[p._nrElements] = null;
                }
                --p._nrElements;
                if (p.isRoot() && p._nrElements == 0) {
                    BTreeSet.this.root = this;
                    this._parent = null;
                }
            }
        }

        private void mergeRight(int parentIndex) {
            BTreeNode p = this._parent;
            BTreeNode rs = p._entries[parentIndex + 1].child;
            if (this.isLeaf()) {
                int y;
                int x;
                this._entries[this._nrElements] = new Entry();
                this._entries[this._nrElements].element = p._entries[parentIndex].element;
                ++this._nrElements;
                int i = 0;
                int nr = this._nrElements;
                while (i < rs._nrElements) {
                    this._entries[nr] = rs._entries[i];
                    ++this._nrElements;
                    ++i;
                    ++nr;
                }
                p._entries[parentIndex].element = p._entries[parentIndex + 1].element;
                if (p._nrElements == this.MIN && p != BTreeSet.this.root) {
                    x = parentIndex + 1;
                    for (y = parentIndex; y >= 0; --y) {
                        p._entries[x] = p._entries[y];
                        --x;
                    }
                    p._entries[0] = new Entry();
                    p._entries[0].child = rs;
                } else {
                    x = parentIndex + 1;
                    for (y = parentIndex + 2; y <= p._nrElements; ++y) {
                        p._entries[x] = p._entries[y];
                        ++x;
                    }
                    p._entries[p._nrElements] = null;
                }
                --p._nrElements;
                if (p.isRoot() && p._nrElements == 0) {
                    BTreeSet.this.root = this;
                    this._parent = null;
                }
            } else {
                int y;
                this._entries[this._nrElements].element = p._entries[parentIndex].element;
                ++this._nrElements;
                int x = this._nrElements + 1;
                for (y = 0; y <= rs._nrElements; ++y) {
                    this._entries[x] = rs._entries[y];
                    rs._entries[y].child._parent = this;
                    ++this._nrElements;
                    ++x;
                }
                --this._nrElements;
                p._entries[++parentIndex].child = this;
                if (p._nrElements == this.MIN && p != BTreeSet.this.root) {
                    x = parentIndex - 1;
                    for (y = parentIndex - 2; y >= 0; --y) {
                        p._entries[x] = p._entries[y];
                        --x;
                    }
                    p._entries[0] = new Entry();
                } else {
                    x = parentIndex - 1;
                    for (y = parentIndex; y <= p._nrElements; ++y) {
                        p._entries[x] = p._entries[y];
                        ++x;
                    }
                    p._entries[p._nrElements] = null;
                }
                --p._nrElements;
                if (p.isRoot() && p._nrElements == 0) {
                    BTreeSet.this.root = this;
                    this._parent = null;
                }
            }
        }
    }

    public static class Entry {
        public Object element;
        public BTreeNode child;
    }

    private final class BTIterator
    implements Iterator {
        private int index = 0;
        Stack parentIndex = new Stack();
        private Object lastReturned = null;
        private Object next;
        BTreeNode currentNode = this.firstNode();

        BTIterator() {
            this.next = this.nextElement();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.nextElement();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new NoSuchElementException();
            }
            BTreeSet.this.remove(this.lastReturned);
            this.lastReturned = null;
        }

        private BTreeNode firstNode() {
            BTreeNode temp = BTreeSet.this.root;
            while (temp._entries[0].child != null) {
                temp = temp._entries[0].child;
                this.parentIndex.push(new Integer(0));
            }
            return temp;
        }

        private Object nextElement() {
            if (this.currentNode.isLeaf()) {
                if (this.index < this.currentNode._nrElements) {
                    return this.currentNode._entries[this.index++].element;
                }
                if (!this.parentIndex.empty()) {
                    this.currentNode = this.currentNode._parent;
                    this.index = (Integer)this.parentIndex.pop();
                    while (this.index == this.currentNode._nrElements && !this.parentIndex.empty()) {
                        this.currentNode = this.currentNode._parent;
                        this.index = (Integer)this.parentIndex.pop();
                    }
                    if (this.index == this.currentNode._nrElements) {
                        return null;
                    }
                    return this.currentNode._entries[this.index++].element;
                }
                if (this.index == this.currentNode._nrElements) {
                    return null;
                }
                return this.currentNode._entries[this.index++].element;
            }
            this.currentNode = this.currentNode._entries[this.index].child;
            this.parentIndex.push(new Integer(this.index));
            while (this.currentNode._entries[0].child != null) {
                this.currentNode = this.currentNode._entries[0].child;
                this.parentIndex.push(new Integer(0));
            }
            this.index = 1;
            return this.currentNode._entries[0].element;
        }
    }
}

