/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model.types;

import org.apache.poi.hdf.model.hdftypes.HDFType;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;

public abstract class FIBAbstractType
implements HDFType {
    protected int field_1_wIdent;
    protected int field_2_nFib;
    protected int field_3_nProduct;
    protected int field_4_lid;
    protected int field_5_pnNext;
    protected short field_6_options;
    private static BitField fDot = BitFieldFactory.getInstance(1);
    private static BitField fGlsy = BitFieldFactory.getInstance(2);
    private static BitField fComplex = BitFieldFactory.getInstance(4);
    private static BitField fHasPic = BitFieldFactory.getInstance(8);
    private static BitField cQuickSaves = BitFieldFactory.getInstance(240);
    private static BitField fEncrypted = BitFieldFactory.getInstance(256);
    private static BitField fWhichTblStm = BitFieldFactory.getInstance(512);
    private static BitField fReadOnlyRecommended = BitFieldFactory.getInstance(1024);
    private static BitField fWriteReservation = BitFieldFactory.getInstance(2048);
    private static BitField fExtChar = BitFieldFactory.getInstance(4096);
    private static BitField fLoadOverride = BitFieldFactory.getInstance(8192);
    private static BitField fFarEast = BitFieldFactory.getInstance(16384);
    private static BitField fCrypto = BitFieldFactory.getInstance(32768);
    protected int field_7_nFibBack;
    protected int field_8_lKey;
    protected int field_9_envr;
    protected short field_10_history;
    private static BitField fMac = BitFieldFactory.getInstance(1);
    private static BitField fEmptySpecial = BitFieldFactory.getInstance(2);
    private static BitField fLoadOverridePage = BitFieldFactory.getInstance(4);
    private static BitField fFutureSavedUndo = BitFieldFactory.getInstance(8);
    private static BitField fWord97Saved = BitFieldFactory.getInstance(16);
    private static BitField fSpare0 = BitFieldFactory.getInstance(254);
    protected int field_11_chs;
    protected int field_12_chsTables;
    protected int field_13_fcMin;
    protected int field_14_fcMac;

    protected void fillFields(byte[] data, int offset) {
        this.field_1_wIdent = LittleEndian.getShort(data, 0 + offset);
        this.field_2_nFib = LittleEndian.getShort(data, 2 + offset);
        this.field_3_nProduct = LittleEndian.getShort(data, 4 + offset);
        this.field_4_lid = LittleEndian.getShort(data, 6 + offset);
        this.field_5_pnNext = LittleEndian.getShort(data, 8 + offset);
        this.field_6_options = LittleEndian.getShort(data, 10 + offset);
        this.field_7_nFibBack = LittleEndian.getShort(data, 12 + offset);
        this.field_8_lKey = LittleEndian.getShort(data, 14 + offset);
        this.field_9_envr = LittleEndian.getShort(data, 16 + offset);
        this.field_10_history = LittleEndian.getShort(data, 18 + offset);
        this.field_11_chs = LittleEndian.getShort(data, 20 + offset);
        this.field_12_chsTables = LittleEndian.getShort(data, 22 + offset);
        this.field_13_fcMin = LittleEndian.getInt(data, 24 + offset);
        this.field_14_fcMac = LittleEndian.getInt(data, 28 + offset);
    }

    public void serialize(byte[] data, int offset) {
        LittleEndian.putShort(data, 0 + offset, (short)this.field_1_wIdent);
        LittleEndian.putShort(data, 2 + offset, (short)this.field_2_nFib);
        LittleEndian.putShort(data, 4 + offset, (short)this.field_3_nProduct);
        LittleEndian.putShort(data, 6 + offset, (short)this.field_4_lid);
        LittleEndian.putShort(data, 8 + offset, (short)this.field_5_pnNext);
        LittleEndian.putShort(data, 10 + offset, this.field_6_options);
        LittleEndian.putShort(data, 12 + offset, (short)this.field_7_nFibBack);
        LittleEndian.putShort(data, 14 + offset, (short)this.field_8_lKey);
        LittleEndian.putShort(data, 16 + offset, (short)this.field_9_envr);
        LittleEndian.putShort(data, 18 + offset, this.field_10_history);
        LittleEndian.putShort(data, 20 + offset, (short)this.field_11_chs);
        LittleEndian.putShort(data, 22 + offset, (short)this.field_12_chsTables);
        LittleEndian.putInt(data, 24 + offset, this.field_13_fcMin);
        LittleEndian.putInt(data, 28 + offset, this.field_14_fcMac);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FIB]\n");
        buffer.append("    .wIdent               = ");
        buffer.append(" (").append(this.getWIdent()).append(" )\n");
        buffer.append("    .nFib                 = ");
        buffer.append(" (").append(this.getNFib()).append(" )\n");
        buffer.append("    .nProduct             = ");
        buffer.append(" (").append(this.getNProduct()).append(" )\n");
        buffer.append("    .lid                  = ");
        buffer.append(" (").append(this.getLid()).append(" )\n");
        buffer.append("    .pnNext               = ");
        buffer.append(" (").append(this.getPnNext()).append(" )\n");
        buffer.append("    .options              = ");
        buffer.append(" (").append(this.getOptions()).append(" )\n");
        buffer.append("         .fDot                     = ").append(this.isFDot()).append('\n');
        buffer.append("         .fGlsy                    = ").append(this.isFGlsy()).append('\n');
        buffer.append("         .fComplex                 = ").append(this.isFComplex()).append('\n');
        buffer.append("         .fHasPic                  = ").append(this.isFHasPic()).append('\n');
        buffer.append("         .cQuickSaves              = ").append(this.getCQuickSaves()).append('\n');
        buffer.append("         .fEncrypted               = ").append(this.isFEncrypted()).append('\n');
        buffer.append("         .fWhichTblStm             = ").append(this.isFWhichTblStm()).append('\n');
        buffer.append("         .fReadOnlyRecommended     = ").append(this.isFReadOnlyRecommended()).append('\n');
        buffer.append("         .fWriteReservation        = ").append(this.isFWriteReservation()).append('\n');
        buffer.append("         .fExtChar                 = ").append(this.isFExtChar()).append('\n');
        buffer.append("         .fLoadOverride            = ").append(this.isFLoadOverride()).append('\n');
        buffer.append("         .fFarEast                 = ").append(this.isFFarEast()).append('\n');
        buffer.append("         .fCrypto                  = ").append(this.isFCrypto()).append('\n');
        buffer.append("    .nFibBack             = ");
        buffer.append(" (").append(this.getNFibBack()).append(" )\n");
        buffer.append("    .lKey                 = ");
        buffer.append(" (").append(this.getLKey()).append(" )\n");
        buffer.append("    .envr                 = ");
        buffer.append(" (").append(this.getEnvr()).append(" )\n");
        buffer.append("    .history              = ");
        buffer.append(" (").append(this.getHistory()).append(" )\n");
        buffer.append("         .fMac                     = ").append(this.isFMac()).append('\n');
        buffer.append("         .fEmptySpecial            = ").append(this.isFEmptySpecial()).append('\n');
        buffer.append("         .fLoadOverridePage        = ").append(this.isFLoadOverridePage()).append('\n');
        buffer.append("         .fFutureSavedUndo         = ").append(this.isFFutureSavedUndo()).append('\n');
        buffer.append("         .fWord97Saved             = ").append(this.isFWord97Saved()).append('\n');
        buffer.append("         .fSpare0                  = ").append(this.getFSpare0()).append('\n');
        buffer.append("    .chs                  = ");
        buffer.append(" (").append(this.getChs()).append(" )\n");
        buffer.append("    .chsTables            = ");
        buffer.append(" (").append(this.getChsTables()).append(" )\n");
        buffer.append("    .fcMin                = ");
        buffer.append(" (").append(this.getFcMin()).append(" )\n");
        buffer.append("    .fcMac                = ");
        buffer.append(" (").append(this.getFcMac()).append(" )\n");
        buffer.append("[/FIB]\n");
        return buffer.toString();
    }

    public int getSize() {
        return 32;
    }

    public int getWIdent() {
        return this.field_1_wIdent;
    }

    public void setWIdent(int field_1_wIdent) {
        this.field_1_wIdent = field_1_wIdent;
    }

    public int getNFib() {
        return this.field_2_nFib;
    }

    public void setNFib(int field_2_nFib) {
        this.field_2_nFib = field_2_nFib;
    }

    public int getNProduct() {
        return this.field_3_nProduct;
    }

    public void setNProduct(int field_3_nProduct) {
        this.field_3_nProduct = field_3_nProduct;
    }

    public int getLid() {
        return this.field_4_lid;
    }

    public void setLid(int field_4_lid) {
        this.field_4_lid = field_4_lid;
    }

    public int getPnNext() {
        return this.field_5_pnNext;
    }

    public void setPnNext(int field_5_pnNext) {
        this.field_5_pnNext = field_5_pnNext;
    }

    public short getOptions() {
        return this.field_6_options;
    }

    public void setOptions(short field_6_options) {
        this.field_6_options = field_6_options;
    }

    public int getNFibBack() {
        return this.field_7_nFibBack;
    }

    public void setNFibBack(int field_7_nFibBack) {
        this.field_7_nFibBack = field_7_nFibBack;
    }

    public int getLKey() {
        return this.field_8_lKey;
    }

    public void setLKey(int field_8_lKey) {
        this.field_8_lKey = field_8_lKey;
    }

    public int getEnvr() {
        return this.field_9_envr;
    }

    public void setEnvr(int field_9_envr) {
        this.field_9_envr = field_9_envr;
    }

    public short getHistory() {
        return this.field_10_history;
    }

    public void setHistory(short field_10_history) {
        this.field_10_history = field_10_history;
    }

    public int getChs() {
        return this.field_11_chs;
    }

    public void setChs(int field_11_chs) {
        this.field_11_chs = field_11_chs;
    }

    public int getChsTables() {
        return this.field_12_chsTables;
    }

    public void setChsTables(int field_12_chsTables) {
        this.field_12_chsTables = field_12_chsTables;
    }

    public int getFcMin() {
        return this.field_13_fcMin;
    }

    public void setFcMin(int field_13_fcMin) {
        this.field_13_fcMin = field_13_fcMin;
    }

    public int getFcMac() {
        return this.field_14_fcMac;
    }

    public void setFcMac(int field_14_fcMac) {
        this.field_14_fcMac = field_14_fcMac;
    }

    public void setFDot(boolean value) {
        this.field_6_options = (short)fDot.setBoolean(this.field_6_options, value);
    }

    public boolean isFDot() {
        return fDot.isSet(this.field_6_options);
    }

    public void setFGlsy(boolean value) {
        this.field_6_options = (short)fGlsy.setBoolean(this.field_6_options, value);
    }

    public boolean isFGlsy() {
        return fGlsy.isSet(this.field_6_options);
    }

    public void setFComplex(boolean value) {
        this.field_6_options = (short)fComplex.setBoolean(this.field_6_options, value);
    }

    public boolean isFComplex() {
        return fComplex.isSet(this.field_6_options);
    }

    public void setFHasPic(boolean value) {
        this.field_6_options = (short)fHasPic.setBoolean(this.field_6_options, value);
    }

    public boolean isFHasPic() {
        return fHasPic.isSet(this.field_6_options);
    }

    public void setCQuickSaves(byte value) {
        this.field_6_options = (short)cQuickSaves.setValue(this.field_6_options, value);
    }

    public byte getCQuickSaves() {
        return (byte)cQuickSaves.getValue(this.field_6_options);
    }

    public void setFEncrypted(boolean value) {
        this.field_6_options = (short)fEncrypted.setBoolean(this.field_6_options, value);
    }

    public boolean isFEncrypted() {
        return fEncrypted.isSet(this.field_6_options);
    }

    public void setFWhichTblStm(boolean value) {
        this.field_6_options = (short)fWhichTblStm.setBoolean(this.field_6_options, value);
    }

    public boolean isFWhichTblStm() {
        return fWhichTblStm.isSet(this.field_6_options);
    }

    public void setFReadOnlyRecommended(boolean value) {
        this.field_6_options = (short)fReadOnlyRecommended.setBoolean(this.field_6_options, value);
    }

    public boolean isFReadOnlyRecommended() {
        return fReadOnlyRecommended.isSet(this.field_6_options);
    }

    public void setFWriteReservation(boolean value) {
        this.field_6_options = (short)fWriteReservation.setBoolean(this.field_6_options, value);
    }

    public boolean isFWriteReservation() {
        return fWriteReservation.isSet(this.field_6_options);
    }

    public void setFExtChar(boolean value) {
        this.field_6_options = (short)fExtChar.setBoolean(this.field_6_options, value);
    }

    public boolean isFExtChar() {
        return fExtChar.isSet(this.field_6_options);
    }

    public void setFLoadOverride(boolean value) {
        this.field_6_options = (short)fLoadOverride.setBoolean(this.field_6_options, value);
    }

    public boolean isFLoadOverride() {
        return fLoadOverride.isSet(this.field_6_options);
    }

    public void setFFarEast(boolean value) {
        this.field_6_options = (short)fFarEast.setBoolean(this.field_6_options, value);
    }

    public boolean isFFarEast() {
        return fFarEast.isSet(this.field_6_options);
    }

    public void setFCrypto(boolean value) {
        this.field_6_options = (short)fCrypto.setBoolean(this.field_6_options, value);
    }

    public boolean isFCrypto() {
        return fCrypto.isSet(this.field_6_options);
    }

    public void setFMac(boolean value) {
        this.field_10_history = (short)fMac.setBoolean(this.field_10_history, value);
    }

    public boolean isFMac() {
        return fMac.isSet(this.field_10_history);
    }

    public void setFEmptySpecial(boolean value) {
        this.field_10_history = (short)fEmptySpecial.setBoolean(this.field_10_history, value);
    }

    public boolean isFEmptySpecial() {
        return fEmptySpecial.isSet(this.field_10_history);
    }

    public void setFLoadOverridePage(boolean value) {
        this.field_10_history = (short)fLoadOverridePage.setBoolean(this.field_10_history, value);
    }

    public boolean isFLoadOverridePage() {
        return fLoadOverridePage.isSet(this.field_10_history);
    }

    public void setFFutureSavedUndo(boolean value) {
        this.field_10_history = (short)fFutureSavedUndo.setBoolean(this.field_10_history, value);
    }

    public boolean isFFutureSavedUndo() {
        return fFutureSavedUndo.isSet(this.field_10_history);
    }

    public void setFWord97Saved(boolean value) {
        this.field_10_history = (short)fWord97Saved.setBoolean(this.field_10_history, value);
    }

    public boolean isFWord97Saved() {
        return fWord97Saved.isSet(this.field_10_history);
    }

    public void setFSpare0(byte value) {
        this.field_10_history = (short)fSpare0.setValue(this.field_10_history, value);
    }

    public byte getFSpare0() {
        return (byte)fSpare0.getValue(this.field_10_history);
    }
}

