# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.31
#
# Don't modify this file, modify the SWIG interface instead.

"""
The B+ tree database API of Tokyo Cabinet
"""

import _bdb
import new
new_instancemethod = new.instancemethod
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'PySwigObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0
del types


def _swig_setattr_nondynamic_method(set):
    def set_attr(self,name,value):
        if (name == "thisown"): return self.this.own(value)
        if hasattr(self,name) or (name == "this"):
            set(self,name,value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


class ECODE(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def ecode(*args):
        """
        Get the error code for the last operation

        Returns
        integer, one of `TCESUCCESS' for success, `TCETHREAD' for threading error,
        `TCEINVALID' for invalid operation, `TCENOFILE' for file not found, `TCENOPERM'
        for no permission, `TCEMETA' for invalid meta data, `TCERHEAD' for invalid
        record header, `TCEOPEN' for open error, `TCECLOSE' for close error, `TCETRUNC'
        for trunc error, `TCESYNC' for sync error, `TCESTAT' for stat error, `TCESEEK'
        for seek error, `TCEREAD' for read error, `TCEWRITE' for write error, `TCEMMAP'
        for mmap error, `TCELOCK' for lock error, `TCEUNLINK' for unlink error,
        `TCERENAME' for rename error, `TCEMKDIR' for mkdir error, `TCERMDIR' for rmdir
        error, `TCEKEEP' for existing record, `TCENOREC' for no record found, and
        `TCEMISC' for miscellaneous error.

        """
        return _bdb.ECODE_ecode(*args)

    def errmsg(*args):
        """
        Get the error message by error code or the last
        error message for this database.

        Arguments
        ecode -- int, the error code.  if -1, use the last error code.  defaults to -1.

        Returns
        string, the last error message.

        """
        return _bdb.ECODE_errmsg(*args)

    def __init__(self, *args): 
        this = _bdb.new_ECODE(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _bdb.delete_ECODE
    __del__ = lambda self : None;
ECODE_swigregister = _bdb.ECODE_swigregister
ECODE_swigregister(ECODE)
cvar = _bdb.cvar
ECODE.ESUCCESS = _bdb.cvar.ECODE_ESUCCESS
ECODE.ETHREAD = _bdb.cvar.ECODE_ETHREAD
ECODE.EINVALID = _bdb.cvar.ECODE_EINVALID
ECODE.ENOFILE = _bdb.cvar.ECODE_ENOFILE
ECODE.ENOPERM = _bdb.cvar.ECODE_ENOPERM
ECODE.EMETA = _bdb.cvar.ECODE_EMETA
ECODE.ERHEAD = _bdb.cvar.ECODE_ERHEAD
ECODE.EOPEN = _bdb.cvar.ECODE_EOPEN
ECODE.ECLOSE = _bdb.cvar.ECODE_ECLOSE
ECODE.ETRUNC = _bdb.cvar.ECODE_ETRUNC
ECODE.ESYNC = _bdb.cvar.ECODE_ESYNC
ECODE.ESTAT = _bdb.cvar.ECODE_ESTAT
ECODE.ESEEK = _bdb.cvar.ECODE_ESEEK
ECODE.EREAD = _bdb.cvar.ECODE_EREAD
ECODE.EWRITE = _bdb.cvar.ECODE_EWRITE
ECODE.EMMAP = _bdb.cvar.ECODE_EMMAP
ECODE.ELOCK = _bdb.cvar.ECODE_ELOCK
ECODE.EUNLINK = _bdb.cvar.ECODE_EUNLINK
ECODE.ERENAME = _bdb.cvar.ECODE_ERENAME
ECODE.EMKDIR = _bdb.cvar.ECODE_EMKDIR
ECODE.ERMDIR = _bdb.cvar.ECODE_ERMDIR
ECODE.EKEEP = _bdb.cvar.ECODE_EKEEP
ECODE.ENOREC = _bdb.cvar.ECODE_ENOREC
ECODE.EMISC = _bdb.cvar.ECODE_EMISC

class BDBCursor(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _bdb.new_BDBCursor(*args)
        try: self.this.append(this)
        except: self.this = this
        self.__db = args[0]

    __swig_destroy__ = _bdb.delete_BDBCursor
    __del__ = lambda self : None;
    def first(*args):
        """
        Move a cursor object to the first record.
        If successful, the return value is true, else, it is false.  False is returned if there is
        no record in the database.
        """
        return _bdb.BDBCursor_first(*args)

    def last(*args):
        """
        Move a cursor object to the last record.
        If successful, the return value is true, else, it is false.  False is returned if there is
        no record in the database.

        """
        return _bdb.BDBCursor_last(*args)

    def jump(*args):
        """
        Move a cursor object to the front of records corresponding a key.
        The cursor is set to the first record corresponding the key or the next substitute if
        completely matching record does not exist. 
        Arguments:
        key -- string, the key to move to
        Returns:
        If successful, the return value is true, else, it is false.  False is returned if there is
        no record corresponding the condition.

        """
        return _bdb.BDBCursor_jump(*args)

    def prev(*args):
        """
        Move a cursor object to the previous record.

        Returns:
        If successful, the return value is true, else, it is false.  False is returned if there is
        no previous record. 

        """
        return _bdb.BDBCursor_prev(*args)

    def next(*args):
        """
        Move a cursor object to the next record.

        Returns:
        If successful, the return value is true, else, it is false.  False is returned if there is
        no next record.

        """
        return _bdb.BDBCursor_next(*args)

    def put(*args):
        """
        Insert a record around a cursor object.

        After insertion, the cursor is moved to the inserted record. 

        Arguments:
        value -- str, the new value
        cpmode -- int, specifies detail adjustment: `BDBCPCURRENT', which means that the value of the
           current record is overwritten, `BDBCPBEFORE', which means that the new record is inserted
           before the current record, `BDBCPAFTER', which means that the new record is inserted after the
           current record.
        Returns:
        If successful, the return value is true, else, it is false.  False is returned when the cursor
        is at invalid position.

        """
        return _bdb.BDBCursor_put(*args)

    def out(*args):
        """
        Remove the record where a cursor object is.

        After deletion, the cursor is moved to the next record if possible. 

        Returns:
        If successful, the return value is true, else, it is false.  False is returned when the cursor
        is at invalid position.

        """
        return _bdb.BDBCursor_out(*args)

    def key(*args):
        """
        Get the key of the record where the cursor object is.

        Returns:
        string or None

        """
        return _bdb.BDBCursor_key(*args)

    def val(*args):
        """
        Insert a record around a cursor object.

        After insertion, the cursor is moved to the inserted record. 

        Arguments:
        value -- str, the new value
        cpmode -- int, specifies detail adjustment: `BDBCPCURRENT', which means that the value of the
           current record is overwritten, `BDBCPBEFORE', which means that the new record is inserted
           before the current record, `BDBCPAFTER', which means that the new record is inserted after the
           current record.
        Returns:
        If successful, the return value is true, else, it is false.  False is returned when the cursor
        is at invalid position.

        """
        return _bdb.BDBCursor_val(*args)

BDBCursor_swigregister = _bdb.BDBCursor_swigregister
BDBCursor_swigregister(BDBCursor)
BDBCursor.CPCURRENT = _bdb.cvar.BDBCursor_CPCURRENT
BDBCursor.CPBEFORE = _bdb.cvar.BDBCursor_CPBEFORE
BDBCursor.CPAFTER = _bdb.cvar.BDBCursor_CPAFTER

class BDB(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def tune(*args):
        """
        Set the tuning parameters of a B+ tree database object.

        Note that the tuning parameters should be set before the database is opened.

        Arguments
        lmemb -- specifies the number of members in each leaf page.  If it is not more than 0, the
           default value is specified.  The default value is 128.
        nmemb -- specifies the number of members in each non-leaf page.  If it is not more than 0, the
           default value is specified.  The default value is 256.
        bnum --  specifies the number of elements of the bucket array.  If it is not more than 0, the
           default value is specified.  The default value is 32749.  Suggested size of the bucket array
           is about from 1 to 4 times of the number of all pages to be stored.
        apow -- specifies the size of record alignment by power of 2.  If it is negative, the default
           value is specified.  The default value is 8 standing for 2^8=256.
        fpow -- specifies the maximum number of elements of the free block pool by power of 2.  If it
           is negative, the default value is specified.  The default value is 10 standing for 2^10=1024.
        opts -- specifies options by bitwise-or: `BDBTLARGE' specifies that the size of the database
           can be larger than 2GB by using 64-bit bucket array, `BDBTDEFLATE' specifies that each page
           is compressed with Deflate encoding, `BDBTBZIP' specifies that each page is compressed with
           BZIP2 encoding, `BDBTTCBS' specifies that each page is compressed with TCBS encoding.

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _bdb.BDB_tune(*args)

    def setcache(*args):
        """
        Set the caching parameters of a B+ tree database object.

        Note that the caching parameters should be set before the database is opened. 

        Arguments    
        lcnum -- specifies the maximum number of leaf nodes to be cached.  If it is not more than 0,
        the default value is specified.  The default value is 1024.
        ncnum -- specifies the maximum number of non-leaf nodes to be cached.  If it is not more than 0,
        the default value is specified.  The default value is 512.

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _bdb.BDB_setcache(*args)

    def setxmsiz(*args):
        """
        Set the size of the extra mapped memory of a B+ tree database object.

        Note that the mapping parameters should be set before the database is opened.

        Arguments 
        xmsiz -- int, specifies the size of the extra mapped memory.  If it is not more than 0, the extra
        mapped memory is disabled.  It is disabled by default.

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _bdb.BDB_setxmsiz(*args)

    def open(*args):
        """
        Open a database file and connect a B+ tree database object.

        Arguments
        path -- str, specifies the path of the database file.
        omode -- int, specifies the connection mode: `BDBOWRITER' as a writer, `BDBOREADER' as a reader.
        If the mode is `BDBOWRITER', the following may be added by bitwise-or: `BDBOCREAT', which
        means it creates a new database if not exist, `BDBOTRUNC', which means it creates a new
        database regardless if one exists, `BDBOTSYNC', which means every transaction synchronizes
        updated contents with the device.  Both of `BDBOREADER' and `BDBOWRITER' can be added to by
        bitwise-or: `BDBONOLCK', which means it opens the database file without file locking, or
        `BDBOLCKNB', which means locking is performed without blocking.

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _bdb.BDB_open(*args)

    def close(*args):
        """1"""
        return _bdb.BDB_close(*args)

    def put(*args):
        """
        Store a new record into a B+ tree database object.

        Arguments:
        key -- the key
        value -- the value

        Returns:
        boolean
        """
        return _bdb.BDB_put(*args)

    def putkeep(*args):
        """
        Store a new record into a B+ tree database object.

        If a record with the same key exists in the database, this function has no effect. 

        Arguments
        key -- str, the key
        value -- str, the value

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _bdb.BDB_putkeep(*args)

    def putcat(*args):
        """
        Concatenate a value at the end of the existing record in a B+ tree database object.

        If there is no corresponding record, a new record is created. 

        Arguments
        key -- str, the key
        value -- str, the value

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _bdb.BDB_putcat(*args)

    def out(*args):
        """
        Remove a record of a B+ tree database object.

        If the key of duplicated records is specified, the first one is selected.

        Arguments
        key -- str, the key

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _bdb.BDB_out(*args)

    def get(*args):
        """
        Retrieve a record in a B+ tree database object.
         
        If the key of duplicated records is specified, the first one is selected.  

        Arguments
        key -- str, the key 

        Returns
        The value or None

        """
        return _bdb.BDB_get(*args)

    def vsiz(*args):
        """
        Get the size of the value of a record in a B+ tree
        %database object.

        If the key of duplicated records is specified, the first one is selected. 

        Returns
        key -- str, the key

        Returns
        If successful, the return value is the size of the value of the corresponding record, else,
        it is -1.

        """
        return _bdb.BDB_vsiz(*args)

    def addint(*args):
        """
        Add an integer to a record in a B+ tree database object.

        If the corresponding record exists, the value is treated as an integer and is added to.  If no
        record corresponds, a new record of the additional value is stored. 

        Arguments
        key -- str, specifies the pointer to the region of the key.
        num -- int, specifies the additional value.

        Returns
        If successful, the return value is the summation value, else, it is `INT_MIN'.


        """
        return _bdb.BDB_addint(*args)

    def adddouble(*args):
        """
        Add a real number to a record in a B+ tree database object.

        If the corresponding record exists, the value is treated as a real number and
        is added to.  If no record corresponds, a new record of the additional value is
        stored. 

        Arguments
        key -- str, the key
        num -- int, the additional value

        Returns
        If successful, the return value is the summation value, else, it is Not-a-Number.

        """
        return _bdb.BDB_adddouble(*args)

    def sync(*args):
        """
        Synchronize updated contents of a B+ tree database object with the file and the device.

        This function is useful when another process connects to the same database file.

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _bdb.BDB_sync(*args)

    def optimize(*args):
        """
        Optimize the file of a B+ tree database object.

        This function is useful to reduce the size of the database file with data
        fragmentation by successive updating.

        Arguments
        lmemb -- int, specifies the number of members in each leaf page.  If it is not more than 0, the
        current setting is not changed.
        nmemb -- int, specifies the number of members in each non-leaf page.  If it is not more than 0, the
        current setting is not changed.
        bnum -- int, specifies the number of elements of the bucket array.  If it is not more than 0, the
        default value is specified.  The default value is two times of the number of pages.
        apow -- int, specifies the size of record alignment by power of 2.  If it is negative, the current
        setting is not changed.
        fpow -- int, specifies the maximum number of elements of the free block pool by power of 2.  If it
        is negative, the current setting is not changed.
        opts -- int, specifies options by bitwise-or: `BDBTLARGE' specifies that the size of the database
        can be larger than 2GB by using 64-bit bucket array, `BDBTDEFLATE' specifies that each record
        is compressed with Deflate encoding, `BDBTBZIP' specifies that each page is compressed with
        BZIP2 encoding, `BDBTTCBS' specifies that each page is compressed with TCBS encoding.  If it
        is `UINT8_MAX', the current setting is not changed.

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _bdb.BDB_optimize(*args)

    def vanish(*args):
        """
        Remove all records of a B+ tree database object.
           `bdb' specifies the B+ tree database object connected as a writer.
           If successful, the return value is true, else, it is false. 
        """
        return _bdb.BDB_vanish(*args)

    def copy(*args):
        """
        Copy the database file of a B+ tree database object.

        The database file is assured to be kept synchronized and not modified while the
        copying or executing operation is in progress.  So, this function is useful to
        create a backup file of the database file. 

        Arguments
        path -- str, specifies the path of the destination file.  If it begins with `@', the trailing
        substring is executed as a command line.

        Returns
        If successful, the return value is true, else, it is false.  False is returned if the executed
        command returns non-zero code.

        """
        return _bdb.BDB_copy(*args)

    def tranbegin(*args):
        """
        Begin the transaction of a B+ tree database object.

        The database is locked by the thread while the transaction so that only one
        transaction can be activated with a database object at the same time.  Thus,
        the serializable isolation level is assumed if every database operation is
        performed in the transaction.  Because all pages are cached on memory while the
        transaction, the amount of referred records is limited by the memory capacity.
        If the database is closed during transaction, the transaction is aborted
        implicitly.

        Returns
        If successful, the return value is true, else, it is false.
           
        """
        return _bdb.BDB_tranbegin(*args)

    def trancommit(*args):
        """
        Commit the transaction of a B+ tree database object.

        Update in the transaction is fixed when it is committed successfully.

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _bdb.BDB_trancommit(*args)

    def tranabort(*args):
        """
        Abort the transaction of a B+ tree database object.

        Update in the transaction is discarded when it is aborted.  The state of the
        database is rollbacked to before transaction.

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _bdb.BDB_tranabort(*args)

    def path(*args):
        """
        Get the file path of a B+ tree database object.

        Returns
        The return value is the path of the database file or `NULL' if the object does
        not connect to any database file.
        """
        return _bdb.BDB_path(*args)

    def rnum(*args):
        """
        Get the number of records of a B+ tree database object.

        Returns
        The return value is the number of records or 0 if the object does not connect
        to any database file.
        """
        return _bdb.BDB_rnum(*args)

    def fsiz(*args):
        """
        Get the size of the database file of a B+ tree database object.

        Returns
        The return value is the size of the database file or 0 if the object does not connect to any
        database file.
        """
        return _bdb.BDB_fsiz(*args)

    def fwmkeys(*args):
        """
        Get forward matching keys in a B+ tree database object.

        Arguments
        prefix -- str, the key prefix
        max -- int, specifies the maximum number of keys to be fetched.  If it is negative, no limit is
        specified.

        Returns
        The return value is a list object of the corresponding keys.  This function does never fail
        and return an empty list even if no key corresponds.

        """
        return _bdb.BDB_fwmkeys(*args)

    def __len__(*args): return _bdb.BDB___len__(*args)
    def __init__(self, *args): 
        this = _bdb.new_BDB(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _bdb.delete_BDB
    __del__ = lambda self : None;
BDB_swigregister = _bdb.BDB_swigregister
BDB_swigregister(BDB)
BDB.TLARGE = _bdb.cvar.BDB_TLARGE
BDB.TDEFLATE = _bdb.cvar.BDB_TDEFLATE
BDB.TBZIP = _bdb.cvar.BDB_TBZIP
BDB.TTCBS = _bdb.cvar.BDB_TTCBS
BDB.OREADER = _bdb.cvar.BDB_OREADER
BDB.OWRITER = _bdb.cvar.BDB_OWRITER
BDB.OCREAT = _bdb.cvar.BDB_OCREAT
BDB.OTRUNC = _bdb.cvar.BDB_OTRUNC
BDB.ONOLCK = _bdb.cvar.BDB_ONOLCK
BDB.OLCKNB = _bdb.cvar.BDB_OLCKNB
BDB.OTSYNC = _bdb.cvar.BDB_OTSYNC

def cursor(self):
    """Get a cursor for this database"""
    return BDBCursor(self)

def _iter(self):
    """Iterate over all the records in the database."""
    cursor = self.cursor()
    cursor.first()
    yield cursor.key(), cursor.val()
    while cursor.next():
        yield cursor.key(), cursor.val()

def keys(self):
    """Iterate over all the keys in the database"""
    for k, v in self:
        yield k

def values(self): 
    """Iterate over all the values in the database"""
    for k, v in self:
        yield v

def getitem(self, key):
    val = self.get(key)
    if val is None:
        raise KeyError(key)
    return val


BDB.__iter__ = _iter
BDB.items = _iter
BDB.keys = keys
BDB.values = values
BDB.__getitem__ = getitem
BDB.__setitem__ = BDB.put
BDB.cursor = cursor

del cursor
del _iter
del keys
del values
del getitem




