# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.31
#
# Don't modify this file, modify the SWIG interface instead.

"""
The table database API of Tokyo Cabinet
"""

import _tdb
import new
new_instancemethod = new.instancemethod
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'PySwigObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0
del types


def _swig_setattr_nondynamic_method(set):
    def set_attr(self,name,value):
        if (name == "thisown"): return self.this.own(value)
        if hasattr(self,name) or (name == "this"):
            set(self,name,value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


class ECODE(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def ecode(*args):
        """
        Get the error code for the last operation

        Returns
        integer, one of `TCESUCCESS' for success, `TCETHREAD' for threading error,
        `TCEINVALID' for invalid operation, `TCENOFILE' for file not found, `TCENOPERM'
        for no permission, `TCEMETA' for invalid meta data, `TCERHEAD' for invalid
        record header, `TCEOPEN' for open error, `TCECLOSE' for close error, `TCETRUNC'
        for trunc error, `TCESYNC' for sync error, `TCESTAT' for stat error, `TCESEEK'
        for seek error, `TCEREAD' for read error, `TCEWRITE' for write error, `TCEMMAP'
        for mmap error, `TCELOCK' for lock error, `TCEUNLINK' for unlink error,
        `TCERENAME' for rename error, `TCEMKDIR' for mkdir error, `TCERMDIR' for rmdir
        error, `TCEKEEP' for existing record, `TCENOREC' for no record found, and
        `TCEMISC' for miscellaneous error.

        """
        return _tdb.ECODE_ecode(*args)

    def errmsg(*args):
        """
        Get the error message by error code or the last
        error message for this database.

        Arguments
        ecode -- int, the error code.  if -1, use the last error code.  defaults to -1.

        Returns
        string, the last error message.

        """
        return _tdb.ECODE_errmsg(*args)

    def __init__(self, *args): 
        this = _tdb.new_ECODE(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _tdb.delete_ECODE
    __del__ = lambda self : None;
ECODE_swigregister = _tdb.ECODE_swigregister
ECODE_swigregister(ECODE)
cvar = _tdb.cvar
ECODE.ESUCCESS = _tdb.cvar.ECODE_ESUCCESS
ECODE.ETHREAD = _tdb.cvar.ECODE_ETHREAD
ECODE.EINVALID = _tdb.cvar.ECODE_EINVALID
ECODE.ENOFILE = _tdb.cvar.ECODE_ENOFILE
ECODE.ENOPERM = _tdb.cvar.ECODE_ENOPERM
ECODE.EMETA = _tdb.cvar.ECODE_EMETA
ECODE.ERHEAD = _tdb.cvar.ECODE_ERHEAD
ECODE.EOPEN = _tdb.cvar.ECODE_EOPEN
ECODE.ECLOSE = _tdb.cvar.ECODE_ECLOSE
ECODE.ETRUNC = _tdb.cvar.ECODE_ETRUNC
ECODE.ESYNC = _tdb.cvar.ECODE_ESYNC
ECODE.ESTAT = _tdb.cvar.ECODE_ESTAT
ECODE.ESEEK = _tdb.cvar.ECODE_ESEEK
ECODE.EREAD = _tdb.cvar.ECODE_EREAD
ECODE.EWRITE = _tdb.cvar.ECODE_EWRITE
ECODE.EMMAP = _tdb.cvar.ECODE_EMMAP
ECODE.ELOCK = _tdb.cvar.ECODE_ELOCK
ECODE.EUNLINK = _tdb.cvar.ECODE_EUNLINK
ECODE.ERENAME = _tdb.cvar.ECODE_ERENAME
ECODE.EMKDIR = _tdb.cvar.ECODE_EMKDIR
ECODE.ERMDIR = _tdb.cvar.ECODE_ERMDIR
ECODE.EKEEP = _tdb.cvar.ECODE_EKEEP
ECODE.ENOREC = _tdb.cvar.ECODE_ENOREC
ECODE.EMISC = _tdb.cvar.ECODE_EMISC

class TDB(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __len__(*args):
        """Get the number of rows in the database"""
        return _tdb.TDB___len__(*args)

    def tune(*args):
        """
        Set the tuning parameters of a table database object.

        Note that the tuning parameters should be set before the database is opened.

        Arguments

        bnum -- specifies the number of elements of the bucket array.  If it is not more than 0, the
        default value is specified.  The default value is 131071.  Suggested size of the bucket array
        is about from 0.5 to 4 times of the number of all records to be stored.
        apow -- specifies the size of record alignment by power of 2.  If it is negative, the default
        value is specified.  The default value is 4 standing for 2^4=16.
        fpow -- specifies the maximum number of elements of the free block pool by power of 2.  If it
        is negative, the default value is specified.  The default value is 10 standing for 2^10=1024.
        opts -- specifies options by bitwise-or: `TDBTLARGE' specifies that the size of the database
        can be larger than 2GB by using 64-bit bucket array, `TDBTDEFLATE' specifies that each record
        is compressed with Deflate encoding, `TDBTBZIP' specifies that each record is compressed with
        BZIP2 encoding, `TDBTTCBS' specifies that each record is compressed with TCBS encoding.

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _tdb.TDB_tune(*args)

    def setcache(*args):
        """
        Set the caching parameters of a table database object.

        Note that the caching parameters should be set before the database is opened.  Leaf nodes and
        non-leaf nodes are used in column indexes.

        Arguments
        rcnum -- specifies the maximum number of records to be cached.  If it is not more than 0, the
        record cache is disabled.  It is disabled by default.
        lcnum -- specifies the maximum number of leaf nodes to be cached.  If it is not more than 0,
        the default value is specified.  The default value is 2048.
        ncnum -- specifies the maximum number of non-leaf nodes to be cached.  If it is not more than 0,
        the default value is specified.  The default value is 512.

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _tdb.TDB_setcache(*args)

    def setxmsiz(*args):
        """
        Set the size of the extra mapped memory of a table database object.

        Note that the mapping parameters should be set before the database is opened. 

        Arguments
        xmsiz -- specifies the size of the extra mapped memory.  If it is not more than 0, the extra
        mapped memory is disabled.  The default size is 67108864.

        Returns
        If successful, the return value is true, else, it is false.
           
        """
        return _tdb.TDB_setxmsiz(*args)

    def open(*args):
        """
        Open a database file and connect a table database object.

        Arguments
        path -- specifies the path of the database file.
        omode -- specifies the connection mode: `TDBOWRITER' as a writer, `TDBOREADER' as a reader.
        If the mode is `TDBOWRITER', the following may be added by bitwise-or: `TDBOCREAT', which
        means it creates a new database if not exist, `TDBOTRUNC', which means it creates a new
        database regardless if one exists, `TDBOTSYNC', which means every transaction synchronizes
        updated contents with the device.  Both of `TDBOREADER' and `TDBOWRITER' can be added to by
        bitwise-or: `TDBONOLCK', which means it opens the database file without file locking, or
        `TDBOLCKNB', which means locking is performed without blocking.

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _tdb.TDB_open(*args)

    def close(*args): return _tdb.TDB_close(*args)
    def put(*args):
        """
        Store a record into a table database object.

        If a record with the same key exists in the database, it is overwritten.

        Arguments
        key -- str, the primary key
        cols -- dict{str:str}, a dictionary of string (column) to string (value)

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _tdb.TDB_put(*args)

    def get(*args):
        """
        Retrieve a record in a table database object.

        Arguments
        key -- str, the primary key

        Returns
        If successful, the return value is a map object of the columns of the corresponding record.
        None is returned if no record corresponds.

        """
        return _tdb.TDB_get(*args)

    def path(*args):
        """
        Get the file path of a table database object.

        Returns
        The return value is the path of the database file or `NULL' if the object does
        not connect to any database file.
        """
        return _tdb.TDB_path(*args)

    def rnum(*args):
        """Get the number of records in the database"""
        return _tdb.TDB_rnum(*args)

    def fsiz(*args):
        """
        Get the size of the database file of a table database object.

        Returns
        The return value is the size of the database file or 0 if the object does not
        connect to any database file. 
        """
        return _tdb.TDB_fsiz(*args)

    def putkeep(*args):
        """
        Store a new record into a table database object.

        If a record with the same key exists in the database, this function has no effect.

        Arguments
        key -- str, the primary key
        cols -- dict, the columns / values

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _tdb.TDB_putkeep(*args)

    def putcat(*args):
        """
        Concatenate columns of the existing record in a table database object.

        If there is no corresponding record, a new record is created. 

        Arguments
        key -- str, the primary key
        cols -- dict, the columns / values to set

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _tdb.TDB_putcat(*args)

    def out(*args):
        """
        Remove a record of a table database object.

        Arguments
        key -- str, the primary key

        Returns
        If successful, the return value is true, else, it is false. 

        """
        return _tdb.TDB_out(*args)

    def vsiz(*args):
        """
        Get the size of the value of a record in a table database object.

        Arguments
        pk -- str, the primary key

        Returns
        If successful, the return value is the size of the value of the corresponding
        record, else, it is -1.
        """
        return _tdb.TDB_vsiz(*args)

    def iterinit(*args):
        """
        Initialize the iterator of a table database object.

           The iterator is used in order to access the primary key of every record stored in a
           database.

           Returns
           If successful, the return value is true, else, it is false.
            
        """
        return _tdb.TDB_iterinit(*args)

    def iternext(*args):
        """
        Get the next primary key of the iterator of a table database object.

        It is possible to access every record by iteration of calling this function.
        It is allowed to update or remove records whose keys are fetched while the iteration.
        However, it is not assured if updating the database is occurred while the iteration.  Besides,
        the order of this traversal access method is arbitrary, so it is not assured that the order of
        storing matches the one of the traversal access.

        Returns
        The next primary key or None

        """
        return _tdb.TDB_iternext(*args)

    def fwmkeys(*args):
        """
        Get forward matching primary keys in a table database object.


        Note that this function may be very slow because every key in the database is scanned.

        Arguments
        prefix -- str, the primary key prefix
        max -- specifies the maximum number of keys to be fetched.  If it is negative, no limit is
        specified.

        Returns
        The return value is a list object of the corresponding keys.  This function does never fail
        and return an empty list even if no key corresponds.

        """
        return _tdb.TDB_fwmkeys(*args)

    def addint(*args):
        """
        Add an integer to a column of a record in a table database object.

        If successful, the return value is the summation value, else, it is `INT_MIN'.
        The additional value is stored as a decimal string value of a column whose name
        is '_num'.  If no record corresponds, a new record with the additional value is
        stored.

        Arguments 
        key -- str, the primary key
        num -- int, the number to add
            
        """
        return _tdb.TDB_addint(*args)

    def adddouble(*args):
        """
        Add a real number to a column of a record in a table database object.

        If successful, the return value is the summation value, else, it is
        Not-a-Number.  The additional value is stored as a decimal string value of a
        column whose name is '_num'.  If no record corresponds, a new record with the
        additional value is stored. 

        Arguments
        key -- str, the primary key
        num -- float, the number to add

        """
        return _tdb.TDB_adddouble(*args)

    def sync(*args):
        """
        Synchronize updated contents of a table database object with the file and the device.

        If successful, the return value is true, else, it is false.
        This function is useful when another process connects to the same database file.
        """
        return _tdb.TDB_sync(*args)

    def optimize(*args):
        """
        Optimize the file of a table database object.

        This function is useful to reduce the size of the database file with data fragmentation by
        successive updating. 

        Arguments
        bnum -- specifies the number of elements of the bucket array.  If it is not more than 0, the
        default value is specified.  The default value is two times of the number of records.
        apow -- specifies the size of record alignment by power of 2.  If it is negative, the current
        setting is not changed.
        fpow -- specifies the maximum number of elements of the free block pool by power of 2.  If it
        is negative, the current setting is not changed.
        opts -- specifies options by bitwise-or: `BDBTLARGE' specifies that the size of the database
        can be larger than 2GB by using 64-bit bucket array, `BDBTDEFLATE' specifies that each record
        is compressed with Deflate encoding, `BDBTBZIP' specifies that each record is compressed with
        BZIP2 encoding, `BDBTTCBS' specifies that each record is compressed with TCBS encoding.  If it
        is `UINT8_MAX', the current setting is not changed.

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _tdb.TDB_optimize(*args)

    def vanish(*args):
        """
        Remove all records of a table database object.

           If successful, the return value is true, else, it is false. 
        """
        return _tdb.TDB_vanish(*args)

    def copy(*args):
        """
        Copy the database file of a table database object.

        The database file is assured to be kept synchronized and not modified while the copying or
        executing operation is in progress.  So, this function is useful to create a backup file of
        the database file.

        Arguments 
        path -- specifies the path of the destination file.  If it begins with `@', the trailing
        substring is executed as a command line.

        Returns
        If successful, the return value is true, else, it is false.  False is returned if the executed
        command returns non-zero code.
        """
        return _tdb.TDB_copy(*args)

    def tranbegin(*args):
        """
        Begin the transaction of a table database object.

        The database is locked by the thread while the transaction so that only one
        transaction can be activated with a database object at the same time.  Thus,
        the serializable isolation level is assumed if every database operation is
        performed in the transaction.  Because all pages are cached on memory while the
        transaction, the amount of referred records is limited by the memory capacity.
        If the database is closed during transaction, the transaction is aborted
        implicitly.

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _tdb.TDB_tranbegin(*args)

    def trancommit(*args):
        """
        Commit the transaction of a table database object.

        If successful, the return value is true, else, it is false.
        Update in the transaction is fixed when it is committed successfully. 

        """
        return _tdb.TDB_trancommit(*args)

    def tranabort(*args):
        """
        Abort the transaction of a table database object.

        Update in the transaction is discarded when it is aborted.  The state of the database is
        rollbacked to before transaction.

        Returns
        If successful, the return value is true, else, it is false.

        """
        return _tdb.TDB_tranabort(*args)

    def setindex(*args):
        """
        Set a column index to a table database object.

        Note that the setting indexes should be set after the database is opened.

        Arguments
        name -- specifies the name of a column.  If the name of an existing index is specified, the
           index is rebuilt.  An empty string means the primary key.
        type -- specifies the index type: `TDBITLEXICAL' for lexical string, `TDBITDECIMAL' for decimal
           string.  If it is `TDBITOPT', the index is optimized.  If it is `TDBITVOID', the index is
           removed.  If `TDBITKEEP' is added by bitwise-or and the index exists, this function merely
           returns failure.
        Returns
        If successful, the return value is true, else, it is false.

        """
        return _tdb.TDB_setindex(*args)

    def genuid(*args):
        """
        Generate a unique ID number of a table database object.

        Returns
        The return value is the new unique ID number or -1 on failure.

        """
        return _tdb.TDB_genuid(*args)

    TLARGE = _tdb.TDB_TLARGE
    TDEFLATE = _tdb.TDB_TDEFLATE
    TBZIP = _tdb.TDB_TBZIP
    TTCBS = _tdb.TDB_TTCBS
    OREADER = _tdb.TDB_OREADER
    OWRITER = _tdb.TDB_OWRITER
    OCREAT = _tdb.TDB_OCREAT
    OTRUNC = _tdb.TDB_OTRUNC
    ONOLCK = _tdb.TDB_ONOLCK
    OLCKNB = _tdb.TDB_OLCKNB
    OTSYNC = _tdb.TDB_OTSYNC
    ITLEXICAL = _tdb.TDB_ITLEXICAL
    ITDECIMAL = _tdb.TDB_ITDECIMAL
    ITTOKEN = _tdb.TDB_ITTOKEN
    ITQGRAM = _tdb.TDB_ITQGRAM
    ITOPT = _tdb.TDB_ITOPT
    ITVOID = _tdb.TDB_ITVOID
    ITKEEP = _tdb.TDB_ITKEEP
    def __init__(self, *args): 
        this = _tdb.new_TDB(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _tdb.delete_TDB
    __del__ = lambda self : None;
TDB_swigregister = _tdb.TDB_swigregister
TDB_swigregister(TDB)

class TDBQuery(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _tdb.new_TDBQuery(*args)
        try: self.this.append(this)
        except: self.this = this
        self.__db = args[0]

    __swig_destroy__ = _tdb.delete_TDBQuery
    __del__ = lambda self : None;
    def addcond(*args):
        """
        Add a narrowing condition to a query object.

        Arguments
        qry -- specifies the query object.
        name -- specifies the name of a column.  An empty string means the primary key.
        op -- specifies an operation type: `TDBQCSTREQ' for string which is equal to the expression,
        `TDBQCSTRINC' for string which is included in the expression, `TDBQCSTRBW' for string which
        begins with the expression, `TDBQCSTREW' for string which ends with the expression,
        `TDBQCSTRAND' for string which includes all tokens in the expression, `TDBQCSTROR' for string
        which includes at least one token in the expression, `TDBQCSTROREQ' for string which is equal
        to at least one token in the expression, `TDBQCSTRRX' for string which matches regular
        expressions of the expression, `TDBQCNUMEQ' for number which is equal to the expression,
        `TDBQCNUMGT' for number which is greater than the expression, `TDBQCNUMGE' for number which is
        greater than or equal to the expression, `TDBQCNUMLT' for number which is less than the
        expression, `TDBQCNUMLE' for number which is less than or equal to the expression, `TDBQCNUMBT'
        for number which is between two tokens of the expression, `TDBQCNUMOREQ' for number which is
        equal to at least one token in the expression.  All operations can be flagged by bitwise-or:
        `TDBQCNEGATE' for negation, `TDBQCNOIDX' for using no index.
        expr -- specifies an operand exression.
        """
        return _tdb.TDBQuery_addcond(*args)

    def setorder(*args):
        """
        Set the order of a query object.

        Arguments
        qry -- specifies the query object.
        name -- specifies the name of a column.  An empty string means the primary key.
        type -- specifies the order type: `TDBQOSTRASC' for string ascending, `TDBQOSTRDESC' for
        string descending, `TDBQONUMASC' for number ascending, `TDBQONUMDESC' for number descending.

        """
        return _tdb.TDBQuery_setorder(*args)

    def setlimit(*args):
        """
        Set the limit number of records of the result of a query object.

        Arguments
        qry -- specifies the query object.
        max -- specifies the maximum number of records of the result.  If it is negative, no limit is
        specified.
        skip -- specifies the number of skipped records of the result.  If it is not more than 0, no
        record is skipped. 

        """
        return _tdb.TDBQuery_setlimit(*args)

    def search(*args):
        """
        Execute the search of a query object.

        Returns
        The return value is a list object of the primary keys of the corresponding records.  This
        function does never fail and return an empty list even if no record corresponds.

        """
        return _tdb.TDBQuery_search(*args)

    def searchout(*args):
        """
        Remove each record corresponding to a query object.

        Returns
        If successful, the return value is true, else, it is false.
        """
        return _tdb.TDBQuery_searchout(*args)

    def hint(*args):
        """
        Get the hint of a query object.

        Returns
        The return value is the hint string.

        """
        return _tdb.TDBQuery_hint(*args)

    QCSTREQ = _tdb.TDBQuery_QCSTREQ
    QCSTRINC = _tdb.TDBQuery_QCSTRINC
    QCSTRBW = _tdb.TDBQuery_QCSTRBW
    QCSTREW = _tdb.TDBQuery_QCSTREW
    QCSTRAND = _tdb.TDBQuery_QCSTRAND
    QCSTROR = _tdb.TDBQuery_QCSTROR
    QCSTROREQ = _tdb.TDBQuery_QCSTROREQ
    QCSTRRX = _tdb.TDBQuery_QCSTRRX
    QCNUMEQ = _tdb.TDBQuery_QCNUMEQ
    QCNUMGT = _tdb.TDBQuery_QCNUMGT
    QCNUMGE = _tdb.TDBQuery_QCNUMGE
    QCNUMLT = _tdb.TDBQuery_QCNUMLT
    QCNUMLE = _tdb.TDBQuery_QCNUMLE
    QCNUMBT = _tdb.TDBQuery_QCNUMBT
    QCNUMOREQ = _tdb.TDBQuery_QCNUMOREQ
    QCFTSPH = _tdb.TDBQuery_QCFTSPH
    QCFTSAND = _tdb.TDBQuery_QCFTSAND
    QCFTSOR = _tdb.TDBQuery_QCFTSOR
    QCFTSEX = _tdb.TDBQuery_QCFTSEX
    QCNEGATE = _tdb.TDBQuery_QCNEGATE
    QCNOIDX = _tdb.TDBQuery_QCNOIDX
    QOSTRASC = _tdb.TDBQuery_QOSTRASC
    QOSTRDESC = _tdb.TDBQuery_QOSTRDESC
    QONUMASC = _tdb.TDBQuery_QONUMASC
    QONUMDESC = _tdb.TDBQuery_QONUMDESC
    MSUNION = _tdb.TDBQuery_MSUNION
    MSISECT = _tdb.TDBQuery_MSISECT
    MSDIFF = _tdb.TDBQuery_MSDIFF
TDBQuery_swigregister = _tdb.TDBQuery_swigregister
TDBQuery_swigregister(TDBQuery)

def metasearch(self, other_queries, setop): 
    """Search over multiple queries, including this one.

    Arguments
    other_queries -- TDBQuery, the other queries to search for.
    setop -- int, a set operation. One of MSUNION, MSISECT, MSDIFF 
    """
    def _metasearch():
        yield set(self.search())
        for q in other_queries:
            yield set(q.search())

    set_func = {
       self.MSUNION: set.union,
       self.MSISECT: set.intersection,
       self.MSDIFF: set.difference,
    }[setop]
    return reduce(set_func, _metasearch()) if other_queries else set()

TDBQuery.metasearch = metasearch

del metasearch

def items(self):
    self.iterinit()
    while True:
        key = self.iternext()
        if key is None:
            break
        print "key", repr(key)
        yield (key, self.get(key))

TDB.items = items

del items


def __setitem__(self, key, val): 
    self.put(key, val)

TDB.__setitem__ = __setitem__

del __setitem__

def __getitem__(self, key):
    val = self.get(key)
    if val is None:
        raise KeyError(key)
    return val

TDB.__getitem__ = __getitem__

del __getitem__

def keys(self): 
    """Iterate over all the keys"""
    self.iterinit()
    while True:
        key = self.iternext()
        if key is None:
            break
        yield key

TDB.__iter__ = keys
TDB.keys = keys
del keys

def values(self):
    """Iterator over all the values"""
    for k, v in self.items():
        yield v

TDB.values = values
del values

TDB.query = lambda self: TDBQuery(self)




