#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Sun Nov  2 14:21:41 2014 by generateDS.py version 2.13a.
#
# Command line options:
#   ('-o', 'cap.py')
#   ('-s', 'capsubs.py')
#
# Command line arguments:
#   CAP-v1.2.xsd
#
# Command line:
#   /Users/knichols/Workspace/venv/bin/generateDS.py -o "cap.py" -s "capsubs.py" CAP-v1.2.xsd
#
# Current working directory (os.getcwd()):
#   schema
#

import sys
import getopt
import re as re_
import base64
import datetime as datetime_

etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class alert(GeneratedsSuper):
    """CAP Alert Message (version 1.2)"""
    subclass = None
    superclass = None
    def __init__(self, identifier=None, sender=None, sent=None, status=None, msgType=None, source=None, scope=None, restriction=None, addresses=None, code=None, note=None, references=None, incidents=None, info=None, anytypeobjs_=None):
        self.original_tagname_ = None
        self.identifier = identifier
        self.sender = sender
        if isinstance(sent, basestring):
            initvalue_ = datetime_.datetime.strptime(sent, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = sent
        self.sent = initvalue_
        self.status = status
        self.msgType = msgType
        self.source = source
        self.scope = scope
        self.restriction = restriction
        self.addresses = addresses
        if code is None:
            self.code = []
        else:
            self.code = code
        self.note = note
        self.references = references
        self.incidents = incidents
        if info is None:
            self.info = []
        else:
            self.info = info
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if alert.subclass:
            return alert.subclass(*args_, **kwargs_)
        else:
            return alert(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_identifier(self): return self.identifier
    def set_identifier(self, identifier): self.identifier = identifier
    def get_sender(self): return self.sender
    def set_sender(self, sender): self.sender = sender
    def get_sent(self): return self.sent
    def set_sent(self, sent): self.sent = sent
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_msgType(self): return self.msgType
    def set_msgType(self, msgType): self.msgType = msgType
    def get_source(self): return self.source
    def set_source(self, source): self.source = source
    def get_scope(self): return self.scope
    def set_scope(self, scope): self.scope = scope
    def get_restriction(self): return self.restriction
    def set_restriction(self, restriction): self.restriction = restriction
    def get_addresses(self): return self.addresses
    def set_addresses(self, addresses): self.addresses = addresses
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def add_code(self, value): self.code.append(value)
    def insert_code_at(self, index, value): self.code.insert(index, value)
    def replace_code_at(self, index, value): self.code[index] = value
    def get_note(self): return self.note
    def set_note(self, note): self.note = note
    def get_references(self): return self.references
    def set_references(self, references): self.references = references
    def get_incidents(self): return self.incidents
    def set_incidents(self, incidents): self.incidents = incidents
    def get_info(self): return self.info
    def set_info(self, info): self.info = info
    def add_info(self, value): self.info.append(value)
    def insert_info_at(self, index, value): self.info.insert(index, value)
    def replace_info_at(self, index, value): self.info[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def hasContent_(self):
        if (
            self.identifier is not None or
            self.sender is not None or
            self.sent is not None or
            self.status is not None or
            self.msgType is not None or
            self.source is not None or
            self.scope is not None or
            self.restriction is not None or
            self.addresses is not None or
            self.code or
            self.note is not None or
            self.references is not None or
            self.incidents is not None or
            self.info or
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='alert', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='alert')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='alert', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='alert'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='alert', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.identifier is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sidentifier>%s</%sidentifier>%s' % (namespace_, self.gds_format_string(quote_xml(self.identifier).encode(ExternalEncoding), input_name='identifier'), namespace_, eol_))
        if self.sender is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssender>%s</%ssender>%s' % (namespace_, self.gds_format_string(quote_xml(self.sender).encode(ExternalEncoding), input_name='sender'), namespace_, eol_))
        if self.sent is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssent>%s</%ssent>%s' % (namespace_, self.gds_format_datetime(self.sent, input_name='sent'), namespace_, eol_))
        if self.status is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstatus>%s</%sstatus>%s' % (namespace_, self.gds_format_string(quote_xml(self.status).encode(ExternalEncoding), input_name='status'), namespace_, eol_))
        if self.msgType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smsgType>%s</%smsgType>%s' % (namespace_, self.gds_format_string(quote_xml(self.msgType).encode(ExternalEncoding), input_name='msgType'), namespace_, eol_))
        if self.source is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssource>%s</%ssource>%s' % (namespace_, self.gds_format_string(quote_xml(self.source).encode(ExternalEncoding), input_name='source'), namespace_, eol_))
        if self.scope is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sscope>%s</%sscope>%s' % (namespace_, self.gds_format_string(quote_xml(self.scope).encode(ExternalEncoding), input_name='scope'), namespace_, eol_))
        if self.restriction is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srestriction>%s</%srestriction>%s' % (namespace_, self.gds_format_string(quote_xml(self.restriction).encode(ExternalEncoding), input_name='restriction'), namespace_, eol_))
        if self.addresses is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddresses>%s</%saddresses>%s' % (namespace_, self.gds_format_string(quote_xml(self.addresses).encode(ExternalEncoding), input_name='addresses'), namespace_, eol_))
        for code_ in self.code:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scode>%s</%scode>%s' % (namespace_, self.gds_format_string(quote_xml(code_).encode(ExternalEncoding), input_name='code'), namespace_, eol_))
        if self.note is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snote>%s</%snote>%s' % (namespace_, self.gds_format_string(quote_xml(self.note).encode(ExternalEncoding), input_name='note'), namespace_, eol_))
        if self.references is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreferences>%s</%sreferences>%s' % (namespace_, self.gds_format_string(quote_xml(self.references).encode(ExternalEncoding), input_name='references'), namespace_, eol_))
        if self.incidents is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sincidents>%s</%sincidents>%s' % (namespace_, self.gds_format_string(quote_xml(self.incidents).encode(ExternalEncoding), input_name='incidents'), namespace_, eol_))
        for info_ in self.info:
            info_.export(outfile, level, namespace_, name_='info', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='alert'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.identifier is not None:
            showIndent(outfile, level)
            outfile.write('identifier=%s,\n' % quote_python(self.identifier).encode(ExternalEncoding))
        if self.sender is not None:
            showIndent(outfile, level)
            outfile.write('sender=%s,\n' % quote_python(self.sender).encode(ExternalEncoding))
        if self.sent is not None:
            showIndent(outfile, level)
            outfile.write('sent=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.sent, input_name='sent'))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=%s,\n' % quote_python(self.status).encode(ExternalEncoding))
        if self.msgType is not None:
            showIndent(outfile, level)
            outfile.write('msgType=%s,\n' % quote_python(self.msgType).encode(ExternalEncoding))
        if self.source is not None:
            showIndent(outfile, level)
            outfile.write('source=%s,\n' % quote_python(self.source).encode(ExternalEncoding))
        if self.scope is not None:
            showIndent(outfile, level)
            outfile.write('scope=%s,\n' % quote_python(self.scope).encode(ExternalEncoding))
        if self.restriction is not None:
            showIndent(outfile, level)
            outfile.write('restriction=%s,\n' % quote_python(self.restriction).encode(ExternalEncoding))
        if self.addresses is not None:
            showIndent(outfile, level)
            outfile.write('addresses=%s,\n' % quote_python(self.addresses).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('code=[\n')
        level += 1
        for code_ in self.code:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(code_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.note is not None:
            showIndent(outfile, level)
            outfile.write('note=%s,\n' % quote_python(self.note).encode(ExternalEncoding))
        if self.references is not None:
            showIndent(outfile, level)
            outfile.write('references=%s,\n' % quote_python(self.references).encode(ExternalEncoding))
        if self.incidents is not None:
            showIndent(outfile, level)
            outfile.write('incidents=%s,\n' % quote_python(self.incidents).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('info=[\n')
        level += 1
        for info_ in self.info:
            showIndent(outfile, level)
            outfile.write('model_.info(\n')
            info_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'identifier':
            identifier_ = child_.text
            identifier_ = self.gds_validate_string(identifier_, node, 'identifier')
            self.identifier = identifier_
        elif nodeName_ == 'sender':
            sender_ = child_.text
            sender_ = self.gds_validate_string(sender_, node, 'sender')
            self.sender = sender_
        elif nodeName_ == 'sent':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.sent = dval_
        elif nodeName_ == 'status':
            status_ = child_.text
            status_ = self.gds_validate_string(status_, node, 'status')
            self.status = status_
        elif nodeName_ == 'msgType':
            msgType_ = child_.text
            msgType_ = self.gds_validate_string(msgType_, node, 'msgType')
            self.msgType = msgType_
        elif nodeName_ == 'source':
            source_ = child_.text
            source_ = self.gds_validate_string(source_, node, 'source')
            self.source = source_
        elif nodeName_ == 'scope':
            scope_ = child_.text
            scope_ = self.gds_validate_string(scope_, node, 'scope')
            self.scope = scope_
        elif nodeName_ == 'restriction':
            restriction_ = child_.text
            restriction_ = self.gds_validate_string(restriction_, node, 'restriction')
            self.restriction = restriction_
        elif nodeName_ == 'addresses':
            addresses_ = child_.text
            addresses_ = self.gds_validate_string(addresses_, node, 'addresses')
            self.addresses = addresses_
        elif nodeName_ == 'code':
            code_ = child_.text
            code_ = self.gds_validate_string(code_, node, 'code')
            self.code.append(code_)
        elif nodeName_ == 'note':
            note_ = child_.text
            note_ = self.gds_validate_string(note_, node, 'note')
            self.note = note_
        elif nodeName_ == 'references':
            references_ = child_.text
            references_ = self.gds_validate_string(references_, node, 'references')
            self.references = references_
        elif nodeName_ == 'incidents':
            incidents_ = child_.text
            incidents_ = self.gds_validate_string(incidents_, node, 'incidents')
            self.incidents = incidents_
        elif nodeName_ == 'info':
            obj_ = info.factory()
            obj_.build(child_)
            self.info.append(obj_)
            obj_.original_tagname_ = 'info'
        else:
            obj_ = self.gds_build_any(child_, 'alert')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
# end class alert


class sent(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if sent.subclass:
            return sent.subclass(*args_, **kwargs_)
        else:
            return sent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='sent', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='sent')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='sent', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='sent'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='sent', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='sent'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class sent


class status(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if status.subclass:
            return status.subclass(*args_, **kwargs_)
        else:
            return status(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='status', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='status')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='status', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='status'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='status', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='status'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class status


class msgType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if msgType.subclass:
            return msgType.subclass(*args_, **kwargs_)
        else:
            return msgType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='msgType', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='msgType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='msgType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='msgType'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='msgType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='msgType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class msgType


class scope(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if scope.subclass:
            return scope.subclass(*args_, **kwargs_)
        else:
            return scope(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='scope', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='scope')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='scope', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='scope'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='scope', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='scope'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class scope


class info(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, language='en-US', category=None, event=None, responseType=None, urgency=None, severity=None, certainty=None, audience=None, eventCode=None, effective=None, onset=None, expires=None, senderName=None, headline=None, description=None, instruction=None, web=None, contact=None, parameter=None, resource=None, area=None):
        self.original_tagname_ = None
        self.language = language
        if category is None:
            self.category = []
        else:
            self.category = category
        self.event = event
        if responseType is None:
            self.responseType = []
        else:
            self.responseType = responseType
        self.urgency = urgency
        self.severity = severity
        self.certainty = certainty
        self.audience = audience
        if eventCode is None:
            self.eventCode = []
        else:
            self.eventCode = eventCode
        if isinstance(effective, basestring):
            initvalue_ = datetime_.datetime.strptime(effective, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = effective
        self.effective = initvalue_
        if isinstance(onset, basestring):
            initvalue_ = datetime_.datetime.strptime(onset, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = onset
        self.onset = initvalue_
        if isinstance(expires, basestring):
            initvalue_ = datetime_.datetime.strptime(expires, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = expires
        self.expires = initvalue_
        self.senderName = senderName
        self.headline = headline
        self.description = description
        self.instruction = instruction
        self.web = web
        self.contact = contact
        if parameter is None:
            self.parameter = []
        else:
            self.parameter = parameter
        if resource is None:
            self.resource = []
        else:
            self.resource = resource
        if area is None:
            self.area = []
        else:
            self.area = area
    def factory(*args_, **kwargs_):
        if info.subclass:
            return info.subclass(*args_, **kwargs_)
        else:
            return info(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    def add_category(self, value): self.category.append(value)
    def insert_category_at(self, index, value): self.category.insert(index, value)
    def replace_category_at(self, index, value): self.category[index] = value
    def get_event(self): return self.event
    def set_event(self, event): self.event = event
    def get_responseType(self): return self.responseType
    def set_responseType(self, responseType): self.responseType = responseType
    def add_responseType(self, value): self.responseType.append(value)
    def insert_responseType_at(self, index, value): self.responseType.insert(index, value)
    def replace_responseType_at(self, index, value): self.responseType[index] = value
    def get_urgency(self): return self.urgency
    def set_urgency(self, urgency): self.urgency = urgency
    def get_severity(self): return self.severity
    def set_severity(self, severity): self.severity = severity
    def get_certainty(self): return self.certainty
    def set_certainty(self, certainty): self.certainty = certainty
    def get_audience(self): return self.audience
    def set_audience(self, audience): self.audience = audience
    def get_eventCode(self): return self.eventCode
    def set_eventCode(self, eventCode): self.eventCode = eventCode
    def add_eventCode(self, value): self.eventCode.append(value)
    def insert_eventCode_at(self, index, value): self.eventCode.insert(index, value)
    def replace_eventCode_at(self, index, value): self.eventCode[index] = value
    def get_effective(self): return self.effective
    def set_effective(self, effective): self.effective = effective
    def get_onset(self): return self.onset
    def set_onset(self, onset): self.onset = onset
    def get_expires(self): return self.expires
    def set_expires(self, expires): self.expires = expires
    def get_senderName(self): return self.senderName
    def set_senderName(self, senderName): self.senderName = senderName
    def get_headline(self): return self.headline
    def set_headline(self, headline): self.headline = headline
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_instruction(self): return self.instruction
    def set_instruction(self, instruction): self.instruction = instruction
    def get_web(self): return self.web
    def set_web(self, web): self.web = web
    def get_contact(self): return self.contact
    def set_contact(self, contact): self.contact = contact
    def get_parameter(self): return self.parameter
    def set_parameter(self, parameter): self.parameter = parameter
    def add_parameter(self, value): self.parameter.append(value)
    def insert_parameter_at(self, index, value): self.parameter.insert(index, value)
    def replace_parameter_at(self, index, value): self.parameter[index] = value
    def get_resource(self): return self.resource
    def set_resource(self, resource): self.resource = resource
    def add_resource(self, value): self.resource.append(value)
    def insert_resource_at(self, index, value): self.resource.insert(index, value)
    def replace_resource_at(self, index, value): self.resource[index] = value
    def get_area(self): return self.area
    def set_area(self, area): self.area = area
    def add_area(self, value): self.area.append(value)
    def insert_area_at(self, index, value): self.area.insert(index, value)
    def replace_area_at(self, index, value): self.area[index] = value
    def hasContent_(self):
        if (
            self.language is not None or
            self.category or
            self.event is not None or
            self.responseType or
            self.urgency is not None or
            self.severity is not None or
            self.certainty is not None or
            self.audience is not None or
            self.eventCode or
            self.effective is not None or
            self.onset is not None or
            self.expires is not None or
            self.senderName is not None or
            self.headline is not None or
            self.description is not None or
            self.instruction is not None or
            self.web is not None or
            self.contact is not None or
            self.parameter or
            self.resource or
            self.area
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='info', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='info')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='info', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='info'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='info', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.language is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slanguage>%s</%slanguage>%s' % (namespace_, self.gds_format_string(quote_xml(self.language).encode(ExternalEncoding), input_name='language'), namespace_, eol_))
        for category_ in self.category:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scategory>%s</%scategory>%s' % (namespace_, self.gds_format_string(quote_xml(category_).encode(ExternalEncoding), input_name='category'), namespace_, eol_))
        if self.event is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sevent>%s</%sevent>%s' % (namespace_, self.gds_format_string(quote_xml(self.event).encode(ExternalEncoding), input_name='event'), namespace_, eol_))
        for responseType_ in self.responseType:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresponseType>%s</%sresponseType>%s' % (namespace_, self.gds_format_string(quote_xml(responseType_).encode(ExternalEncoding), input_name='responseType'), namespace_, eol_))
        if self.urgency is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%surgency>%s</%surgency>%s' % (namespace_, self.gds_format_string(quote_xml(self.urgency).encode(ExternalEncoding), input_name='urgency'), namespace_, eol_))
        if self.severity is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sseverity>%s</%sseverity>%s' % (namespace_, self.gds_format_string(quote_xml(self.severity).encode(ExternalEncoding), input_name='severity'), namespace_, eol_))
        if self.certainty is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scertainty>%s</%scertainty>%s' % (namespace_, self.gds_format_string(quote_xml(self.certainty).encode(ExternalEncoding), input_name='certainty'), namespace_, eol_))
        if self.audience is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saudience>%s</%saudience>%s' % (namespace_, self.gds_format_string(quote_xml(self.audience).encode(ExternalEncoding), input_name='audience'), namespace_, eol_))
        for eventCode_ in self.eventCode:
            eventCode_.export(outfile, level, namespace_, name_='eventCode', pretty_print=pretty_print)
        if self.effective is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%seffective>%s</%seffective>%s' % (namespace_, self.gds_format_datetime(self.effective, input_name='effective'), namespace_, eol_))
        if self.onset is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sonset>%s</%sonset>%s' % (namespace_, self.gds_format_datetime(self.onset, input_name='onset'), namespace_, eol_))
        if self.expires is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sexpires>%s</%sexpires>%s' % (namespace_, self.gds_format_datetime(self.expires, input_name='expires'), namespace_, eol_))
        if self.senderName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssenderName>%s</%ssenderName>%s' % (namespace_, self.gds_format_string(quote_xml(self.senderName).encode(ExternalEncoding), input_name='senderName'), namespace_, eol_))
        if self.headline is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sheadline>%s</%sheadline>%s' % (namespace_, self.gds_format_string(quote_xml(self.headline).encode(ExternalEncoding), input_name='headline'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.instruction is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstruction>%s</%sinstruction>%s' % (namespace_, self.gds_format_string(quote_xml(self.instruction).encode(ExternalEncoding), input_name='instruction'), namespace_, eol_))
        if self.web is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sweb>%s</%sweb>%s' % (namespace_, self.gds_format_string(quote_xml(self.web).encode(ExternalEncoding), input_name='web'), namespace_, eol_))
        if self.contact is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scontact>%s</%scontact>%s' % (namespace_, self.gds_format_string(quote_xml(self.contact).encode(ExternalEncoding), input_name='contact'), namespace_, eol_))
        for parameter_ in self.parameter:
            parameter_.export(outfile, level, namespace_, name_='parameter', pretty_print=pretty_print)
        for resource_ in self.resource:
            resource_.export(outfile, level, namespace_, name_='resource', pretty_print=pretty_print)
        for area_ in self.area:
            area_.export(outfile, level, namespace_, name_='area', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='info'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.language is not None:
            showIndent(outfile, level)
            outfile.write('language=%s,\n' % quote_python(self.language).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('category=[\n')
        level += 1
        for category_ in self.category:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(category_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.event is not None:
            showIndent(outfile, level)
            outfile.write('event=%s,\n' % quote_python(self.event).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('responseType=[\n')
        level += 1
        for responseType_ in self.responseType:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(responseType_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.urgency is not None:
            showIndent(outfile, level)
            outfile.write('urgency=%s,\n' % quote_python(self.urgency).encode(ExternalEncoding))
        if self.severity is not None:
            showIndent(outfile, level)
            outfile.write('severity=%s,\n' % quote_python(self.severity).encode(ExternalEncoding))
        if self.certainty is not None:
            showIndent(outfile, level)
            outfile.write('certainty=%s,\n' % quote_python(self.certainty).encode(ExternalEncoding))
        if self.audience is not None:
            showIndent(outfile, level)
            outfile.write('audience=%s,\n' % quote_python(self.audience).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('eventCode=[\n')
        level += 1
        for eventCode_ in self.eventCode:
            showIndent(outfile, level)
            outfile.write('model_.eventCode(\n')
            eventCode_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.effective is not None:
            showIndent(outfile, level)
            outfile.write('effective=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.effective, input_name='effective'))
        if self.onset is not None:
            showIndent(outfile, level)
            outfile.write('onset=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.onset, input_name='onset'))
        if self.expires is not None:
            showIndent(outfile, level)
            outfile.write('expires=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.expires, input_name='expires'))
        if self.senderName is not None:
            showIndent(outfile, level)
            outfile.write('senderName=%s,\n' % quote_python(self.senderName).encode(ExternalEncoding))
        if self.headline is not None:
            showIndent(outfile, level)
            outfile.write('headline=%s,\n' % quote_python(self.headline).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.instruction is not None:
            showIndent(outfile, level)
            outfile.write('instruction=%s,\n' % quote_python(self.instruction).encode(ExternalEncoding))
        if self.web is not None:
            showIndent(outfile, level)
            outfile.write('web=%s,\n' % quote_python(self.web).encode(ExternalEncoding))
        if self.contact is not None:
            showIndent(outfile, level)
            outfile.write('contact=%s,\n' % quote_python(self.contact).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('parameter=[\n')
        level += 1
        for parameter_ in self.parameter:
            showIndent(outfile, level)
            outfile.write('model_.parameter(\n')
            parameter_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('resource=[\n')
        level += 1
        for resource_ in self.resource:
            showIndent(outfile, level)
            outfile.write('model_.resource(\n')
            resource_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('area=[\n')
        level += 1
        for area_ in self.area:
            showIndent(outfile, level)
            outfile.write('model_.area(\n')
            area_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'language':
            language_ = child_.text
            language_ = self.gds_validate_string(language_, node, 'language')
            self.language = language_
        elif nodeName_ == 'category':
            category_ = child_.text
            category_ = self.gds_validate_string(category_, node, 'category')
            self.category.append(category_)
        elif nodeName_ == 'event':
            event_ = child_.text
            event_ = self.gds_validate_string(event_, node, 'event')
            self.event = event_
        elif nodeName_ == 'responseType':
            responseType_ = child_.text
            responseType_ = self.gds_validate_string(responseType_, node, 'responseType')
            self.responseType.append(responseType_)
        elif nodeName_ == 'urgency':
            urgency_ = child_.text
            urgency_ = self.gds_validate_string(urgency_, node, 'urgency')
            self.urgency = urgency_
        elif nodeName_ == 'severity':
            severity_ = child_.text
            severity_ = self.gds_validate_string(severity_, node, 'severity')
            self.severity = severity_
        elif nodeName_ == 'certainty':
            certainty_ = child_.text
            certainty_ = self.gds_validate_string(certainty_, node, 'certainty')
            self.certainty = certainty_
        elif nodeName_ == 'audience':
            audience_ = child_.text
            audience_ = self.gds_validate_string(audience_, node, 'audience')
            self.audience = audience_
        elif nodeName_ == 'eventCode':
            obj_ = eventCode.factory()
            obj_.build(child_)
            self.eventCode.append(obj_)
            obj_.original_tagname_ = 'eventCode'
        elif nodeName_ == 'effective':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.effective = dval_
        elif nodeName_ == 'onset':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.onset = dval_
        elif nodeName_ == 'expires':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.expires = dval_
        elif nodeName_ == 'senderName':
            senderName_ = child_.text
            senderName_ = self.gds_validate_string(senderName_, node, 'senderName')
            self.senderName = senderName_
        elif nodeName_ == 'headline':
            headline_ = child_.text
            headline_ = self.gds_validate_string(headline_, node, 'headline')
            self.headline = headline_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'instruction':
            instruction_ = child_.text
            instruction_ = self.gds_validate_string(instruction_, node, 'instruction')
            self.instruction = instruction_
        elif nodeName_ == 'web':
            web_ = child_.text
            web_ = self.gds_validate_string(web_, node, 'web')
            self.web = web_
        elif nodeName_ == 'contact':
            contact_ = child_.text
            contact_ = self.gds_validate_string(contact_, node, 'contact')
            self.contact = contact_
        elif nodeName_ == 'parameter':
            obj_ = parameter.factory()
            obj_.build(child_)
            self.parameter.append(obj_)
            obj_.original_tagname_ = 'parameter'
        elif nodeName_ == 'resource':
            obj_ = resource.factory()
            obj_.build(child_)
            self.resource.append(obj_)
            obj_.original_tagname_ = 'resource'
        elif nodeName_ == 'area':
            obj_ = area.factory()
            obj_.build(child_)
            self.area.append(obj_)
            obj_.original_tagname_ = 'area'
# end class info


class category(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if category.subclass:
            return category.subclass(*args_, **kwargs_)
        else:
            return category(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='category', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='category')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='category', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='category'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='category', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='category'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class category


class responseType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if responseType.subclass:
            return responseType.subclass(*args_, **kwargs_)
        else:
            return responseType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='responseType', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='responseType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='responseType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='responseType'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='responseType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='responseType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class responseType


class urgency(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if urgency.subclass:
            return urgency.subclass(*args_, **kwargs_)
        else:
            return urgency(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='urgency', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='urgency')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='urgency', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='urgency'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='urgency', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='urgency'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class urgency


class severity(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if severity.subclass:
            return severity.subclass(*args_, **kwargs_)
        else:
            return severity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='severity', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='severity')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='severity', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='severity'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='severity', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='severity'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class severity


class certainty(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if certainty.subclass:
            return certainty.subclass(*args_, **kwargs_)
        else:
            return certainty(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='certainty', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='certainty')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='certainty', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='certainty'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='certainty', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='certainty'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class certainty


class eventCode(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueName=None, value=None):
        self.original_tagname_ = None
        self.valueName = valueName
        self.value = value
    def factory(*args_, **kwargs_):
        if eventCode.subclass:
            return eventCode.subclass(*args_, **kwargs_)
        else:
            return eventCode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueName(self): return self.valueName
    def set_valueName(self, valueName): self.valueName = valueName
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def hasContent_(self):
        if (
            self.valueName is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='eventCode', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='eventCode')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='eventCode', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='eventCode'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='eventCode', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.valueName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalueName>%s</%svalueName>%s' % ('cap:', self.gds_format_string(quote_xml(self.valueName).encode(ExternalEncoding), input_name='valueName'), 'cap:', eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % ('cap:', self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), 'cap:', eol_))
    def exportLiteral(self, outfile, level, name_='eventCode'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.valueName is not None:
            showIndent(outfile, level)
            outfile.write('valueName=%s,\n' % quote_python(self.valueName).encode(ExternalEncoding))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'valueName':
            valueName_ = child_.text
            valueName_ = self.gds_validate_string(valueName_, node, 'valueName')
            self.valueName = valueName_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class eventCode


class effective(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if effective.subclass:
            return effective.subclass(*args_, **kwargs_)
        else:
            return effective(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='effective', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='effective')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='effective', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='effective'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='effective', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='effective'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class effective


class onset(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if onset.subclass:
            return onset.subclass(*args_, **kwargs_)
        else:
            return onset(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='onset', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='onset')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='onset', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='onset'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='onset', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='onset'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class onset


class expires(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if expires.subclass:
            return expires.subclass(*args_, **kwargs_)
        else:
            return expires(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='expires', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='expires')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='expires', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='expires'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='expires', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='expires'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class expires


class parameter(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueName=None, value=None):
        self.original_tagname_ = None
        self.valueName = valueName
        self.value = value
    def factory(*args_, **kwargs_):
        if parameter.subclass:
            return parameter.subclass(*args_, **kwargs_)
        else:
            return parameter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueName(self): return self.valueName
    def set_valueName(self, valueName): self.valueName = valueName
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def hasContent_(self):
        if (
            self.valueName is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='parameter', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='parameter')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='parameter', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='parameter'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='parameter', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.valueName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalueName>%s</%svalueName>%s' % ('cap:', self.gds_format_string(quote_xml(self.valueName).encode(ExternalEncoding), input_name='valueName'), 'cap:', eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % ('cap:', self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), 'cap:', eol_))
    def exportLiteral(self, outfile, level, name_='parameter'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.valueName is not None:
            showIndent(outfile, level)
            outfile.write('valueName=%s,\n' % quote_python(self.valueName).encode(ExternalEncoding))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'valueName':
            valueName_ = child_.text
            valueName_ = self.gds_validate_string(valueName_, node, 'valueName')
            self.valueName = valueName_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class parameter


class resource(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, resourceDesc=None, mimeType=None, size=None, uri=None, derefUri=None, digest=None):
        self.original_tagname_ = None
        self.resourceDesc = resourceDesc
        self.mimeType = mimeType
        self.size = size
        self.uri = uri
        self.derefUri = derefUri
        self.digest = digest
    def factory(*args_, **kwargs_):
        if resource.subclass:
            return resource.subclass(*args_, **kwargs_)
        else:
            return resource(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_resourceDesc(self): return self.resourceDesc
    def set_resourceDesc(self, resourceDesc): self.resourceDesc = resourceDesc
    def get_mimeType(self): return self.mimeType
    def set_mimeType(self, mimeType): self.mimeType = mimeType
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_derefUri(self): return self.derefUri
    def set_derefUri(self, derefUri): self.derefUri = derefUri
    def get_digest(self): return self.digest
    def set_digest(self, digest): self.digest = digest
    def hasContent_(self):
        if (
            self.resourceDesc is not None or
            self.mimeType is not None or
            self.size is not None or
            self.uri is not None or
            self.derefUri is not None or
            self.digest is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='resource', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='resource')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='resource', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='resource'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='resource', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.resourceDesc is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresourceDesc>%s</%sresourceDesc>%s' % (namespace_, self.gds_format_string(quote_xml(self.resourceDesc).encode(ExternalEncoding), input_name='resourceDesc'), namespace_, eol_))
        if self.mimeType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smimeType>%s</%smimeType>%s' % (namespace_, self.gds_format_string(quote_xml(self.mimeType).encode(ExternalEncoding), input_name='mimeType'), namespace_, eol_))
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.derefUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sderefUri>%s</%sderefUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.derefUri).encode(ExternalEncoding), input_name='derefUri'), namespace_, eol_))
        if self.digest is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdigest>%s</%sdigest>%s' % (namespace_, self.gds_format_string(quote_xml(self.digest).encode(ExternalEncoding), input_name='digest'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='resource'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.resourceDesc is not None:
            showIndent(outfile, level)
            outfile.write('resourceDesc=%s,\n' % quote_python(self.resourceDesc).encode(ExternalEncoding))
        if self.mimeType is not None:
            showIndent(outfile, level)
            outfile.write('mimeType=%s,\n' % quote_python(self.mimeType).encode(ExternalEncoding))
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.derefUri is not None:
            showIndent(outfile, level)
            outfile.write('derefUri=%s,\n' % quote_python(self.derefUri).encode(ExternalEncoding))
        if self.digest is not None:
            showIndent(outfile, level)
            outfile.write('digest=%s,\n' % quote_python(self.digest).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'resourceDesc':
            resourceDesc_ = child_.text
            resourceDesc_ = self.gds_validate_string(resourceDesc_, node, 'resourceDesc')
            self.resourceDesc = resourceDesc_
        elif nodeName_ == 'mimeType':
            mimeType_ = child_.text
            mimeType_ = self.gds_validate_string(mimeType_, node, 'mimeType')
            self.mimeType = mimeType_
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'derefUri':
            derefUri_ = child_.text
            derefUri_ = self.gds_validate_string(derefUri_, node, 'derefUri')
            self.derefUri = derefUri_
        elif nodeName_ == 'digest':
            digest_ = child_.text
            digest_ = self.gds_validate_string(digest_, node, 'digest')
            self.digest = digest_
# end class resource


class area(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, areaDesc=None, polygon=None, circle=None, geocode=None, altitude=None, ceiling=None):
        self.original_tagname_ = None
        self.areaDesc = areaDesc
        if polygon is None:
            self.polygon = []
        else:
            self.polygon = polygon
        if circle is None:
            self.circle = []
        else:
            self.circle = circle
        if geocode is None:
            self.geocode = []
        else:
            self.geocode = geocode
        self.altitude = altitude
        self.ceiling = ceiling
    def factory(*args_, **kwargs_):
        if area.subclass:
            return area.subclass(*args_, **kwargs_)
        else:
            return area(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_areaDesc(self): return self.areaDesc
    def set_areaDesc(self, areaDesc): self.areaDesc = areaDesc
    def get_polygon(self): return self.polygon
    def set_polygon(self, polygon): self.polygon = polygon
    def add_polygon(self, value): self.polygon.append(value)
    def insert_polygon_at(self, index, value): self.polygon.insert(index, value)
    def replace_polygon_at(self, index, value): self.polygon[index] = value
    def get_circle(self): return self.circle
    def set_circle(self, circle): self.circle = circle
    def add_circle(self, value): self.circle.append(value)
    def insert_circle_at(self, index, value): self.circle.insert(index, value)
    def replace_circle_at(self, index, value): self.circle[index] = value
    def get_geocode(self): return self.geocode
    def set_geocode(self, geocode): self.geocode = geocode
    def add_geocode(self, value): self.geocode.append(value)
    def insert_geocode_at(self, index, value): self.geocode.insert(index, value)
    def replace_geocode_at(self, index, value): self.geocode[index] = value
    def get_altitude(self): return self.altitude
    def set_altitude(self, altitude): self.altitude = altitude
    def get_ceiling(self): return self.ceiling
    def set_ceiling(self, ceiling): self.ceiling = ceiling
    def hasContent_(self):
        if (
            self.areaDesc is not None or
            self.polygon or
            self.circle or
            self.geocode or
            self.altitude is not None or
            self.ceiling is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='area', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='area')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='area', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='area'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='area', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.areaDesc is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sareaDesc>%s</%sareaDesc>%s' % (namespace_, self.gds_format_string(quote_xml(self.areaDesc).encode(ExternalEncoding), input_name='areaDesc'), namespace_, eol_))
        for polygon_ in self.polygon:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spolygon>%s</%spolygon>%s' % (namespace_, self.gds_format_string(quote_xml(polygon_).encode(ExternalEncoding), input_name='polygon'), namespace_, eol_))
        for circle_ in self.circle:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scircle>%s</%scircle>%s' % (namespace_, self.gds_format_string(quote_xml(circle_).encode(ExternalEncoding), input_name='circle'), namespace_, eol_))
        for geocode_ in self.geocode:
            geocode_.export(outfile, level, namespace_, name_='geocode', pretty_print=pretty_print)
        if self.altitude is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saltitude>%s</%saltitude>%s' % (namespace_, self.gds_format_float(self.altitude, input_name='altitude'), namespace_, eol_))
        if self.ceiling is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sceiling>%s</%sceiling>%s' % (namespace_, self.gds_format_float(self.ceiling, input_name='ceiling'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='area'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.areaDesc is not None:
            showIndent(outfile, level)
            outfile.write('areaDesc=%s,\n' % quote_python(self.areaDesc).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('polygon=[\n')
        level += 1
        for polygon_ in self.polygon:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(polygon_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('circle=[\n')
        level += 1
        for circle_ in self.circle:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(circle_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('geocode=[\n')
        level += 1
        for geocode_ in self.geocode:
            showIndent(outfile, level)
            outfile.write('model_.geocode(\n')
            geocode_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.altitude is not None:
            showIndent(outfile, level)
            outfile.write('altitude=%f,\n' % self.altitude)
        if self.ceiling is not None:
            showIndent(outfile, level)
            outfile.write('ceiling=%f,\n' % self.ceiling)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'areaDesc':
            areaDesc_ = child_.text
            areaDesc_ = self.gds_validate_string(areaDesc_, node, 'areaDesc')
            self.areaDesc = areaDesc_
        elif nodeName_ == 'polygon':
            polygon_ = child_.text
            polygon_ = self.gds_validate_string(polygon_, node, 'polygon')
            self.polygon.append(polygon_)
        elif nodeName_ == 'circle':
            circle_ = child_.text
            circle_ = self.gds_validate_string(circle_, node, 'circle')
            self.circle.append(circle_)
        elif nodeName_ == 'geocode':
            obj_ = geocode.factory()
            obj_.build(child_)
            self.geocode.append(obj_)
            obj_.original_tagname_ = 'geocode'
        elif nodeName_ == 'altitude':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'altitude')
            self.altitude = fval_
        elif nodeName_ == 'ceiling':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'ceiling')
            self.ceiling = fval_
# end class area


class geocode(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueName=None, value=None):
        self.original_tagname_ = None
        self.valueName = valueName
        self.value = value
    def factory(*args_, **kwargs_):
        if geocode.subclass:
            return geocode.subclass(*args_, **kwargs_)
        else:
            return geocode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueName(self): return self.valueName
    def set_valueName(self, valueName): self.valueName = valueName
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def hasContent_(self):
        if (
            self.valueName is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='cap:', name_='geocode', namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='geocode')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='cap:', name_='geocode', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='cap:', name_='geocode'):
        pass
    def exportChildren(self, outfile, level, namespace_='cap:', name_='geocode', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.valueName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalueName>%s</%svalueName>%s' % ('cap:', self.gds_format_string(quote_xml(self.valueName).encode(ExternalEncoding), input_name='valueName'), 'cap:', eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % ('cap:', self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), 'cap:', eol_))
    def exportLiteral(self, outfile, level, name_='geocode'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.valueName is not None:
            showIndent(outfile, level)
            outfile.write('valueName=%s,\n' % quote_python(self.valueName).encode(ExternalEncoding))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'valueName':
            valueName_ = child_.text
            valueName_ = self.gds_validate_string(valueName_, node, 'valueName')
            self.valueName = valueName_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class geocode


GDSClassesMapping = {
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'alert'
        rootClass = alert
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'alert'
        rootClass = alert
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'alert'
        rootClass = alert
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"')
    return rootObj


def parseLiteral(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'alert'
        rootClass = alert
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from cap import *\n\n')
        sys.stdout.write('import cap as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "alert",
    "area",
    "category",
    "certainty",
    "effective",
    "eventCode",
    "expires",
    "geocode",
    "info",
    "msgType",
    "onset",
    "parameter",
    "resource",
    "responseType",
    "scope",
    "sent",
    "severity",
    "status",
    "urgency"
]
