#!/usr/bin/env python
from setuptools import setup

# Release:
# 1. Bump version below
# 2. git tag -a -m "Version 0.1.5" v0.1.5
# 3. python setup.py register sdist upload

__version__ = "0.1.6"


def read_long_description(filename="README.rst"):
    with open(filename) as f:
        return f.read().strip()


def read_requirements(filename="requirements.txt"):
    with open(filename) as f:
        return f.readlines()

setup(
    name="cassette",
    version=__version__,
    author="Charles-Axel Dein",
    author_email="charles@uber.com",
    url="https://github.com/uber/cassette",
    packages=["cassette"],
    keywords=["http", "tests", "mock"],
    description="Cassette is a testing tool that stores external HTTP request in YAML file.",
    long_description=read_long_description(),
    install_requires=read_requirements(),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Environment :: Web Environment",
        "Programming Language :: Python",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Topic :: Internet :: WWW/HTTP",
        "Topic :: Software Development :: Testing",
        "Topic :: Software Development :: Libraries :: Python Modules"
    ]
)
