#!/usr/bin/env python

import unittest, cherrypy
from cdap.controllers import Root
from simplejson import loads as json_to_py
import turbogears.testutil as util

def GET(url,headers={}):
    util.createRequest(url,headers=headers)
    return cherrypy.response.body[0]


cherrypy.config.update({'global' : {'server.environment' : 'development',
                                    'server.logToScreen' : False,
                                    }})

cherrypy.root = Root()

class ControllerTest(unittest.TestCase):
    def test_basics(self):
        r = json_to_py(GET("/?uni=anp8"))
        assert r['found']
        assert r['firstname'] == "Anders N."
        assert r['lastname'] == "Pearson"

        r = json_to_py(GET("/?uni=foobar"))
        assert not r['found']
	  
