import ldap

def ldap_lookup(uni=""):
    firstname = ""
    lastname = ""
    LDAP_SERVER = "ldap.columbia.edu"
    BASE_DN = "o=Columbia University, c=us"
    l = ldap.open(LDAP_SERVER)
    baseDN = BASE_DN
    searchScope = ldap.SCOPE_SUBTREE
    retrieveAttributes = None
    searchFilter = "uni=%s" % uni
    ldap_result_id = l.search(baseDN, searchScope, searchFilter, retrieveAttributes)
    results_dict = {'found' : False, 'lastname' : '', 'firstname' : ''}
    while 1:
        result_type, result_data = l.result(ldap_result_id, 0)
        if result_data == []:
            break
        else:
            if result_type == ldap.RES_SEARCH_ENTRY:
                results_dict['found'] = True
                values = result_data[0][1]
                for k, v in values.items():
                    results_dict[k] = ", ".join(v)
                    if k == 'sn':
                        results_dict['lastname'] = v[0]
                    if k == 'givenname':
                        results_dict['firstname'] = v[0]
                    if k == 'givenName':
                        results_dict['firstname'] = v[0]
                    if k == 'telephoneNumber':
                        results_dict['telephonenumber'] = v[0]

    if results_dict['lastname'] == "":
        results_dict['lastname'] = uni
    return results_dict
    
    
