from cdap import ldap_lookup
import simplejson

import selector

class WSGIRoot:
    def __call__(self,environ,start_response):
        # normally a bad idea, but since we only care about one param
        # which can't contain anything but \w chars, this is safe enough:
        uni = environ['QUERY_STRING'][len('uni='):]
        start_response("200 OK",[("Content-Type","application/json")])
        yield simplejson.dumps(ldap_lookup(uni))

urls = selector.Selector()
urls.add('/', _ANY_=WSGIRoot())


