from collections import namedtuple

from colorama import init, Fore, Style


WarningLevel = namedtuple('WarningLevel', 'indicator colour')


class Feedback(object):
    """
    System for handling notifications to user
    """

    OK = 0
    INFO = 1
    WARNING = 2
    ERROR = 3

    def __init__(self):
        self.levels = {
            self.OK: WarningLevel(' OK ', Fore.GREEN),
            self.INFO: WarningLevel('INFO', Style.DIM),
            self.WARNING: WarningLevel('WARN', Fore.YELLOW),
            self.ERROR: WarningLevel('FAIL', Fore.RED),
        }
        init()

    def input(self, question, options):
        """
        Ask user a question, ensure that one of the options is returned
        """
        selection = raw_input(question)
        # TODO check that selection is in options, else reprompt
        return selection

    def output(self, level, message, space_after=False):
        """
        Show ``message`` to user, at level of ``level``

        If ``space_after`` is True, then additional space will be added after
        the message.
        """
        if space_after:
            message = message + '\n'

        try:
            level_indicator = '{}[{}] '.format(
                self.levels[level].colour,
                Style.BRIGHT + self.levels[level].indicator + Style.NORMAL,
            )
            print(level_indicator + message + Style.RESET_ALL)
        except KeyError:
            print(message)
