import os

from setuptools import setup


here = os.path.abspath(os.path.dirname(__file__))


def long_desc():
    with open(os.path.join(here, 'long_desc.rst')) as f:
        return f.read()


setup(
    name='chattydotfiles',
    version='0.2',
    description='A verbose dotfiles manager',
    url='http://github.com/jamescooke/chattydotfiles',
    author='James Cooke',
    author_email='github@jamescooke.info',
    license='MIT',
    packages=['chattydotfiles'],
    entry_points={
        'console_scripts': ['chattydotfiles=chattydotfiles.command_line:main'],
    },
    install_requires=[
        'colorama',
    ],
    long_description=long_desc(),
)
