# ChattyDotfiles

## Test Status

[![Build Status](https://travis-ci.org/jamescooke/chattydotfiles.svg?branch=master)](https://travis-ci.org/jamescooke/chattydotfiles)

## Simple use

### Warnings

ChattyDotfiles is currently working but basic.

* Add functionality is very basic. If a file already exists in the store with
  the same filename as the file you're trying to add, then you may lose your
  file.
* Sync works and is safe, but is in basic state - it tells the user to fix
  problems rather than being helpful.

### Installation

Grab latest from [pypi](https://pypi.python.org/pypi) with `pip`:

```
pip install chattydotfiles
```

### Starting from scratch

If you're starting a new dotfiles repository from scratch:

1. Create a store under your home directory.

    ```
    cd
    mkdir -p dotfiles/store
    ```

2. Track it with your favourite SCM.

    ```
    git init dotfiles
    ```

3. Add any files you wish to track to the store. In this example `.bashrc` is
added.

    ```
    chattydotfiles --add .bashrc
    ```

4. Ensure that your store is shared with your other machines - commit to your
SCM, sync your Dropbox, etc.

5. When changes arrive in your stored folder, use chatty to ensure that new
files are linked - the raw command will provide verbose sync.

    ```
    chattydofiles
    ```

### Integrating with an existing system

If you've got a chatty dotfiles store folder to use on a machine that's already
configured:

1. Copy the store file into the `dotfiles` folder in your home.

    ```
    mkdir dotfiles
    cp -r /media/disk/dotfiles/store dotfiles
    ```

    Or use your SCM to bring down a copy:

    ```
    git clone git@github.com:your/dotfiles.git
    ```

2. Then run a `sync` and chatty will compare your local dotfiles with those in
the store, prompting you to use 'store', 'local' or skip.

## Aims

To be an overly verbose, interactive, simple and clear dotfiles manager
written in Python.


### Testing todos

* Test on Python 2.6 and 3+
* Test on MacOS
* Check coverage


## Goals

ChattyDotfiles aims to:

* Be clear with the user what actions are being taken at each step.
* Offer options when there are possibilities of different solutions during
  ``sync`` or ``add``. For example, when ``sync`` finds a dotfile in the store
  that also has a version with the same name but different content in the home
  directory, it offers the user to use their home version, the store version or
  skip.
* Manage configuration files where the file itself might not start with a
  '.', for example `.local/share/applications/my_shortcut`
* Only sync the files in the store folder leaving 'space' for configuration if
  required in the repository. Initially however, the goal is to run without
  configuration.


## For who?

Probably just for me since I have some specific requirements, but feel free to
fork and contribute. I've made it public so that I can twist my friends' arms
into reading my code and telling me what I'm doing wrong.


## License

**MIT** Just in case someone finds something useful and wants to use it for
something productive.
