Что такое Chewy?
================

_CHEWY_ расшифровывается как _CMake Helpers Easy Way sYnchronizer_.
Эта утилита позволяет проверять версии CMake-модулей используемых в Вашем проекте и
синхронизировать их с модулями из удаленного репозитория или нескольких, поддерживая тем самым их актуальность.
Таким образом Вы всегда будете уверены, что во всех проектах одни и те же самые последние версии CMake-модулей.


Зачем все это?
==============

Если вы опытный разработчик, использующий в своем workflow билд-систему на основе CMake, то вам должна быть хорошо
знакома такая ситуация. Для очередного проекта вы пишете CMake-модуль (это может быть finder библиотеки или
просто разнообразные хелперы). А спустя какое-то время вы переносите этот модуль в
свежесозданный проект. Как результат, в какой-то момент вы обнаруживаете
множество разнообразных проектов с десятками не синхронизированных самописных CMake-модулей.
Свежие содержат новые версии, в проектах с более почтенным возрастом версии хотелось бы обновлять.

Хотя нередки и ситуации, когда мы возвращаемся к заброшенному годы назад проекту и, в порыве программерского
творчества, добавляем изменения и в его билд-систему, а позже понимаем, что столь гениальные находки просто
необходимо забрать в остальные проекты!..

В такие моменты в голове начинает формироваться некое смутное желание: вот бы держать все модули (аккуратно
отсортированными, классифицированными и снабженными бирочками) в собственном отдельном хранилище и
иметь возможность синхронизировать их в разных проектах! Пытливый программерский ум тут же подсказывает решение —
сложить все модули в отдельном репозитории под управлением любимой VCS (Version Control System) и подключать его как
внешний (external) репозиторий к своему проекту. Но вот беда! Репозиторий содержит множество файлов, а в отдельном проекте нужны лишь
один-два-три из них! Не говоря уж про сложности работы с внешними репозиториями в распределенных системах
контроля версий. Короче говоря, лень побеждает. Энтропия в рабочей директории стремительно неубывает.
А на Новый Год в письме Деду Морозу Вы
пишете, что было бы здорово получить в подарок что-то вроде простого пакетного менеджера для управления
собственными CMake-модулями! Но в глубине души знаете, что ночью любимая супруга положит под елку очередной
полувер в клеточку…

Знакомая ситуация? Тогда знакомьтесь с нашим очаровательным лохматым (shaggy) вторым пилотом — Chewy!

При работе над разнообразными проектами, количество CMake-модулей, которые приходится разрабатывать
только увеличивается. Время от времени их приходится копировать из проекта в проект, и затем следить,
чтобы изменения в модуле, сделанные в одном проекте, попали во все остальные. При этом, как уже
было сказано, в разных проектах испольузется разный набор этих модулей.

Опыт проекта [ac-archive](http://ac-archive.sourceforge.net/) показывает, что в перспективе, модулей,
расширяющих функционал билд-системы, может быть довольно значительное количество. Кроме того, многие из них
могли бы пригодиться кому-то еще — как правило новый модуль пишется лишь после того, как не было найдено
ничего подходящего среди стандартных и через поисковые системы в других Open Source проектах. К сожалению
`ac-archive` прошел долгий путь от никому неизвестного проекта, до "известного в узких кругах", и еще более
длинный путь до того, как в некоторых дистрибутивах Linux появился пакет, обновляемый с выходом новой версии
соответствующего дистрибутива.

Поэтому _Chewy_ задумывался как средство управления CMake-модулями из репозиториев, чтобы, в перспективе,
не ждать дистростроителей, а дать пользователям возможность быстро создавать свои репозитории и/или подключать
сторонние, созданные другими людьми. В целом, чем-то это похоже на оверлеи в Gentoo.


Как использовать `chewy`?
=======================

`chewy` имеет всего 4 команды позволяющие просматривать содержимое удаленных _chewy_-репозитрориев,
устанавливать и обновлять из них модули.

Для просмотра содержимого удаленного репозиторя можно воспользоваться командой

    $ chewy list [repo-URL1 [... repo-URLn]]

Результатом будет список доступных для установки модулей, их версий и описаний.
Если `URL` не был задан, `chewy` пытается угадать где в текущем проекте находятся CMake-модули,
и ищет URL репозитория в уже установленных модулях.


Для добваления нового модуля нужно воспользоваться командой `install`

    $ chewy install file-URL1 [... file-URLn]


Для удаления, установленного ранее модуля и всех зависимых файлов, используется команда `uninstall`. Заметим,
что удаление пустых поддиректорий, которые могут оставаться при деинсталяции модуля со сложной структурой,
остается на совести пользователя.

    $ chewy uninstall file-PATH1 [... file-URLn]


Для проверки доступных обновлений

    $ chewy status [file-URL ...]

Результатом этой команды будет вывод

    U|M filename local-version remote-version

где,

- **U** - есть более новая версия данного модуля
- **M** - локальная копия модуля имеет более новую версию

Если `file-URL` не задан, доступные обновления будут отображаться для всех использованных репозиториев.


Для получения обновлений установленных модулей

    $ chewy update [file-URL ...]

Если `file-URL` не задан, обновятся все модули, для которых есть более новые версии во всех используемых
репозиториях.


Создание собственного chewy-репозитория
=======================================

Чтобы превратить обычный CMake-модуль в _Chewy-модуль_ достаточно лишь добавить несколько комментариев
(строк, начинающихся с символа `#`), содержащих специально оформленную метаинформацию. Это просто текстовые поля,
которые могут располагаться в любом месте файла. В модулях нашего [репозитория](https://github.com/mutanabbi/chewy-cmake-rep)
мы добавляем эти поля в конец модулей, чтобы не перегружать начало CMake-файла, где традиционно содержатся
комментарии о том, как пользоваться модулем.


**Внимание:**
Для простоты поиска модуля среди прочих файлов, `chewy` ожидает, что его имя оканчивается расширением `.cmake`.
На зависимые от этого модуля файлы расширений данное ограничение не распространяется. Они могут иметь любое
расширение или не иметь его вовсе


Итак, модулю необходимы следующие поля:

- `X-Chewy-Repobase: URL`
    поле указывает на базовый URL репозитария. На данный момент поддерживается HTTP и HTTPS протоколы.
- `X-Chewy-Path: relative/path/to/Module.cmake`
    путь внутри репозитория к CMake-модулю (можно рассматривать это поле как имя модуля).
- `X-Chewy-Version: Major.Minor`
    версия модуля
- `X-Chewy-AddonFile: addon/file/path`
    путь к дополнительным файлам модуля. Как правило это тестовые программы, которые пытается собрать
    модуль, шаблоны файлов, используемые в вызовах `configure_file()`, в общем все, что может понадобится
    модулю для его работы. В отличие от предыдущих полей, `X-Chewy-AddonFile` может быть указан несколько
    раз, чтобы подключить к модулю несколько зависимых файлов.


Например такие комментарии вставлены в модуль [AddBoostTests.cmake](https://github.com/mutanabbi/chewy-cmake-rep/blob/master/AddBoostTests.cmake)

    # X-Chewy-RepoBase: https://raw.github.com/mutanabbi/chewy-cmake-rep/master/
    # X-Chewy-Path: AddBoostTests.cmake
    # X-Chewy-Version: 2.1
    # X-Chewy-Description: Integrate Boost unit tests into CMake infrastructure

Для доступа к репозиторию `chewy` использует HTTP или HTTPS. Список доступных модулей должен содержатся в
индексном файле, находящемся в корне и называющимся `manifest`. Это обычный текстовый файл, и для его создания
и/или обновления предназначена утилита `chewy-update-manifest`, входящая в состав пакета `chewy`.

Для организации Chewy-репозиториев вполне годится [GitHub](https://github.com) (или любой другой онлайновый
version control сервис, предоставляющий доступ к файлам по HTTP[S]): с одной стороны — можно использовать `git`
для управления репозиторием, с другой — `chewy` для обновления из него модулей.

Вы можете хранить модули и зависимые файлы в "плоском" репозитории, содержащем лишь одну корневую директорию,
либо группировать файлы в сложное дерево поддиректорий — `chewy` лишь необходимы корректные относительные
пути в файле манифеста и мета-полях модуля.


**Внимание**
Заметим, что поскольку часть информации в манифесте и модуле дублируется, то во избежании ошибок ручного
копирования мы настоятельно рекомендуем использовать утилиту `chewy-update-manifest`. Будучи запущенной в
корне локальной копии репозитория с модулями, она просканирует файлы на предмет наличия мета-тегов и обновит
(или создаст, если необходимо) файл манифеста.


Ограничения
===========
1. [easy to fix harcode] расширение у модуля *.cmake
2. Файлы модулей должны иметь синтаксис, позволяющий игнорировать строки (комментарии), начинающиеся со знака # (для вставки X-Chewy-тегов)
3. центральное хранилище доступно по http[s]


Взгляд в более общий перспективе
================================

Вообще `Chewy` применим в случае, когда выполняются следующие условия:

1. Есть центральное хранилище
2. Центральное хранилище хранит множество "модулей"
3. [опционально] модули могут тащить за собой файлы-саттелиты
4. Модули необходимы для включения во множество локльных "проектов"
5. Изменения в модуле должны легко переноситься в проекты

А также смотрите
================

[![Downloads](https://pypip.in/d/chewy/badge.png)](https://pypi.python.org/pypi/chewy)
[![Downloads](https://pypip.in/v/chewy/badge.png)](https://pypi.python.org/pypi/chewy)
[![Build Status](https://api.travis-ci.org/mutanabbi/chewy.png?branch=master)](https://travis-ci.org/mutanabbi/chewy)

> `Chewy` — лучший второй пилот на свете!
