#!/usr/bin/python
#
# Copyright 2011 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""chkcrontab - Checks the correctness of crontab files.

Parse crontab files and check each type of line for potential syntax errors.

Basic usage:
  chkcrontab crontab_file
"""

__author__ = 'lyda@google.com (Kevin Lyda)'

import os
import sys
import chkcrontab_lib as check


def main(argv):
  if len(argv) != 2:
    print 'ERROR: No crontab file was specified.'
    sys.exit(1)
  log = check.LogCounter()
  print 'Checking correctness of %s' % argv[1]
  return check.CheckCrontab(argv[1], log)

if __name__ == '__main__':
  main(sys.argv)
